//
//  NSObject+KeyEventMonitor.h
//  MPServices
//
//  Created by vladislav.senyukov on 4/18/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSObject (KeyEventMonitor)
@property (nonatomic, readonly) id keyMonitor;
// basic
// extended classes are responsible for adding and removing key monitors, they should balance every add: call with corresponding remove: call otherwise memory leak is created
- (void)addKeyMonitorForMask:(NSEventMask)mask;
- (void)removeKeyMonitor;
// convenient
- (void)addKeyDownMonitor;
// to override
- (BOOL)onKeyEvent:(NSEvent*)event;
@end
