local LrApplication = import("LrApplication")
local LrTasks = import("LrTasks")
local LrPathUtils = import("LrPathUtils")
local LrFileUtils = import("LrFileUtils")

LrTasks.startAsyncTask(function()
	local catalog = LrApplication.activeCatalog()
	local tPhoto = catalog:getTargetPhoto()
	if tPhoto
	then
		local tPhotoPath = tPhoto.path
		local standardTempDirPath = LrPathUtils.getStandardFilePath('temp')
		local importFileName = LrPathUtils.child(standardTempDirPath, "ImportMPExtrasPluginAppName")

		if LrFileUtils.exists(importFileName)
		then
		  LrFileUtils.delete(importFileName)
		end
		local command = "MPLightroomBridgePath \"" .. tPhotoPath .. "\" -MPLightroomExtrasPluginResPath \"" .. importFileName .. "\""
		LrTasks.execute(command)
	end
end)
