<?php
!defined('P_W') && exit('Forbidden');

/**
 * ʪA
 * @author chenjm / sky_hold@163.com
 * @package active
 */

class PW_Active {
	
	var $_db;

	function PW_Active() {
		global $db;
		$this->_db =& $db;
	}
	
	/**
	 * ʫH
	 * return array
	 */
	function getActiveById($id) {
		static $array = array();
		if (!isset($array[$id])) {
			$array[$id] = $this->_db->get_one("SELECT * FROM pw_active WHERE id=" . S::sqlEscape($id));
		}
		return $array[$id];
	}
	
	/**
	 * ʸԲӫH
	 * return array
	 */
	function getActiveInfoById($id) {
		return $this->_db->get_one("SELECT a.*,m.username,m.icon FROM pw_active a LEFT JOIN pw_members m ON a.uid=m.uid WHERE a.id=" . S::sqlEscape($id));
	}
	
	/**
	 * ʸԱC
	 * return array
	 */
	function getAttById($id) {
		$array = array();
		$query = $this->_db->query("SELECT * FROM pw_actattachs WHERE actid=" . S::sqlEscape($id) . ' ORDER BY aid');
		while ($rt = $this->_db->fetch_array($query)) {
			$array[$rt['aid']] = $rt;
		}
		return $array;
	}
	
	/**
	 * Ysլʪέp
	 * return int
	 */
	function getActiveCount($cid) {
		return (int)$this->_db->get_value("SELECT COUNT(*) AS sum FROM pw_active WHERE cid=" . S::sqlEscape($cid));
	}
	
	/**
	 * ʦC
	 * @param $cid int sid
	 * @param $nums int եμƶq
	 * @param $start int 
	 * return array
	 */
	function getActiveList($cid, $nums, $start = 0) {
		$array = array();
		$query = $this->_db->query("SELECT * FROM pw_active WHERE cid=" . S::sqlEscape($cid) . ' ORDER by id DESC ' . S::sqlLimit($start, $nums));
		while ($rt = $this->_db->fetch_array($query)) {
			$array[] = $this->convert($rt);
		}
		return $array;
	}
	
	/**
	 * jʦC
	 * return array
	 */
	function searchList($where, $nums = null, $start = 0, $orderway = null, $ordertype = null, $count = false) {
		$sql = $this->sqlCompound($where);
		$order = $limit = '';$total = 0;
		if ($count) {
			$total = (int)$this->_db->get_value("SELECT COUNT(*) AS sum FROM pw_active WHERE 1" . $sql);
		}
		if ($nums) {
			$limit = S::sqlLimit($start, $nums);
		}
		if ($orderway) {
			!in_array($orderway, array('members','id')) && $orderway = 'id';
			$ordertype != 'ASC' && $ordertype = 'DESC';
			$order = " ORDER BY $orderway $ordertype";
		}
		$array = array();
		$query = $this->_db->query("SELECT * FROM pw_active WHERE 1" . $sql . $order . $limit);
		while ($rt = $this->_db->fetch_array($query)) {
			$array[] = $rt;
		}
		return array($array, $total);
	}
	
	/**
	 * Ysժ
	 * return array
	 */
	function getRelateActive($id, $nums) {
		$actids = $array = array();
		$query = $this->_db->query("SELECT distinct(a.actid) FROM pw_actmembers a LEFT JOIN pw_actmembers b ON a.uid=b.uid WHERE a.actid!=" . S::sqlEscape($id)." ORDER BY a.actid DESC " . S::sqlLimit(0, $nums));
		while ($rt = $this->_db->fetch_array($query)) {
			$actids[] = $rt['actid'];
		}
		$this->_db->free_result($query);
		if (!$actids) return $array;
		$query = $this->_db->query("SELECT id,title,cid,address,begintime,endtime,members,hits FROM pw_active WHERE id IN(".S::sqlImplode($actids).") ORDER BY id DESC");
		while ($rt = $this->_db->fetch_array($query)) {
			$array[] = $rt;
		}
		return $array;
	}

	function sqlIn($ids) {
		return (is_array($ids) && $ids) ? ' IN (' . S::sqlImplode($ids) . ')' : '=' . S::sqlEscape($ids);
	}

	function sqlCompound($where) {
		global $timestamp;
		if (!$where || !is_array($where)) {
			return;
		}
		$_sql_where = '';
		foreach ($where as $_sql_field => $value) {
			switch ($_sql_field) {
				case 'id':
				case 'cid':
				case 'uid':
					$_sql_where .= " AND $_sql_field" . $this->sqlIn($value);break;
				case 'type':
					$_sql_where .= " AND type=" . S::sqlEscape($value);break;
				case 'createtime_s':
					$_sql_where .= " AND createtime>=" . S::sqlEscape($value);break;
				case 'createtime_e':
					$_sql_where .= " AND createtime<=" . S::sqlEscape($value);break;
				case 'title':
					$_sql_where .= " AND title LIKE " . S::sqlEscape('%' . $value . '%');break;
				case 'activestate':
					if ($value == 5) {
						$_sql_where .= " AND endtime<" . S::sqlEscape($timestamp);
					} elseif($value == 4) {
						$_sql_where .= " AND deadline<" . S::sqlEscape($timestamp) . " AND begintime<" . S::sqlEscape($timestamp) . " AND endtime>" . S::sqlEscape($timestamp);
					} elseif($value == 3) {
						$_sql_where .= " AND deadline<" . S::sqlEscape($timestamp) . " AND begintime>" . S::sqlEscape($timestamp);
					} elseif($value == 2) {
						$_sql_where .= " AND limitnum!=0 AND members>=limitnum AND deadline>" . S::sqlEscape($timestamp);
					} elseif($value == 1) {
						$_sql_where .= " AND deadline>" . S::sqlEscape($timestamp) . ' AND (limitnum=0 OR members<limitnum)';
					}
					break;
			}
		}
		return $_sql_where;
	}

	function convert($data) {
		$data['begintime_s'] = get_date($data['begintime'], 'Y-m-d H:i');
		$data['endtime_s'] = get_date($data['endtime'], 'Y-m-d H:i');
		$data['deadline_s'] = $data['deadline'] ? get_date($data['deadline'], 'Y-m-d H:i') : '';
		if ($data['poster']) {
			list($data['poster_img']) = geturl($data['poster'], 'lf');
		} else {
			$data['poster_img'] = $GLOBALS['imgpath'] . '/defaultactive.jpg';
		}
		return $data;
	}
	
	/**
	 * W[@ӳWΤ
	 * @param $id int id
	 * @param $uid int Τid
	 * @param $info array WH
	 * return mixed
	 */
	function appendMember($id, $uid, $info) {
		if (($return = $this->checkJoinInfo($info)) !== true) {
			return $return;
		}
		$this->_db->update("INSERT INTO pw_actmembers SET " . S::sqlSingle(array(
			'uid'		=> $uid,
			'actid'		=> $id,
			'realname'	=> $info['realname'],
			'phone'		=> $info['phone'],
			'mobile'	=> $info['mobile'],
			'address'	=> $info['address'],
			'anonymous'	=> intval($info['anonymous'])
		)));
		$this->_db->update("UPDATE pw_active SET members=members+1 WHERE id=" . S::sqlEscape($id));
		return true;
	}
	
	/**
	 * ҥ[JʪXkH
	 * return mixed
	 */
	function checkJoinInfo($info) {
		if (!$info['realname']) {
			return 'жgumW!';
		}
		if (strlen($info['realname']) > 30) {
			return 'umWפWL30Ӧr`!';
		}
		if (!$info['mobile']) {
			return 'жgX!';
		}
		if (!preg_match("/^[\d\-]{1,15}$/", $info['mobile'])) {
			return 'LĪX!';
		}
		if ($info['phone'] && !preg_match("/^[\d\-]{1,15}$/", $info['phone'])) {
			return 'LĪqܸX!';
		}
		if ($info['address'] && strlen($info['address']) > 255) {
			return 'a}פWL255Ӧr`!';
		}
		return true;
	}
	
	function checkJoinStatus($id, $uid) {
		if ($this->isJoin($id, $uid)) {
			return 'AwgWF!';
		}
		$active = $this->getActiveById($id);

		if ($active['objecter'] == 1) {
			require_once(R_P . 'apps/groups/lib/colonys.class.php');
			$colonyServer = new PW_Colony();
			$cm = $colonyServer->getSingleMember($active['cid'], $uid);
			if (!$cm) {
				return 'A٤OssAХ[Js!';
			}
			if ($cm['ifadmin'] == -1) {
				return 'A٨SqLf֡AȮɤ[J!';
			}
		}
		if ($active['limitnum'] && $active['members'] >= $active['limitnum']) {
			return 'ʰѥ[HƤw!';
		}
		return true;
	}
	
	/**
	 * P_ΤO_[JYs
	 * return bool
	 */
	function isJoin($id, $uid) {
		if ($this->_db->get_one("SELECT id FROM pw_actmembers WHERE actid=" . S::sqlEscape($id) . ' AND uid=' . S::sqlEscape($uid))) {
			return true;
		}
		return false;
	}

	/**
	 * 
	 * return array
	 */
	function getHotActive($nums) {
		global $timestamp;
		$rt = $this->_db->get_one("SELECT * FROM pw_cache WHERE name='hotactive_3' AND time>" . S::sqlEscape($timestamp - 1800));
		if ($rt) {
			return unserialize($rt['cache']);
		} else {
			list($activedb) = $this->searchList(array('createtime_s' => $timestamp - 2592000), 3, 0, 'members', 'DESC');
			$this->_db->update("REPLACE INTO pw_cache SET " . S::sqlSingle(array('name' => 'hotactive_3', 'cache' => serialize($activedb), 'time' => $timestamp)));
			return $activedb;
		}
	}

	function updateHits($id, $hits = 1) {
		$this->_db->update("UPDATE pw_active SET hits=hits+" . S::sqlEscape($hits) . " WHERE id=" . S::sqlEscape($id));
	}
	
	/**
	 * hX
	 * void
	 */
	function quitActive($id, $uid) {
		$this->_db->update("DELETE FROM pw_actmembers WHERE actid=" . S::sqlEscape($id) . ' AND uid=' . S::sqlEscape($uid));
		if ($this->_db->affected_rows() > 0) {
			$this->_db->update("UPDATE pw_active SET members=members-1 WHERE id=" . S::sqlEscape($id));
		}
	}

	/**
	 * R
	 * void
	 */
	function delActive($id) {
		list($activedb) = $this->searchList(array('id' => $id));
		foreach ($activedb as $key => $value) {
			if ($value['poster']) {
				pwDelatt($value['poster'], $GLOBALS['db_ifftp']);
			}
			//* $this->_db->update("UPDATE pw_colonys SET activitynum=activitynum-1 WHERE id=". S::sqlEscape($value['cid']));
			$this->_db->update(pwQuery::buildClause("UPDATE :pw_table SET activitynum=activitynum-1 WHERE id=:id", array('pw_colonys',$value['cid'])));
		}
		$this->_db->update("DELETE FROM pw_actmembers WHERE actid" . $this->sqlIn($id));
		$this->_db->update("DELETE FROM pw_active WHERE id" . $this->sqlIn($id));
	}
	
	/**
	 * ʪѥ[H
	 * return array
	 */
	function getActMembers($id, $nums = null, $start = 0) {
		$limit = $nums ? S::sqlLimit($start, $nums) : '';
		$array = array();
		$query = $this->_db->query("SELECT a.*,m.username,m.icon,anonymous FROM pw_actmembers a LEFT JOIN pw_members m ON a.uid=m.uid WHERE a.actid=" . S::sqlEscape($id) . ' ORDER BY id ASC ' . $limit);
		while ($rt = $this->_db->fetch_array($query)) {
			list($rt['icon']) = showfacedesign($rt['icon'], 1, 'm');
			$array[] = $rt;
		}
		return $array;
	}

	function getCyidById($id) {
		return $this->_db->get_value("SELECT cid FROM pw_active WHERE id=" . S::sqlEscape($id));
	}
}
?>