<?php
!defined('P_W') && exit('Forbidden');

L::loadClass('PostActivity', 'activity', false);
require_once(R_P . 'require/functions.php');

class PW_ActivityForBbs extends PW_PostActivity {

	/**
	 * ʵoɪiHTML
	 * @param int $actmid ʤlID
	 * @param int $tid lID
	 * @return string iܪHTML
	 * @access public
	 */
	function getActHtml($actmid,$tid = 0) {
		global $imgpath,$mergedField;
		$activityFieldDb = array();
		$activityPostFieldsHtml = '<p class="w_title_p">'.getLangInfo('other','pc_must').'</p><br />'."<link rel=\"stylesheet\" type=\"text/css\" href=\"$imgpath/activity/post.css\" />";
		$activityPostFieldsHtml .= $this->getCheckPresetErrorMessage() . '
		<script type="text/javascript" src="js/date.js"></script><script type="text/javascript">
function addElement(basename) {
	var s = $(basename+\'_child\').firstChild.cloneNode(true);
	$(basename+\'_father\').appendChild(s);
}
function delParentElement(obj) {
	var o = obj.parentNode.parentNode;
	o.parentNode.removeChild(o);
}
function toggleCalendarInputValue(obj, defaultInputValue) {
	if (!obj.value) {
		obj.value = defaultInputValue;
		if (obj.className.indexOf("gray") == -1) {
			obj.className += " gray";
		}
	} else {
		obj.className = obj.className.replace("gray", "");
	}
}
</script>
<table width="100%" cellspacing="0" cellpadding="0" border="0">';

		if ($tid) { //s説A
			$defaultValueTableName = getActivityValueTableNameByActmid();
			$userDefinedValueTableName = getActivityValueTableNameByActmid($actmid, 1, 1);
			$mergedField = array();
			$mergedField = $this->db->get_one("SELECT actmid,iscancel,starttime,endtime,location,contact,telephone,picture1,picture2,picture3,picture4,picture5,signupstarttime,signupendtime,minparticipant,maxparticipant,userlimit,specificuserlimit,genderlimit,fees,feesdetail,paymethod,ut.* FROM $defaultValueTableName dt LEFT JOIN $userDefinedValueTableName ut USING(tid) WHERE dt.tid=".S::sqlEscape($tid));
			$mergedField['iscancel'] && Showmsg('act_iscancel_y_modify');//ʨALks
		}
		$query = $this->db->query("SELECT * FROM pw_activityfield WHERE actmid=".S::sqlEscape($actmid)." AND ifable=1 ORDER BY ifdel ASC, vieworder ASC, fieldid ASC");
		while ($rt = $this->db->fetch_array($query)) {
			if ($tid) { //s象pUOsrq
				$rt['fieldvalue'] = $mergedField[$rt['fieldname']];
				$rt['isedit'] = true;
			} else {
				$rt['fieldvalue'] = '';
				$rt['isedit'] = false;
			}
			//SrqBz
			if (in_array($rt['fieldname'],array('picture2','picture3','picture4','picture5'))) {
				unset($rt['name']);
			} elseif ($rt['fieldname'] == 'picture1' && $rt['fieldvalue']) {
				$rt['fieldvalue'] = array();
				for ($i=1; $i<=5; $i++) {
					$mergedField['picture'.$i] && $rt['fieldvalue']['picture'.$i] = $mergedField['picture'.$i];
				}
			}
			$rt['name'] && list($rt['name1'],$rt['name3'], $rt['name2']) = $this->getNamePartsByName($rt['name']);
			if ($rt['fieldid']) {
				$activityFieldDb[$rt['ifdel']][$rt['vieworder']][$rt['fieldid']] = $rt;
			}
		}
		
		$activityPostFieldsHtml .= $this->getAllSectionHtml($activityFieldDb);
		//ʴyz
		$activityPostFieldsHtml .= '<tr class="tr3">
			<td style="border-bottom:none"><table class="tgtable" width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<th colspan="2">' . getLangInfo('other','act_activity_desc') . '</th>
					</tr>
			</table></td>
		</tr>';
		$activityPostFieldsHtml .= '</table>';
		return $activityPostFieldsHtml;
	}
	

	function getCheckPresetErrorMessage()
	{

		$return = "
			<script text=\"text/javascript\">

			function getErrorMessageByKey(key) {

				var errorMessage = {
		";

			
		$errorMessage = $this->fieldCheck->getErrorMessage();
		$messageJsArray = '';

		foreach ($errorMessage as $key => $message) {

			$messageJsArray .= '"'.addslashes($key).'" : "'.addslashes($message).'" , ';

		}
		$messageJsArray = rtrim($messageJsArray, ', ');

		$return .= $messageJsArray."};\n";

		$return .= "
					return errorMessage[key].replace('{value}', '');

				}

			</script>
			<script text=\"text/javascript\" src=\"js/pw_activitycheck.js\"></script>
		";

		return $return;

	}

	/**
	 * ʦhϰrqHTML
	 * @param array $activityFieldDb rqƾڡAΦparray(bool O_Τ۩wqrq  => array(int ID => array(int rqID => array rqe)))
	 * @param string $showtype ipost:o read:\Ū
	 * @return string HTML
	 * @access public
	 */
	function getAllSectionHtml($activityFieldDb, $showtype = 'post') {
		$defaultSectionHtml = $userDefinedSectionHtml = '';
		foreach ($activityFieldDb as $ifdel => $defaultOrUserDefinedDb) {
			if ($showtype == 'read') {//le
				$sectionHtml = $this->getSectionvReadHtml($defaultOrUserDefinedDb);;
			} elseif ($showtype == 'post') {//orq
				$sectionHtml = $this->getSectionHtml($defaultOrUserDefinedDb);
			} else {
				$sectionHtml = '';
			}
			if ($ifdel){ //Τwqrq
				$userDefinedSectionHtml .= $sectionHtml;
			} else { //q{rq
				$defaultSectionHtml .= $sectionHtml;
			}
		}
		return $defaultSectionHtml.$userDefinedSectionHtml;
	}
	/**
	 * ^ʵoq{rqΥΤwqrqϰ쪺HTML
	 * @param array $data rqƾ Φparray(int ID => array(int rqID => array rqe))
	 * @return string HTML
	 * @access public
	 */
	function getSectionHtml($data) {
		$sectionHtml = '';
		$lastSectionName = '';
		foreach ($data as $vieworder => $line) {
			$lineHtml = $this->getLineHtml($line, $vieworder);
			//椤Ĥ@Ӥsectionname
			$keys = array_keys($line);
			$thisSectionName = $line[$keys[0]]['sectionname'];
			$thisSectionName || $thisSectionName = getLangInfo('other','act_other');
			if ($lastSectionName != $thisSectionName) { //sؤ@Ӱ϶
				if ($sectionHtml) {
					$sectionHtml .= '</table></td></tr>';
				}
				$sectionHtml .= '<tr class="tr3">
					<td><table class="tgtable" width="100%" cellspacing="0" cellpadding="0" border="0">';
				if ($thisSectionName) {
					$sectionHtml .= '<tr><th colspan="2">' . $thisSectionName . '</th></tr>';
				}
				$sectionHtml .= $lineHtml;
				$lastSectionName = $thisSectionName;
			} else {
				$sectionHtml .= $lineHtml;
			}
		}
		$sectionHtml .= '</table></td></tr>';
		return $sectionHtml;
	}
	/**
	 * ^ʵoɨC@檺rqHTML
	 * @param array $line rqƾڡAΦparray(int rqID => array rqe)
	 * @param bool $severalInputsPerLine ۦPƧǭȪrqO_ܦb@
	 * @return string HTML
	 * @access private
	 */
	function getLineHtml($line, $severalInputsPerLine) {
		if ($severalInputsPerLine) { //ۦPƧǭȪrqܦb@
			$fieldHtml = '';
			$i = 0;
			foreach ($line as $fieldid => $fieldValue) {
				$ifmust = '';
				$fieldValue['ifmust'] && $ifmust = '<em>*</em> ';
				if ($i == 0) {
					if ($fieldValue['fieldname'] == 'picture1') {//ϤSBz
						$fieldHtml .= '<tr><td class="tar black2" width="105" style="vertical-align:middle">' . $ifmust . $fieldValue['name1'].'J</td><td class="tal t_pic">';
					} else {
						$fieldHtml .= '<tr><td class="tar black2" width="105">' . $ifmust . $fieldValue['name1'].'J</td><td class="tal">';
					}
				} else {
					$fieldHtml .= $fieldValue['name1'].'&nbsp;';
				}

				$fieldHtml .= ($fieldValue['name3'] ? $fieldValue['name3'].' ' : '').$this->getActivityField($fieldValue).' '.$fieldValue['name2'];
				$i++;
			}
			$fieldHtml .= ' <span class="gray">' . $fieldValue['descrip'] . '</span></td></tr>';
		} else { //rqܦbWߪ
			$fieldHtml = '';
			foreach ($line as $fieldid => $fieldValue) {
				$ifmust = '';
				$fieldValue['ifmust'] && $ifmust = '<em>*</em> ';
				$fieldHtml .= '<tr><td class="tar black2" width="105">' . $ifmust . $fieldValue['name1'].'J</td><td>';
				$fieldHtml .= ($fieldValue['name3'] ? $fieldValue['name3'].' ' : '').$this->getActivityField($fieldValue).' '.$fieldValue['name2'];
				$fieldHtml .= ' <span class="gray">' . $fieldValue['descrip'] . '</span></td></tr>';
			}
		}
		return $fieldHtml;
	}
	/**
	 * K[챵HTML
	 * @param string $basename 򥻦W
	 * @return string HTML
	 * @access private
	 */
	function getAddRowHtml ($basename) {
		$titleNameText = ($basename == 'fees') ? 'act_add_fee_type' : 'act_add_fee_detail';
		$titleName = getLangInfo('other',$titleNameText);
		return '<em title="'.$titleName.'" class="aa_add" onclick="addElement(\''.$basename.'\');">[@</em>';
	}


	/**
	 * R챵HTML
	 * @param int $additionalNoteNumber B~K[node
	 * @return string HTML
	 * @access private
	 */
	function getRemoveRowHtml ($additionalNoteNumber = 0) {
		$deleteTypeText = getLangInfo('other','act_delete_type');
		$deleteLineText = getLangInfo('other', 'act_remove_line');
		$return = '<em title="' . $deleteTypeText . '" class="aa_remove" onclick="delParentElement(this);">' . $deleteLineText . '</em>';
		for ($i=0; $i<$additionalNoteNumber; $i++) {
			$return = '<span>'.$return.'</span>';
		}
		return $return;
	}
	/**
	 * K[@OΪHTML
	 * @param string $fieldname rqW
	 * @param string $condition K[value
	 * @param string $money gOvalue
	 * @param bool $isDefaultValue $conditionq{
	 * @param bool $isEditable O_is
	 * @param bool $ifMust O_g
	 * @return string HTML
	 * @access private
	 */
	function getFeesRowHtml($fieldname, $condition = '', $money = '', $isDefaultValue = 0, $isEditable = 1, $ifMust = 1) {
		$RMBText = getLangInfo('other','act_RMB');
		$perPeopleText = getLangInfo('other','act_per_people');
		if (!$isEditable) {
			return $money . $RMBText . '/'.$condition . ' <input class="input" type="hidden" name="act['.$fieldname.'][money][]" value="'. $money. '" />
			<input type="hidden" name="act[' . $fieldname . '][condition][]" value="' . $condition . '" />';
		}
		$ifMust = $ifMust ? 1 : 0;
		return '<input id="fees_default" class="input mr10" type="text" name="act[' . $fieldname . '][condition][]" value="' . $condition. '" size="5"
			 /></td><td>
			 ' . $perPeopleText . ' <input class="input" type="text" onblur="showError(this, getMoneyError(this, 1));" name="act['.$fieldname.'][money][]" value="'. $money. '" size="4" />
			 ' . $RMBText;
	}
	/**
	 * K[@OΩӪHTML
	 * @param string $fieldname
	 * @param string $item 
	 * @param string $money OAp10.50
	 * @param bool $isEditable O_is
	 * @param bool $ifMust O_g
	 * @return string HTML
	 * @access private
	 */
	function getFeesDetailRowHtml($fieldname, $item = '', $money = '', $isEditable = 1, $ifMust = 1) {
		if ($isEditable) {
			$ifMust = $ifMust ? 1 : 0;
			return '<input class="input mr10" type="text" name="act[' . $fieldname . '][item][]" value="' . $item. '" size="20" /></td>
					<td><input onblur="showError(this, getMoneyError(this, '.$ifMust.'));" class="input" type="text" name="act['.$fieldname.'][money][]" value="'. $money. '" size="4" /> ';
		} else {
			return $item . '</td><td>' . $money;
		}
	}
	/**
	 * oɬʶOΪHTML
	 * @param array $data
	 * @param $isEditable
	 * @return string HTML
	 * @access private
	 */
	function getFeesFieldHtml($data, $isEditable = true) {
		$value = $data['fieldvalue'];
		//$valueɪΦӦp$value = array(array('condition' => 'Male', 'money' => '1.00'), array('condition' => 'Female', 'money' => '2.00'));
		$value = unserialize($value);
		if (!$isEditable) {
			$return = '';
			$rulesHtml = '';
			if ($value) {
				foreach ($value as $rule) {
					$rulesHtml .= $this->getFeesRowHtml($data['fieldname'], $rule['condition'], $rule['money'], 0, $isEditable, 0).'A';
				}
				$rulesHtml = trim($rulesHtml, 'A');
				$return .= $rulesHtml.'<br />';
			} else {
				$return .= getLangInfo('other','act_free');
			}
		} else {
			$return = '<table class="table_cost" cellspacing="0" cellpadding="0">';
			$return .= '<tbody id="fees_father">';
			if ($value) {
				$i = 0;
				foreach ($value as $rule) {
					$ifMust = 1 == $i && $data['ifmust'] ? 1 : 0;
					$return .= '<tr><td width="40">'.$this->getFeesRowHtml($data['fieldname'], $rule['condition'], $rule['money'], 0, $isEditable, $ifMust);
					if ($isEditable) {
						$return .= $i == 0 ? $this->getAddRowHtml('fees') : $this->getRemoveRowHtml(0);
					}
					$return .= '</td>';
					$return .= '</tr>';
					$i++;
				}
			} else {
				$ifMust = $data['ifmust'] ? 1 : 0;
				$allPeopleText = getLangInfo('other','act_all_people');
				$return .= '<tr><td width="40">' . $this->getFeesRowHtml($data['fieldname'], $allPeopleText, '' , 1, $isEditable, $ifMust) . ($isEditable ? $this->getAddRowHtml('fees') : '') . '</td></tr>';
			}
	
			$return .= '</tbody>';
			$return .= '<tbody id="fees_child" style="display: none"><tr><td>' . $this->getFeesRowHtml($data['fieldname'], '', '', 0, 1, 0) . $this->getRemoveRowHtml(0) . '</td></tr></tbody>';
			$return .= '</table>';
		}
		return $return;
	}
	/**
	 * oɶOΩӪHTML
	 * @param array $data
	 * @return string HTML
	 * @access private
	 */
	function getFeesDetailFieldHtml($data) {
		$return = '<table class="table_cost" cellspacing="0" cellpadding="0">';
		$return .= '<thead><tr><th width="160">' . getLangInfo('other','act_fee_desc') . '</th><th>' . getLangInfo('other','act_fee_unit') . '</th></tr></thead>';
		$return .= '<tbody id="feesdetail_father">';
		$value = unserialize($data['fieldvalue']);
		if ($value) {
			//$valueɪΦӦp$value = array(array('item' => 'traffic', 'money' => '1.00'), array('item' => 'food', 'money' => '2.00'));
			$i = 0;
			foreach ($value as $rule) {
				$ifMust = 1 == $i && $data['ifmust'] ? 1 : 0;
				$return .= '<tr><td>'.$this->getFeesDetailRowHtml($data['fieldname'], $rule['item'], $rule['money'], 1, $ifMust);
				$return .= $i == 0 ? $this->getAddRowHtml('feesdetail') : $this->getRemoveRowHtml();
				$return .= '</td>';
				$return .= '</tr>';
				$i++;
			}
		} else {
			$ifMust = $data['ifmust'] ? 1 : 0;
			$return .= '<tr><td>' . $this->getFeesDetailRowHtml($data['fieldname'], '', '', 1, $ifMust) . $this->getAddRowHtml('feesdetail') . '</td></tr>';
		}

		$return .= '</tbody>';
		$return .= '<tbody id="feesdetail_child" style="display: none"><tr><td>' . $this->getFeesDetailRowHtml($data['fieldname'], '', '', 1, 0) . $this->getRemoveRowHtml() . '</td></tr></tbody>';
		$return .= '</table>';
		return $return;
	}
	/**
	 * ocalendarrqHTML
	 * @param array $data
	 * @param $editable ȬO_is
	 * @return string HTML
	 * @global int eɶW
	 */
	function getCalendarFieldHtml($data, $editable = true) {
		if (!$data['fieldvalue'] && $data['ifmust']) {
			 if ($data['fieldname'] == 'endtime' ||$data['fieldname'] == 'signupendtime') {
			 	$data['fieldvalue'] = $this->timestamp+2592000;
			 } else {	
			 	$data['fieldvalue'] = $this->timestamp;
			 }
			$className = 'gray';
			$isDefaultValue = true;
		} else {
			$className = '';
			$isDefaultValue = false;
		}
		$rules = $data['rules'];
		$data['fieldvalue'] = $data['fieldvalue'] ? $this->getTimeFromTimestamp($data['fieldvalue'], $rules['precision']) : '';
		if ('minute' == $rules['precision']) { //ɶT
			$showCalendarJsOption = 1;
		} else { //ɶT
			$showCalendarJsOption = 0;
		}
		$jsAdd = $isDefaultValue && $data['ifmust'] ? ' onblur="toggleCalendarInputValue(this, \''.$data['fieldvalue'].'\');"' : '';
		if ($editable) {
			if ($data['ifmust']) {
				$showError = "onblur=\"showError(this, getCalendarError(this, '".$data['fieldname']."'));\"";
			}
			return '<input id="calendar_'.$data['fieldname']."\" type=\"text\" class=\"input $className\" name=\"act[".$data['fieldname']."]\" 
				value=\"".$data['fieldvalue']."\" $showError onclick=\"ShowCalendar(this.id,$showCalendarJsOption);\" $jsAdd size=\"".$data['textwidth']."\" />";
		} else {
			return "<input id=\"calendar_".$data['fieldname']."\" type=\"hidden\" name=\"act[".$data['fieldname']."]\" value=\"".$data['fieldvalue']."\" />" . $data['fieldvalue'];
		}
	}
	function getMaxParticipantHtml($data,$isEditable = true) {
		if ($isEditable) {
			$L = array(
				'alreadySignup' => $this->getPeopleAlreadySignup(),
			);
			$this->getPeopleAlreadySignup() && $onfocus = 'onfocus="$(\'alert-alipay\').style.display=\'\';"';

			return '<span class="pr" style="padding-top:3px">
			<input id="maxparticipant" '. $onfocus . '
			 onblur="$(\'alert-alipay\').style.display=\'none\'; showError(this, getParticipantError(this, ' .$this->getPeopleAlreadySignup(). '));" class="input mr5" type="text" name="act[' . $data['fieldname'] . ']" value="' . $data['fieldvalue'] . '" size="' . $data['textwidth'] . '">
			<span id="alert-alipay" class="alert-alipay" style="display: none">' .($this->getPeopleAlreadySignup() ? getLangInfo('other','act_signup_info',$L) : '') . '<i></i></span>
			</span>';
		} else {
			return '<input id="maxparticipant" class="input mr5" type="hidden" name="act[' . $data['fieldname'] . ']" value="' . $data['fieldvalue'] . '" size="' . $data['textwidth'] . '">'.$data['fieldvalue'];
		}
		
	}
	function getMinParticipantHtml($data,$isEditable = true) {
		if ($isEditable) {
			return '<span class="pr"><input id="minparticipant" onblur="showError(this, getParticipantError(this, ' .$this->getPeopleAlreadyPaid(). '));" class="input mr5" type="text" name="act[' . $data['fieldname'] . ']" value="' . $data['fieldvalue'] . '" size="' . $data['textwidth'].'" /></span>';
		} else {
			return '<input id="minparticipant" type="hidden" name="act[' . $data['fieldname'] . ']" value="' . $data['fieldvalue'] . '" size="' . $data['textwidth'].'" />' . $data['fieldvalue'];
		}
	}
	function getTelephoneHtml ($data) {
		return '<input id="' . $data['fieldname'] . "\" onblur=\"showError(this, getTelephoneError(this))\" type=\"text\" class=\"input\" name=\"act[" . $data['fieldname'] . "]\" value=\"" . $data['fieldvalue'] . "\" size=\"" . $data['textwidth'] . "\"/>";
	}
	
	function getContactHtml ($data) {
		return '<input id="' . $data['fieldname'] . "\" onblur=\"showError(this, getContactError(this))\" type=\"text\" class=\"input\" name=\"act[" . $data['fieldname'] . "]\" value=\"" . $data['fieldvalue'] . "\" size=\"" . $data['textwidth'] . "\"/>";
	}

	/**
	 * ^ʵoɨC@rqHTML
	 * @param array $data
	 * @return string
	 */
	function getActivityField($data) {
		global $action,$tid,$imgpath,$attachpath,$mergedField;
		$actmid = $this->actmid;
		$acthtml = '';

		$textsize = $data['textwidth'] = $data['textwidth'] ? $data['textwidth'] : 20;
		$data['rules'] && $data['rules'] = unserialize($data['rules']);
		//q{ˬd
		if ($data['ifmust']) {
			$pccheck = 'check="/^.+$/"';
			$error = 'error=""';
		}
		if ($data['fieldname'] == 'fees') {
			$isEditable = true;
			$activityStatusKey = $this->getActivityStatusKey($mergedField, $this->timestamp, $this->peopleAlreadySignup($tid));//ʪA
			if ($action == 'modify' && ($this->getPeopleAlreadySignup() || $this->getPeopleAlreadySignup() && $activityStatusKey == 'signup_is_ended' || in_array($activityStatusKey,array('activity_is_ended','activity_is_running')))) {//wHWBʤwBʶi椤BW
				$isEditable = false;
			}
			$acthtml .= $this->getFeesFieldHtml($data, $isEditable);
		} elseif ($data['fieldname'] == 'feesdetail') {
			$acthtml .= $this->getFeesDetailFieldHtml($data);
		} elseif ($data['fieldname'] == 'maxparticipant') {
			$isEditable = true;
			$activityStatusKey = $this->getActivityStatusKey($mergedField, $this->timestamp, $this->peopleAlreadySignup($tid));//ʪA
			if ($action == 'modify' && ($this->getPeopleAlreadySignup() && $activityStatusKey == 'signup_is_ended' || in_array($activityStatusKey,array('activity_is_ended','activity_is_running')))) {//ʤwBʶi椤BW
				$isEditable = false;
			}
			$acthtml .= $this->getMaxParticipantHtml($data,$isEditable);
		} elseif ($data['fieldname'] == 'minparticipant') {
			$isEditable = true;
			$activityStatusKey = $this->getActivityStatusKey($mergedField, $this->timestamp, $this->peopleAlreadySignup($tid));//ʪA
			if ($action == 'modify' && ($this->getpeopleAlreadySignup() && $activityStatusKey == 'signup_is_ended' || in_array($activityStatusKey,array('activity_is_ended','activity_is_running')))) {//wHIBʤwBʶi椤
				$isEditable = false;
			}
			$acthtml .= $this->getMinParticipantHtml($data,$isEditable);
		
		} elseif ($data['fieldname'] == 'contact') {
			$acthtml .= $this->getContactHtml($data);
		} elseif ($data['fieldname'] == 'telephone') {
			$acthtml .= $this->getTelephoneHtml($data);
		} elseif ($data['type'] == 'number') {
			if ($data['rules']['minnum'] && $data['rules']['maxnum']) {
				$pccheck = "check=\"{$data['rules']['minnum']}-{$data['rules']['maxnum']}\"";
				if ($data['ifmust']) {
					$error = 'error="rang_error"';
				} else {
					$error = 'error="rang_error2"';
				}
			} else {
				$pccheck = 'check="/^\d+$/"';
				if ($data['ifmust']) {
					$error = 'error="number_error"';
				} else {
					$error = 'error="number_error2"';
				}
			}
			$acthtml .= "<input type=\"text\" $pccheck $error class=\"input\" name=\"act[" . $data['fieldname'] . "]\" value=\"" . $data['fieldvalue'] . "\" size=\"" . $data['textwidth'] . "\">";
			if ($data['rules']['minnum'] && $data['rules']['maxnum']) {
				$acthtml .= " <span class='gray'>(".getLanginfo('other','pc_defaultname')."{$data['rules']['minnum']} ~ {$data['rules']['maxnum']})</span>";
			}
		} elseif ($data['type'] == 'email') {
			$pccheck = 'check="/^[-a-zA-Z0-9_\.]+@([0-9A-Za-z][0-9A-Za-z-]+\.)+[A-Za-z]{2,5}$/"';
			if ($data['ifmust']) {
				$error = 'error="email_error"';
			} else {
				$error = 'error="email_error2"';
			}
			$acthtml .= "<input type=\"text\" $pccheck $error class=\"input\" name=\"act[" . $data['fieldname'] . "]\" value=\"" . $data['fieldvalue'] . "\" size=\"" . $data['textwidth'] . "\"/>";
		} elseif ($data['type'] == 'range') {
			$pccheck = 'check="/^\d+$/"';
			if ($data['ifmust']) {
				$error = 'error="number_error"';
			} else {
				$error = 'error="number_error2"';
			}
			$acthtml .= "<input type=\"text\" $pccheck $error class=\"input\" name=\"act[" . $data['fieldname'] . "]\" value=\"" . $data['fieldvalue'] . "\" size=\"". $data['textwidth'] . "\"/>";
		} elseif (in_array($data['type'],array('text','img','url'))) {
			$acthtml .= "<input id=\"" . $data['fieldname'] . "\" type=\"text\" $pccheck $error class=\"input\" name=\"act[" . $data['fieldname'] . "]\" value=\"" . $data['fieldvalue'] . "\" size=\"" . $data['textwidth'] . "\"/>";
		} elseif ($data['type'] == 'radio') {
			$activityStatusKey = $this->getActivityStatusKey($mergedField, $this->timestamp, $this->peopleAlreadySignup($tid));//ʪA

			$i = 0;
			if ($data['fieldname'] == 'genderlimit' && $action == 'new') {
				$onchange = "onclick=\"changeFeeValue(this.value);\"";
				$allPeopleText = getLangInfo('other','act_all_people');
				$maleText = getLangInfo('other','act_male');
				$femaleText = getLangInfo('other','act_female');
				$acthtml .= "
<script type=\"text/javascript\">
function changeFeeValue(value) {
	if (value == 1) {
		$('fees_default').value = $allPeopleText;
	} else if (value == 2) {
		$('fees_default').value = $maleText;
	} else if (value == 3) {
		$('fees_default').value = $femaleText;
	}
}
</script>";
			}
			if ($data['fieldname'] == 'paymethod') {//{IMI_
				krsort($data['rules']);
				reset($data['rules']);
			}
			foreach ($data['rules'] as $rk => $rv){
				$i++;
				$checked = '';
				$rv_value = substr($rv,0,strpos($rv,'='));
				$rv_name = substr($rv,strpos($rv,'=')+1);
				if ($data['fieldvalue']) {
					$rv_value == $data['fieldvalue'] && $checked = 'checked';
				} elseif (in_array($data['fieldname'],array('paymethod','userlimit','genderlimit'))) {
					if ($data['fieldname'] == 'paymethod') {//pGwgjwåBW{ҳqL
						$tradeinfo = $this->db->get_value("SELECT tradeinfo FROM pw_memberinfo WHERE uid=".S::sqlEscape($this->winduid));
						if ($tradeinfo) {
							$tradeinfo = unserialize($tradeinfo);
							$iscertified = $tradeinfo['iscertified'];
							$user_id = $tradeinfo['user_id'];
						}
						if ($user_id && $iscertified == 'T' && $rv_value == 1) {
							$checked = 'checked';
							$payDbTemp = array();
							$payDbTemp['alipay'] = 1;
						}
						if (!$payDbTemp['alipay'] && $rv_value == 2) {
							$checked = 'checked';
						}

					}
					if ($data['fieldname'] == 'userlimit' && $rv_value == 1) $checked = 'checked';
					if ($data['fieldname'] == 'genderlimit' && $rv_value == 1) $checked = 'checked';
				} elseif ($i == 1) {
					$checked = 'checked';
				}
				if ($data['fieldname'] == 'paymethod' && $rv_value == 1 && !$this->getPeopleAlreadyPaid()) {
					$onchange = "onclick=\"user_authentication(this.value);\"";
					$acthtml .= "
<script type=\"text/javascript\">
function user_authentication(paymethod) {
	if (paymethod == 1) {
		ajax.send('pw_ajax.php?action=activity&job=user_authentication','',function(){
			var rText = ajax.request.responseText.split('\t');
			if (rText[0] == 'iscertified_fail') {
				showDialog('warning','" . getLangInfo('other','act_unauth_alipay') . "');return false;
			} else if (rText[0] == 'isbinded_fail') {
				showDialog('warning','" . getLangInfo('other','act_unbind_alipay') . "');return false;
			} else {
				return true;
			}
		});
	} else {
		return false;
	}
}
</script>";
				}
				
				if ($data['fieldname'] == 'paymethod' && $action == 'modify' && ($this->getPeopleAlreadySignup() || in_array($activityStatusKey,array('activity_is_ended','activity_is_running')))) {//wHIBʤwBʶi椤
					if ($rv_value == $data['fieldvalue']) {
						$acthtml .= "<span class=\"fl w\"><input type=\"hidden\" value=\"" . $data['fieldvalue'] . "\" name=\"act[" . $data['fieldname'] . "]\" id=\"AlreadyPaid\" /> $rv_name </span>";
					} else {
						$acthtml .= '';
					}
				} else {
					$acthtml .= "<span class=\"fl w\"><input $onchange type=\"radio\" name=\"act[" . $data['fieldname'] . "]\" value=\"$rv_value\" $checked /> $rv_name </span>";
				}
			}
		} elseif ($data['type'] == 'checkbox') {
			foreach($data['rules'] as $ck => $cv){
				$checked = '';

				if ($data['ifmust']) {
					$pccheck = "check=\"1-\"";
				} else {
					$pccheck = "";
				}

				$cv_value = substr($cv,0,strpos($cv,'='));
				$cv_name = substr($cv,strpos($cv,'=')+1);
				if (strpos(",".$data['fieldvalue'].",",",".$cv_value.",") !== false) {
					$checked = 'checked';
				}
				$acthtml .= "<span class=\"fl w\"><input $pccheck type=\"checkbox\" name=\"act[" . $data['fieldname'] . "][]\" value=\"$cv_value\" $checked /> $cv_name </span>";
			}
		} elseif ($data['type'] == 'textarea') {
			$acthtml .= "<textarea type=\"text\" $pccheck name=\"act[" . $data['fieldname'] . "]\" rows=\"4\" class=\"input\" cols=\"" . $data['textwidth'] . "\"/>" . $data['fieldvalue'] . "</textarea>";
		} elseif ($data['type'] == 'select') {
			$acthtml .= "<select name=\"act[" . $data['fieldname'] . "]\">";
			foreach($data['rules'] as $sk => $sv){
				$selected = '';
				$sv_value = substr($sv,0,strpos($sv,'='));
				$sv_name = substr($sv,strpos($sv,'=')+1);
				$sv_value == $data['fieldvalue'] && $selected = 'selected';
				$acthtml .= "<option value=\"$sv_value\" $selected>$sv_name</option>";
			}
			$acthtml .= "</select>";
		} elseif ($data['type'] == 'calendar') {
			$activityStatusKey = $this->getActivityStatusKey($mergedField, $this->timestamp, $this->peopleAlreadySignup($tid));//ʪA
			if (!$data['ifdel'] && $action == 'modify' && ('activity_is_ended' == $activityStatusKey || 'signupstarttime' == $data['fieldname'] && $this->getPeopleAlreadySignup() || 'signup_is_ended' == $activityStatusKey && $this->getPeopleAlreadyPaid() && in_array($data['fieldname'],array('signupstarttime','signupendtime')) || 'activity_is_running' == $activityStatusKey && $data['fieldname'] != 'endtime')) {//ʤwBwHWBWBwHIBʶi椤
				$acthtml .= $this->getCalendarFieldHtml($data, 0);
			} else {
				$acthtml .= $this->getCalendarFieldHtml($data, 1);
			}
		} elseif ($data['type'] == 'upload') {
			$imgs = '';
			if ($data['fieldname'] == 'picture1') {
				$nonedisplay = '';
				if ($data['fieldvalue']) {
					$nonedisplay = 'style="display:none;"';
				}
				$imgs .= "<div class=\"t_img\" $nonedisplay id=\"img_picture_0\"><img src=\"$imgpath/activity/no_img.png\"/></div>";
				for ($i=1; $i<=5; $i++) {
					$picvalue = $data['fieldvalue']['picture'.$i];
					$valuedisplay = '';
					if (empty($picvalue)) {
						$valuedisplay = 'style="display:none;"';
					}
					$picpath = PW_PostActivity::getActivityImgUrl($picvalue,true);
					$imgs .= "<input id=\"fetch_{$i}\" type=\"hidden\" name=\"act[picture{$i}]\" value=\"$picvalue\"/><div $valuedisplay class=\"t_img\" id=\"img_picture_{$i}\"><img id=\"act_pic_" . $data['fieldid'] . "\" src=\"$picpath\"/><a href=\"javascript:;\" onclick=\"delpicture('{$i}','$actmid','$tid','" . $data['fieldid'] . "');return false;\">".getLangInfo('other','pc_delimg')."</a></div>";
				}

				$acthtml .= "$imgs <input type=\"button\" class=\"btn\" value=\"" . getLangInfo('other','act_upload_img') . "\" onclick=\"uploadpicture('$actmid')\"><p>" . $data['descrip'] . "</p>";
				$acthtml .= '
<script type="text/javascript">
function uploadpicture(actmid) {
	var total = 0;
	for (var i=1; i<=5; i++) {
		var element_name = "act[picture" + i + "]";
		var value = document.getElementsByName(element_name)[0].value;
		if (value != "") {
			continue;
		} else {
			total ++ ;
		}
	}
	if (total == 0) {
		showDialog("error","' . getLangInfo('other','act_upload_img_max') . '",2);return false;
	} else {
		try {ajax.send("pw_ajax.php?action=activity&job=upload&actmid="+actmid,"",ajax.get);} catch(e){}
	}
}
function delpicture(id,actmid,tid,fieldid){
	var total = 0;
	for (var i=1; i<=5; i++) {
		var element_name = "act[picture" + i + "]";
		var value = document.getElementsByName(element_name)[0].value;
		if (value != "") {
			continue;
		} else {
			total ++ ;
		}
	}
	if (total == 4) {
		$("img_picture_0").style.display = "";
	}
	fieldid = parseInt(fieldid);
	id = parseInt(id);
	fieldid = fieldid + id - 1;
	ajax.send("pw_ajax.php?action=activity&job=delimg","actmid="+actmid+"&fieldid="+fieldid+"&tid="+tid+"&attachment="+$("fetch_"+id).value,function(){
		var rText = ajax.request.responseText;
		if (rText == "success") {
			$("img_picture_" + id).style.display = "none";
			$("img_picture_" + id).children[0].src = "";
			document.getElementsByName("act[picture" + id + "]")[0].value = "";
		} else {
			showDialog("error","' . getLangInfo('other','act_delete_fail') . '",2);return false;
			return false;
		}
	});
}
</script>';
				
			} elseif (in_array($data['fieldname'],array('picture2','picture3','picture4','picture5'))) {
				$acthtml .= "";
			} else {
				if ($data['fieldvalue']) {
					$data['fieldvalue'] = PW_PostActivity::getActivityImgUrl($data['fieldvalue'],true);
					$imgs = "<span id=\"img_" . $data['fieldid'] . "\"><img src=\"{$data['fieldvalue']}\" width=\"195px\"/><a href=\"javascript:;\" onclick=\"delimg('$actmid','" . $data['fieldid'] . "');\">".getLangInfo('other','pc_delimg')."</a></span>";
					$imgs .= "
<script language=\"javascript\">
function delimg(actmid,fieldid) {
ajax.send('pw_ajax.php?action=activity&job=delimg','actmid='+actmid+'&fieldid='+fieldid+'&tid='+'$tid',function(){
    var rText = ajax.request.responseText;
    if (rText == 'success') {
        showDialog('success','" . getLangInfo('other','act_delete_success') . "',2); return false;
        $('img_'+fieldid).style.display = 'none';
    } else {
        showDialog('error','" . getLangInfo('other','act_delete_fail') . "',2);return false;
        return false;
    }
});
}
</script>";
				}
				$acthtml .= "<input type=\"file\" class=\"bt\" name=\"act_" . $data['fieldid'] . "\" size=\"" . $data['textwidth'] . "\">$imgs";
			}
		} else {
			$acthtml = "";
		}
		return $acthtml;
	}

	/** 
	 * oʤlHTML
	 * @param int $actmid ҪO]l^id
	 * @param int $fid id
	 * @return string ʤܵHTML
	 */
	function getActSelHtml($actmid,$fid) {
		$fid = (int)$fid;
		$actmid = (int)$actmid;
		$actmiddb = explode(",",$this->forum->foruminfo['actmids']);

		//$selectmodelhtml = '<div class="w_title_ip pr" style="margin-left: 5px;">';
		$selectmodelhtml = '<div style="margin-left: 5px;">';
		$selectmodelhtml .= "<select name=\"actmid\" onchange=\"window.onbeforeunload = function(){};window.location.href='post.php?fid='+'$fid'+'&actmid='+this.value\">";
		
		$newactcatedb = array();
		$activityModelDb = $this->getActivityModelDb();
		$activityCateDb = $this->getActivityCateDb();
		foreach ($actmiddb as $value) {
			$newactcatedb[$activityModelDb[$value]['actid']] = 1;
		}
		$options = array();

		foreach ($activityCateDb as $key => $value) {
			if ($value['ifable'] && $newactcatedb[$key]) {
				$label = $activityCateDb[$key]['name'];
				foreach ($actmiddb as $val) {
					if ($activityModelDb[$val]['actid'] == $key && $activityModelDb[$val]['ifable']) {
						$options[$label][$val] =  $activityModelDb[$val]['name'];
					}
				}
			}
		}
		$selectmodelhtml .= getSelectHtml($options, $actmid, '');
		$selectmodelhtml .= "</select></div>";
		return $selectmodelhtml;
	}

	/**
	 * ^ʾ\ŪAAHTML/le
	 * @param int $actmid ʼҪOid
	 * @param array $actdb rqȡAΦparray(bool [rq]  => rq,)
	 * @return string HTML
	 * @access private
	 */
	function getActValue($actmid ,$actdb = array()) {
		global $tid,$imgpath,$authorid,$subject,$paymethod;
		
		if (!isset($this->activitymodeldb[$actmid])) return;

		$activityReadFieldsHtml = "<link rel=\"stylesheet\" type=\"text/css\" href=\"$imgpath/activity/read.css\" />".'<div class="cc">';
		$FlashHtml = "<div id=\"pwSlidePlayer\" class=\"pwSlide fr\" style=\"margin-right:60px;\">";

		$activityValue = array();
		$defaultValueTableName = getActivityValueTableNameByActmid();
		if (isset($actdb) && count($actdb) > 0) {
			$tempdb = $this->db->get_one("SELECT iscertified,iscancel,paymethod,batch_no,fees,feesdetail FROM $defaultValueTableName WHERE tid=".S::sqlEscape($tid));
			$activityValue = $actdb;
			!$activityValue['fees'] && $activityValue['fees']		= $tempdb['fees'];
			!$activityValue['fees'] && $activityValue['feesdetail'] = $tempdb['feesdetail'];
			$activityValue['iscertified']	= $tempdb['iscertified'];
			$activityValue['batch_no']		= $tempdb['batch_no'];
			$activityValue['paymethod']		= $tempdb['paymethod'];
			$activityValue['iscancel']		= $tempdb['iscancel'];
		} else {
			$userDefinedValueTableName = getActivityValueTableNameByActmid($actmid, 1, 1);
			$activityValue = $this->db->get_one("SELECT iscertified,iscancel,actmid,out_biz_no,batch_no,recommend,starttime,endtime,location,contact,telephone,picture1,picture2,picture3,picture4,picture5,signupstarttime,signupendtime,minparticipant,maxparticipant,userlimit,specificuserlimit,genderlimit,fees,feesdetail,paymethod,pushtime,updatetime,ut.* FROM $defaultValueTableName dt LEFT JOIN $userDefinedValueTableName ut USING(tid) WHERE dt.tid=".S::sqlEscape($tid));
		}
		/*ƾڥ椬*/
		if ($this->timestamp - $activityValue['pushtime'] > 86400 && $activityValue['updatetime'] > $activityValue['pushtime']) {//Cs@\WCܰ
			$this->pushActivityToAppCenter($tid,$actmid);
		}
		/*ƾڥ椬*/

		if (!unserialize($activityValue['feesdetail'])) unset($activityValue['feesdetail']);//OΩܶq
		$activityValue['authorid'] = $authorid;//@̽
		$paymethod = $activityValue['paymethod'];//I覡

		/*ʥ{ҡAˬdO_I_jw+W{ _hЫAAʸ*/
		list($signupStaus,$isCertifiedHtml) = $this->isCertified($activityValue,$tid,$actmid);
		$activityReadFieldsHtml .= $isCertifiedHtml;
		/*ʥ{ҡAˬdO_I_jw+W{ _hЫAAʸ*/

		$tmpCount = 0;
		$flash = false;
		$activityFieldDb = $signupDb = array();
		$query = $this->db->query("SELECT * FROM pw_activityfield WHERE actmid=".S::sqlEscape($actmid)." AND ifable=1 ORDER BY ifdel ASC, vieworder ASC, fieldid ASC");
		while ($rt = $this->db->fetch_array($query)) {
			$activityValue && $rt['fieldvalue'] = $activityValue[$rt['fieldname']];
			$rt['name'] && list($rt['name1'],$rt['name3'], $rt['name2']) = $this->getNamePartsByName($rt['name']);
			if (($rt['type'] == 'img' || $rt['type'] == 'upload') && $rt['fieldvalue']) {
				$tmpCount ++;
				$rt['type'] == 'upload' && $rt['fieldvalue'] = PW_PostActivity::getActivityImgUrl($rt['fieldvalue'],true);
				$FlashHtml .= "<div id=\"Switch_" . $rt['fieldname'] . "\" style=\"display:none;display: block;\"><img src=\"{$rt['fieldvalue']}\" width=\"240px\"/></div>";
				$flash = true;
			}
			if ($rt['type'] == 'textarea') {
				$rt['fieldvalue'] = nl2br($rt['fieldvalue']);
			}
			if ($rt['fieldid']) {
				$activityFieldDb[$rt['ifdel']][$rt['vieworder']][$rt['fieldid']] = $rt;
			}
		}

		//ܬ
		$activityReadFieldsHtml .= '<ul class="aa_infos"><li><em>' . getLangInfo('other','act_activity_type') . '</em>'.$this->activitymodeldb[$this->actmid]['name'];

		if ($signupStaus == true && $this->winduid) {
			$activityReadFieldsHtml .= " &nbsp;<a href=\"read.php?tid=$tid#memberlist_show\">(" . getLangInfo('other','act_signuper_info') . ")</a></li>";
		} else {
			$activityReadFieldsHtml .= '</li>';
		}
		
		$activityReadFieldsHtml .= $this->getAllSectionHtml($activityFieldDb,'read').'<ul/>';//rqѪR
		
		$this->isCancelled($activityValue,$tid,$actmid);//P_O_ʳQ

		if ($signupStaus == true) {
			$signupHtml = $this->getSignupHtml($activityValue);//WA
		}

		$FlashHtml .= "<div class=\"pwSlide-bg\"></div><ul id=\"SwitchNav\"></ul></div><script type=\"text/javascript\" src=\"js/sliderplayer.js\"></script><script language=\"JavaScript\">pwSliderPlayers('pwSlidePlayer');</script>";
		$flash == false && $FlashHtml = '';
		$activityReadFieldsHtml = $FlashHtml.$activityReadFieldsHtml.$signupHtml.'</div>';

		return array($activityReadFieldsHtml,$activityValue);
	}
	
	/**
	 * ^ʬO_{
	 * @param array $data rqƾ Φparray(int ID => array(int rqID => array rqe))
	 * @param int $tid lid
	 * @param int $actmid id
	 * @return string HTML
	 * @access private
	 */
	function isCertified($data,$tid,$actmid) {
		global $subject,$tdtime;
		$isCertifiedHtml = '';
		$signupStaus = true;
		$defaultValueTableName = getActivityValueTableNameByActmid();
		if (!$data['iscertified'] && $data['paymethod'] == 1) {
			$tradeinfo	= $this->db->get_value("SELECT tradeinfo FROM pw_memberinfo WHERE uid=".S::sqlEscape($data['authorid']));
			$tradeinfo	= unserialize($tradeinfo);
			$alipay		= $tradeinfo['alipay'];
			$isBinded	= $tradeinfo['isbinded'];
			$isCertified= $tradeinfo['iscertified'];

			if ($isBinded != 'T') {//|jw
				if ($data['authorid'] == $this->winduid) {
					$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_unbind_alipay') . '</p>';
				} else {
					$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_author_unbind') . '</p>';
				}
			} elseif ($isCertified != 'T') {//|W{
				require_once(R_P . 'lib/activity/alipay_push.php');
				$alipayPush = new AlipayPush();
				$is_success = $alipayPush->user_query($data['authorid']);//d߬O_W{

				if ($is_success != 'T') {
					if ($data['authorid'] == $this->winduid) {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_unauth_alipay') . '</p>';
					} else {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_author_unpass') . '</p>';
					}
				} else {
					$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_activity_unNo') . '</p>';
					$this->db->update("UPDATE $defaultValueTableName SET iscertified=1 WHERE tid=".S::sqlEscape($tid));//ʳqL{
				}
			} else {
				$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_activity_unNo') . '</p>';
				$this->db->update("UPDATE $defaultValueTableName SET iscertified=1 WHERE tid=".S::sqlEscape($tid));//ʳqL{
			}
			$signupStaus = false;

		} elseif ($data['iscertified'] && !$data['batch_no'] && $data['paymethod'] == 1) {
			require_once(R_P . 'lib/activity/alipay_push.php');
			$alipayPush = new AlipayPush();
			$certStatus = $alipayPush->create_aa_payment($tid,$data['authorid'],$actmid,$subject);//ЫAAʸ

			if ($certStatus != 'T') {
				if ($certStatus == 'AA_FAIL_TO_CREATE_AA_NOT_T') {
					if ($data['authorid'] == $this->winduid) {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_alipayinfo_un') . '</p>';
					} else {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_alipayAccount') . '</p>';
					}
				} elseif ($certStatus == 'AA_FAIL_TO_CREATE_AA_FREEZED') {
					if ($data['authorid'] == $this->winduid) {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_alipay_freeze') . '</p>';
					} else {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_author_freeze') . '</p>';
					}
				} elseif ($certStatus == 'AA_FAIL_TO_CREATE_AA_NEED_CERTIFY') {
					if ($data['authorid'] == $this->winduid) {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_unauth_alipay') . '</p>';
					} else {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_alipayAccount') . '</p>';
					}
				} elseif ($certStatus == 'AA_FAIL_TO_CREATE_AA_BEYOND_LIMIT' && $data['signupstarttime'] > $tdtime && $data['signupstarttime'] < $tdtime + 86400) {//WɶO
					if ($data['authorid'] == $this->winduid) {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_max_activity') . '</p>';
					} else {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_max_activity2') . '</p>';
					}
				} else {
					if ($data['authorid'] == $this->winduid) {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other','act_err_fail_No') . '</p>';
					} else {
						$isCertifiedHtml .= '<p class="aa_err">' . getLangInfo('other', 'act_err_system_error') . '</p>';
					}
				}
				$signupStaus = false;
			}
		}
		return array($signupStaus,$isCertifiedHtml);
	}

	/**
	 * ^ʬO_Q
	 * @param array $data rqƾ Φparray(int ID => array(int rqID => array rqe))
	 * @param int $tid lid
	 * @param int $actmid id
	 * @return string HTML
	 * @access private
	 */
	function isCancelled($data,$tid,$actmid) {
		global $subject;
		//10
		if ($data['signupendtime'] < $this->timestamp - 600 && $data['iscancel'] == 0 && $this->peopleAlreadySignup($tid) < $data['minparticipant'] && $data['minparticipant']) {
			$defaultValueTableName = getActivityValueTableNameByActmid();

			/*ʨ*/
			$this->UpdatePayLog($tid,0,3);
			/*ʨ*/

			$this->db->update("UPDATE $defaultValueTableName SET iscancel=1 WHERE tid=".S::sqlEscape($tid));
			/*uq  o_H*/		
			M::sendNotice(
				array($data['author']),
				array(
					'title' => getLangInfo('writemsg', 'activity_cancel_title', array(
							'tid' => $tid,
							'subject'  => $subject
						)
					),
					'content' => getLangInfo('writemsg', 'activity_cancel_content', array(
							'tid'      => $tid,
							'subject'  => $subject
						)
					)
				),'notice_active', 'notice_active'
			);
			
			/*uq  ѻPH*/
			$query = $this->db->query("SELECT uid,username FROM pw_activitymembers WHERE tid=".S::sqlEscape($tid));
			while ($rt = $this->db->fetch_array($query)) {
				M::sendNotice(
					array($rt['username']),
					array(
						'title' => getLangInfo('writemsg', 'activity_cancel_signuper_title', array(
								'tid' => $tid,
								'subject'  => $subject
							)
						),
						'content' => getLangInfo('writemsg', 'activity_cancel_signuper_content', array(
								'tid'      => $tid,
								'subject'  => $subject
							)
						)
					),'notice_active', 'notice_active'
				);
			}
		}
	}

	/**
	 * ^ʾ\Ūq{rqΥΤwqrqϰ쪺HTML
	 * @param array $data rqƾ Φparray(int ID => array(int rqID => array rqe))
	 * @return string HTML
	 * @access private
	 */
	function getSectionvReadHtml($data) {
		$sectionValueHtml = '';
		foreach ($data as $vieworder => $line) {
			$lineHtml = $this->getReadLineHtml($line,$vieworder);
			$sectionValueHtml .= $lineHtml;
		}
		return $sectionValueHtml;
	}

	/**
	 * ^lWA]9تA^
	 * @param array $data rqƾ Φparray(string rqW => string rq))
	 * @return string HTML
	 * @access private
	 */
	function getSignupHtml($data) {
		global $tid;
		$activityStatusKey = $this->getActivityStatusKey($data, $this->timestamp, $this->peopleAlreadySignup($tid));
		$replaceArray = array();
		if ('activity_is_ended' == $activityStatusKey) {/*ʵ*/
			$this->UpdatePayLog($tid,0,2);
		} elseif ('activity_is_cancelled' == $activityStatusKey) {
			$replaceArray = array($data['minparticipant']);
		} elseif ('signup_is_available' == $activityStatusKey) {
			$replaceArray = array($tid, $data['authorid'], $this->actmid);
			if ($this->getOrderMemberUid($tid) == $this->winduid && $this->winduid) {
				$activityStatusKey = 'additional_signup_is_available_for_member';
			} elseif ($this->winduid) {
				$activityStatusKey = 'signup_is_available_for_member';
			} else {
				$activityStatusKey = 'signup_is_available_for_guest';
			}
		}
		$signupHtml = '<p class="t3">';
		$signupHtml .= $this->getSignupHtmlByActivityKey($activityStatusKey, $replaceArray);
		$signupHtml .= '</p>';
		return $signupHtml;
	}
	
	/**
	 * ھڬʪAKeyWsHTML
	 * @param string $key ʪAkey
	 * @param array $replaceArray ɥRܶq
	 * @return string HTML
	 * @global string Ϥbase URL
	 */
	function getSignupHtmlByActivityKey ($key, $replaceArray = NULL) {
		global $imgpath;
		switch ($key) {
			case 'signup_not_started_yet': //}lW
				$html = '<span class="bt"><span><button type="button" onfocus="blur()">' . getLangInfo('other','act_signup_not_start') . '</button></span></span>';
				break;
			case 'activity_is_cancelled': //WF̧CHƭAʨ
				$html = "<p class=\"aa_tip mt10\"><img src=\"$imgpath/activity/alert.png\" align=\"absmiddle\" /> <strong>" . getLangInfo('other','act_signup_not_enough',$replaceArray[0]) . "</strong></p>";
				break;
			case 'activity_is_running':
			case 'signup_is_ended': //`pUW
				$html = '<span class="bt"><span><button type="button" onfocus="blur()">' . getLangInfo('other','act_signup_over') . '</button></span></span>';
				break;
			case 'activity_is_ended': //ʵ
				$html = '<span class="bt"><span><button type="button" onfocus="blur()">' . getLangInfo('other','act_activity_over') . '</button></span></span>';
				break;
			case 'signup_number_limit_is_reached': //WHƤw
				$html = '<span class="bt"><span><button type="button" onfocus="blur()">' . getLangInfo('other','act_signup_overflow') . '</button></span></span>';
				break;
			case 'signup_is_available':
			case 'signup_is_available_for_guest': //nAW
				$html = "<span class=\"btn\"><span><button type=\"button\" id=\"signup\" onclick=\"sendmsg('job.php?action=pcjoin&tid=$replaceArray[0]','',this.id);\">" . getLangInfo('other','act_I_signup') . "</button></a></span></span>";
				break;
			case 'signup_is_available_for_member': //nAAeWAW
				$text = getLangInfo('other','act_I_signup');
			case 'additional_signup_is_available_for_member': //nAAewWAW
				$text || $text = getLangInfo('other','act_additional_signup');
				$html = "<span class=\"btn\"><span><button type=\"button\" id=\"signup\" onclick=\"sendmsg('pw_ajax.php?action=activity&job=signup&tid=$replaceArray[0]&authorid=$replaceArray[1]&actmid=$replaceArray[2]','',this.id);\">$text</button></span></span>";
				break;
			default:
				$html = '';
		}
		return $html;
	}

	
	/**
	 * ^ʾ\ŪɨC@檺rqHTML
	 * @param array $line rqƾڡAΦparray(int rqID => array rqe)
	 * @param bool $severalInputsPerLine ۦPƧǭȪrqO_ܦb@
	 * @return string HTML
	 * @access private
	 */
	function getReadLineHtml($line, $severalInputsPerLine) {
		global $paymethod;
		if ($severalInputsPerLine) { //ۦPƧǭȪrqܦb@
			$fieldHtml = '';
			$i = 0;
			$tempParticipant = array();//minparticipantȬŮɡA{ɦsx
			foreach ($line as $fieldid => $fieldValue) {
				if ($fieldValue['fieldname'] == 'minparticipant' && !$fieldValue['fieldvalue']) {//pGg̤֤HơAhq{̤֤HƤ
					$tempParticipant['min'] = '1';
					$fieldValue['fieldvalue'] = '-1';//Ȭ-1
				} elseif ($fieldValue['fieldname'] == 'maxparticipant' && !$fieldValue['fieldvalue']) {
					if (isset($tempParticipant['min']) && $tempParticipant['min']) {//̤pȬšA̤jȤ]ŮɪBz
						$fieldValue['fieldvalue'] = '-1';
					}
				}
				if ($fieldValue['fieldvalue'] && $fieldValue['type'] != 'img' && $fieldValue['type'] != 'upload'){
					if ($i == 0) {
						$fieldHtml .= '<li><em>' .$fieldValue['name1'].'J</em>';
					} else {
						if ($fieldValue['fieldname'] == 'specificuserlimit') {//WSBz
							$fieldHtml .= 'A';
						} elseif ($fieldValue['fieldname'] == 'maxparticipant') {//HƭSBz
							if (isset($tempParticipant['min']) && $tempParticipant['min']) {//̤pȬŮɡA[A
								$addJoin = '';
							} else {
								$addJoin = 'A';
							}
							if ($fieldValue['fieldvalue'] == '-1') {//̤jȬŮɪBz
								$fieldHtml .= '';
								$fieldValue['fieldvalue'] = 'HƤ';
							} else {
								$fieldHtml .= $addJoin.$fieldValue['name1'].'&nbsp;';
							}
						} elseif ($fieldValue['fieldname'] == 'feesdetail') {//OΩӯSBz
							$fieldHtml .= '</li><li><em>'.$fieldValue['name1'].'J</em>';
						} else {
							$fieldHtml .= $fieldValue['name1'].'&nbsp;';
						}
					}
					if ($fieldValue['fieldname'] == 'minparticipant' && $fieldValue['fieldvalue'] == '-1') {
						$fieldValue['name3'] = '';
						$fieldValue['fieldvalue'] = '';
					}
					$fieldHtml .= $fieldValue['name3'] ? $fieldValue['name3'].' ' : '';

					$tempFieldvalue = $this->getFieldValueHTML($fieldValue['type'],$fieldValue['fieldvalue'],$fieldValue['rules']);

					if ($fieldValue['fieldname'] == 'fees') {//ʶOίSBz
						$fees = '';
						$tempFieldvalue = unserialize($tempFieldvalue);
						if ($tempFieldvalue) {
							foreach ($tempFieldvalue as $value) {
								$fees .= ($fees ? 'A' : '') .$this->getFeesRowHtml('', $value['condition'], $value['money'], 1, 0);
							}
						} else {
							$fees .= getLangInfo('other','act_free');
						}
						
						$fieldHtml .= $fees;
					} elseif ($fieldValue['fieldname'] == 'feesdetail') {//OΩӯSBz
						$feesdetail = '<table class="aa_table_cost" cellpadding="0" cellspacing="0">
											<thead>
												<tr>
													<th width="150">' . getLangInfo('other','act_fee_desc') . '</th>
													<th class="tac">' . getLangInfo('other','act_fee_unit') . '</th>
												</tr>
											</thead><tbody>';
						$tempFieldvalue = unserialize($tempFieldvalue);
						foreach ($tempFieldvalue as $value) {
							$feesdetail .= '<tr><td>'.$value['item'].'</td><td style="border-right:none;" class="tac">'.$value['money'].'</td></tr>';
						}
						$feesdetail .= '</tbody></table>';
						$fieldHtml .= $feesdetail;
					} else {
						$fieldHtml .= $tempFieldvalue;
					}

					if (in_array($fieldValue['fieldname'],array('minparticipant','maxparticipant'))) {//HƭSBz
						if ($fieldValue['fieldname'] == 'minparticipant' && !$fieldValue['fieldvalue'] || $fieldValue['fieldname'] == 'maxparticipant' && !is_numeric($fieldValue['fieldvalue'])) {//pGg̤֤HơAhq{̤֤HƤ Ϊ ̤jȬŮɪBz
							$fieldHtml .= ' '.$fieldValue['name2'];
						} else {
							$fieldHtml .= 'H '.$fieldValue['name2'];
						}
					} else {
						$fieldHtml .= ' '.$fieldValue['name2'];
					}
					$i++;
				}
			}
			$fieldHtml .= ' </li>';

		} else { //rqܦbWߪ
			$fieldHtml = '';
			foreach ($line as $fieldid => $fieldValue) {
				
				if ($fieldValue['fieldvalue'] && $fieldValue['type'] != 'img' && $fieldValue['type'] != 'upload'){
					$fieldHtml .= '<li><em>' . $fieldValue['name1'].'J</em>';
					$fieldHtml .= ($fieldValue['name3'] ? $fieldValue['name3'].' ' : '').$this->getFieldValueHTML($fieldValue['type'],$fieldValue['fieldvalue'],$fieldValue['rules']).' '.$fieldValue['name2'].' </li>';
				}
			}
		}
		return $fieldHtml;
	}

	/**
	 * ^ʾ\ŪɨCӦrqi
	 * @param string $type rq
	 * @param string $fieldvalue rq
	 * @param bool $rules rqWh
	 * @return string 
	 * @access private
	 */
	function getFieldValueHTML($type,$fieldvalue,$rules){
		$rules && $rules = unserialize($rules);
		if ($type == 'radio') {
			$newradio = array();
			foreach ($rules as $rk => $rv){
				$rv_value = substr($rv,0,strpos($rv,'='));
				$rv_name = substr($rv,strpos($rv,'=')+1);
				$newradio[$rv_value] = $rv_name;
			}
			$actvalue .= "{$newradio[$fieldvalue]}";

		} elseif ($type == 'checkbox') {
			$newcheckbox = array();
			foreach ($rules as $ck => $cv){
				$cv_value = substr($cv,0,strpos($cv,'='));
				$cv_name = substr($cv,strpos($cv,'=')+1);
				$newcheckbox[$cv_value] = $cv_name;
			}
			$actvalues = '';
			foreach (explode(",",$fieldvalue) as $value) {
				if ($value) {
					$actvalues .= $actvalues ? ",".$newcheckbox[$value] : $newcheckbox[$value];
				}
			}
			$actvalue .= $actvalues;

		} elseif ($type == 'select') {
			$newselect = array();
			foreach($rules as $sk => $sv){
				$sv_value = substr($sv,0,strpos($sv,'='));
				$sv_name = substr($sv,strpos($sv,'=')+1);
				$newselect[$sv_value] = $sv_name;
			}
			$actvalue .= "{$newselect[$fieldvalue]}";
		} elseif ($type == 'url') {
			$actvalue .= "<a href=\"$fieldvalue\" target=\"_blank\">$fieldvalue</a>";
		} elseif ($type == 'calendar') {
			$actvalue .= $this->getTimeFromTimestamp($fieldvalue, $rules['precision']);
		} else {
			$actvalue .= "$fieldvalue";
		}
		return $actvalue;
	}

	/**
	 * ^lWHC
	 * @param int $actmid GŤid
	 * @param int $tid lid
	 * @param int $fid id
	 * @param int $paymethod I覡
	 * @param int $authorid @id
	 * @return string html
	 * @access private
	 */
	function getOrderMemberList($actmid,$tid,$fid,$paymethod,$authorid) {
		global $imgpath;
		$orderMemberList = "<div id=\"memberlist_show\"><div style=\"padding:13px 30px;\"><img src=\"$imgpath/loading.gif\" align=\"absbottom\" /> " . getLangInfo('other','act_loading_data') . "</div></div>
<script language=\"javascript\">
var authorid = parseInt('$authorid');
var paymethod = parseInt('$paymethod');

function ajaxview(url) {
	try {
		ajaxget(url,'memberlist_show');
		return false;
	} catch(e){}
}

function ajaxget(url,tag) {
	try {
		ajax.send(url,'',function() {
			if (ajax.request.responseText.indexOf('<') != -1) {
				$(tag).innerHTML = ajax.request.responseText;
			}
		});
		return false;
	} catch(e){}
}

window.onReady(function () {
	setTimeout(function(){ajaxget('pw_ajax.php?action=activity&job=memberlist&actmid=$actmid&tid=$tid&fid=$fid&authorid='+authorid+'&paymethod='+paymethod,'memberlist_show')},200);
});

function signupClose(actuid) {//WH
	
	var rText = ajax.request.responseText;
	if (rText == 'success') {		
		ajaxget('pw_ajax.php?action=activity&job=memberlist&actmid=$actmid&tid=$tid&authorid='+authorid+'&paymethod='+paymethod,'memberlist_show');
		showDialog('success','" . getLangInfo('other','act_fee_close_success') . "',2);return false;
	} else if (rText == 'payed') {
		showDialog('error','" . getLangInfo('other','act_fee_close_fail') . "',2);return false;
	} else if (rText == 'fail') {
		showDialog('error','" . getLangInfo('other','act_fee_close_fail2') . "',2);return false;
	} else {
		showDialog('error','" . getLangInfo('other','act_fee_op_error') . "',2);return false;
	}
}

function signupModify() {//קWH
	var rText = ajax.request.responseText;
	if (rText == 'success') {
		ajaxget('pw_ajax.php?action=activity&job=memberlist&actmid=$actmid&tid=$tid&authorid='+authorid+'&paymethod='+paymethod,'memberlist_show');
		showDialog('success','" . getLangInfo('other','act_op_success') . "',2);return false;
	} else if (rText == 'act_signupnums_error') {
		showDialog('error','" . getLangInfo('other','act_signup_alert') . "',2);return false;
	} else if (rText == 'act_signupnums_error_max') {
		showDialog('error','" . getLangInfo('other','act_signup_alert2') . "',2);return false;
	} else if (rText == 'act_mobile_nickname_error') {
		showDialog('error','" . getLangInfo('other','act_signup_alert3') . "',2);return false;
	} else if (rText == 'act_num_overflow') {
		showDialog('error','" . getLangInfo('other','act_signup_alert4') . "',2);return false;
	} else {
		showDialog('error','" . getLangInfo('other','act_fee_op_error') . "',2);return false;
	}
}

function loadMemberList() {//[WC
	ajaxget('pw_ajax.php?action=activity&job=memberlist&actmid=$actmid&tid=$tid&authorid='+authorid+'&paymethod='+paymethod,'memberlist_show');
	closep();
}

function additional() {//l[O
	var rText = ajax.request.responseText;
	if (rText == 'success') {
		ajaxget('pw_ajax.php?action=activity&job=memberlist&actmid=$actmid&tid=$tid&authorid='+authorid+'&paymethod='+paymethod,'memberlist_show');
		showDialog('success','" . getLangInfo('other','act_add_fee_success') . "',2);return false;
	} else if (rText == 'totalcost_error') {
		showDialog('error','l[Oή榡Dk',2);return false;
	} else {
		showDialog('error','Dkާ@',2);return false;
	}
}
</script>";
		return $orderMemberList;
	}

	/**
	 * ^
	 * @param int $actmid lid
	 * @param int $tid lid
	 * @param int $isRecommend O_
	 * @return string rqWĤ@
	 */
	function getActRecommendHtml($actmid,$tid,$isRecommend = 0) {
		global $groupid;
		$isRecommendOrNot = !$isRecommend ? getLangInfo('other','act_recommend') : getLangInfo('other','act_cancel_recommend');
		$actRecommendHtml = "<a id=\"actrecommend\" onclick=\"actRecommend('$tid', '$actmid', this);\" href=\"javascript:;\" title=\"$isRecommendOrNot\">$isRecommendOrNot</a>
<script language=\"javascript\">
function actRecommend(tid, actmid, obj) {
	ajax.send(\"pw_ajax.php?action=activity&job=recommend&tid=\"+tid+\"&actmid=\"+actmid,\"\",function(){
		var rText = ajax.request.responseText.split('\t');
		if (rText[0] == 'success') {
			var isRecommendOrNot;
			if (rText[1] != 1) {
				isRecommendOrNot = '" . getLangInfo('other','act_recommend') . "';
			} else {
				isRecommendOrNot = '" . getLangInfo('other','act_cancel_recommend') . "';
			}
			obj.title = isRecommendOrNot;
			obj.innerHTML = isRecommendOrNot;
			showDialog('success','" . getLangInfo('other','act_op_success') . "',2);return false;

		} else if (rText[0] == 'noright') {
			showDialog('error','" . getLangInfo('other','act_not_right_recommend') . "',2);return false;
			return false;
		} else {
			showDialog('error','" . getLangInfo('other','act_op_fail') . "',2);return false;
			return false;
		}
	});
}
</script>";
		if ($groupid == 3) {
			return $actRecommendHtml;
		} else {
			return '';
		}
	}

	/**
	 * ^WC޲z/sv
	 * @param int $authorid o_Hid
	 * @return bool
	 * @access private
	 */
	function getAdminRight($authorid) {
		global $groupid,$manager,$foruminfo,$windid;
		$isGM = S::inArray($windid,$manager);//O_OЩlH
		$isBM = admincheck($foruminfo['forumadmin'],$foruminfo['fupadmin'],$windid);//O_޲zv

		if (!$isGM) {#DЩlHv
			$pwSystem = pwRights($isBM);
			if ($pwSystem && $pwSystem['activitylist']) {
				$isBM = 1;
			} else {
				$isBM = 0;
			}
		}
		if ($groupid == 3 || $isGM || $isBM || $authorid == $this->winduid) {
			return true;
		}
		return false;
	}

	/**
	 * ^ʩw
	 * @param int $actmid GŤid
	 * @param int $tid lid
	 * @return string html
	 * @access private
	 */
	function getPreviewForm($actmid,$tid) {
		global $authorid;
		$previewForm = "
		<form name=\"preview\" action=\"job.php?action=activity&job=preview\" method=\"post\" target=\"preview_page\">
		<input type=\"hidden\" name=\"actmid\" value=\"$actmid\" />
		<input type=\"hidden\" name=\"tid\" value=\"$tid\" />
		<input type=\"hidden\" name=\"authorid\" value=\"$authorid\" />";
		return $previewForm;
	}

	/**
	 * ^wHѪRƲ
	 * @param array $actinfo ܶqȪrŦ
	 * @return array Ʋ
	 * @access private
	 */
	function getPreviewdata ($actinfo) {
		$fielddb = $this->getFieldData($this->actmid,false);
		$actdb = $feesdb = $feesdetaildb = array();
		foreach(explode("{|}",$actinfo) as $val) {
			if (strpos($val,'act[') !== false) {
				$name = $value = $type = $fieldid = '';
				$fieldb = array();
				$val = str_replace('&#41;',')',$val);
				list($name,$value,$type) = explode("(|)",$val);
				preg_match("/act\[(.+?)\]/",$name,$fieldata);
				if (strpos($val,'act[fees][') !== false) {//ʶOγBz
					$feesdb[] = $val;
				} elseif (strpos($val,'act[feesdetail][') !== false) {//OΩӳBz
					$feesdetaildb[] = $val;
				} else {$fieldname = $fieldata['1'];
					if ($fieldname) {
						if ($fielddb[$fieldname] != $newid) {
							strpos($type,'calendar_') !== false && $value = PwStrtoTime($value);
							$actdb[$fieldname] = $value;
						} elseif ($fielddb[$fieldname] == $newid) {
							$actdb[$fieldname] .= ','.$value;
						}
						$newid = $fielddb[$fieldname];
					}
				}
			}
		}

		/*ʶOγBz*/
		$fees = $feesArray = array();
		if ($feesdb) {
			foreach ($feesdb as $value) {
			if (strpos($value,'act[fees][condition][](|)') !== false) {
					list(,$condition) = explode('(|)',$value);
					$condition && $fees['condition'][] = $condition;
				} elseif (strpos($value,'act[fees][money][](|)') !== false) {
					list(,$money) = explode('(|)',$value);
					$money && $fees['money'][] = $money;
				}
			}
			if ($fees['condition']) {	
				foreach ($fees['condition'] as $key => $value) {
					if ($value && $fees['money'][$key]) {
						$feesArray[$key]['condition'] = $value;
						$feesArray[$key]['money'] = $fees['money'][$key];
					}
				}
			}

			$feesArray && $actdb['fees'] = serialize($feesArray);
		}
		/*ʶOγBz*/

		/*OΩӳBz*/
		$feesdetail = $feesdetailArray = array();
		if ($feesdetaildb) {
			foreach ($feesdetaildb as $value) {
				if (strpos($value,'act[feesdetail][item][](|)') !== false) {
					list(,$item) = explode('(|)',$value);
					$item && $feesdetail['item'][] = $item;
				} elseif (strpos($value,'act[feesdetail][money][](|)') !== false) {
					list(,$money) = explode('(|)',$value);
					$money && $feesdetail['money'][] = $money;
				}
			}
			if ($feesdetail['item']) {	
				foreach ($feesdetail['item'] as $key => $value) {
					if ($value && $feesdetail['item'][$key]) {
						$feesdetailArray[$key]['item'] = $value;
						$feesdetailArray[$key]['money'] = $feesdetail['money'][$key];
					}
				}
			}
			$feesdetailArray && $actdb['feesdetail'] = serialize($feesdetailArray);
		}
		
		/*OΩӳBz*/

		return $actdb;
	}

	/**
	 * ˬdov
	 * @access public
	 */
	function postCheck() {
		global $groupid,$winddb;

		if ($winddb['groups']) {
			$groupids = explode(',',substr($winddb['groups'],1,-1));
			foreach ($groupids as $value) {
				if (strpos($this->forum->foruminfo['allowpost'],",$value,") !== false) {
					$ifgroups = true;
				}
			}
		}

		if ($this->forum->foruminfo['allowpost'] && strpos($this->forum->foruminfo['allowpost'],','.$groupid.',') === false && !$ifgroups && !$this->post->admincheck) {
			Showmsg('postnew_group_right');
		}
	}

	function initSearchHtml($actmid = 0) {/*exʷjC*/
		global $fid, $searchname;

		$fieldService = L::loadClass('ActivityField', 'activity');
		$searchhtml = "<form action=\"thread.php?fid=$fid".($actmid ? "&actmid=$actmid" : "&allactmid=1")."\" method=\"post\">";
		$searchhtml .= "<input type=\"hidden\" name=\"topicsearch\" value=\"1\"><script language=\"JavaScript\" src=\"js/date.js\"></script><table>";
		if ($actmid) {
			$searchFieldDb = $fieldService->getEnabledAndSearchableFieldsByModelId($actmid);
		} else {
			$searchFieldDb = $fieldService->getDefaultSearchFields();
		}
		$vieworder_mark = $ifsearch = $ifasearch = 0;
		if ($searchFieldDb) {
			foreach ($searchFieldDb as $rt) {
				if($rt['ifasearch'] == 1) {
					$ifasearch = '1';
					if ($rt['ifsearch'] == 0) continue;
				}
				$ifsearch = '1';
				$type = $rt['type'];
				$fieldid = $rt['fieldid'];
				$fieldname = $rt['fieldname'];

				if ($vieworder_mark != $rt['vieworder']) {
					if ($vieworder_mark != 0) $searchhtml .= "</th></tr>";
					$searchhtml .= "<tr><th>";
					$searchhtml .= $rt['name'][0] ? $rt['name'][0]."J</th><td>".$rt['name'][1] : '';
					//$searchhtml .= "</td><tr>";
				} elseif ($vieworder_mark == $rt['vieworder']) {
					$searchhtml .= $rt['name'][0] ? $rt['name'][0] : '';
				}
				
				$op_key = $op_value = '';
				if (!$rt['textwidth'] || $rt['textwidth'] >15){
					$textwidth = 15;
				} else {
					$textwidth = $rt['textwidth'];
				}
				$rules = $rt['rules'];

				if (in_array($type,array('radio','select'))) {
					$searchhtml .= "<select name=\"searchname[$fieldname]\"><option value=\"\"></option>";
					foreach ($rules as $key => $value) {
						$op_key = substr($value,0,strpos($value,'='));
						$op_value = substr($value,strpos($value,'=')+1);
						$selected = $searchname[$fieldname] == $op_key ? 'selected' : '';
						$searchhtml .= "<option value=\"".$op_key."\" $selected>".$op_value."</option>";
					}
					$searchhtml .= '</select>';
				} elseif ($type == 'checkbox') {
					foreach($rules as $ck => $cv){
						$op_key = substr($cv,0,strpos($cv,'='));
						$op_value = substr($cv,strpos($cv,'=')+1);
						$checked = in_array($op_key, $searchname[$fieldname]) ? 'checked' : '';
						$searchhtml .= "<input type=\"checkbox\" name=\"searchname[$fieldname][]\" value=\"$op_key\" $checked/> $op_value ";
					}
				} elseif ($type == 'calendar') {
					$showCalendarJsOption = 'minute' == $rules['precision'] ? 1 : 0;
					$searchhtml .= "<input id=\"calendar_start_$fieldname\" type=\"text\" class=\"input\" name=\"searchname[$fieldname]\" value=\"$searchname[$fieldname]\" onclick=\"ShowCalendar(this.id,$showCalendarJsOption)\" size=\"$textwidth\"/>";
				} elseif ($type == 'range') {
					$searchhtml .= "<input type=\"text\" size=\"5\" class=\"input\" name=\"searchname[$fieldname][min]\" value=\"{$searchname[$fieldname]['min']}\"/> - <input type=\"text\" class=\"input\" name=\"searchname[$fieldname][max]\" value=\"{$searchname[$fieldname]['max']}\" size=\"$textwidth\"/>";
				} else {
					$searchhtml .= "<input type=\"text\" size=\"$textwidth\" name=\"searchname[$fieldname]\" value=\"$searchname[$fieldname]\" class=\"input\">";
				}

				$searchhtml .= $rt['name'][2];
				$vieworder_mark = $rt['vieworder'];

			}
		}
		$searchhtml .= "</td></tr><tr><th></th><td><span class=\"btn2\" style=\"margin-right:10px;\"><span><button type=\"submit\" name=\"submit\">".getLangInfo('other','pc_search')."</button></span></span>";
		$ifsearch == 0 && $searchhtml = '</td></tr></table></form>';

		$ifasearch == '1' && $searchhtml .= "<a id=\"aserach\" href=\"javascript:;\" onclick=\"sendmsg('pw_ajax.php?action=asearch&fid=$fid".($actmid ? "&actmid=$actmid" : "&allactmid=1")."','',this.id);\">".getLangInfo('other','pc_asearch')."</a></td></tr></table></form>";

		if (strpos($searchhtml,'</td></tr><input type="submit"') !== false) {
			$searchhtml = str_replace('</td></tr><input type="submit"','</td></tr><tr><th></th><td><input type="submit"',$searchhtml);
		} elseif (strpos($searchhtml,'<input type="submit" name="submit" value="') !== false) {
			$searchhtml = str_replace('<input type="submit" name="submit" value="','</td></tr><tr><th></th><td><input type="submit" name="submit" value="',$searchhtml);
		}
		return $searchhtml;
	}

	function getASearchHTML($type,$fieldid,$size,$rules){
		!$size && $size = 20;

		if (in_array($type,array('radio','select'))) {
			$searchhtml .= "<select name=\"searchname[$fieldid]\"><option value=\"\"></option>";
			foreach ($rules as $key => $value) {
				$op_key = substr($value,0,strpos($value,'='));
				$op_value = substr($value,strpos($value,'=')+1);
				$searchhtml .= "<option value=\"".$op_key."\">".$op_value."</option>";
			}
			$searchhtml .= '</select>';
		} elseif ($type == 'checkbox') {
			foreach($rules as $ck => $cv){
				$op_key = substr($cv,0,strpos($cv,'='));
				$op_value = substr($cv,strpos($cv,'=')+1);
				$searchhtml .= "<input type=\"checkbox\" class=\"input\" name=\"searchname[$fieldid][]\" value=\"$op_key\"/> $op_value ";
			}
		} elseif ($type == 'calendar') {
			$showCalendarJsOption = 'minute' == $rules['precision'] ? 1 : 0;
			$searchhtml .= "<input id=\"calendar_start_searchname[$fieldid]\" type=\"text\" class=\"input\" name=\"searchname[$fieldid]\" onclick=\"ShowCalendar(this.id,$showCalendarJsOption)\" class=\"fl\" size=\"$size\"/>";
		} elseif ($type == 'range') {
			$searchhtml .= "<input type=\"text\"  class=\"input\" name=\"searchname[$fieldid][min]\"/> - <input type=\"text\" size=\"5\" class=\"input\" name=\"field[$fieldid][max]\" size=\"$size\"/>";
		} else {
			$searchhtml .= "<input type=\"text\" name=\"searchname[$fieldid]\" value=\"\" class=\"input\"  size=\"$size\">";
		}
		return $searchhtml;
	}
	/**
	 * rqWĤ@
	 * @param string $name rqW
	 * @return string rqWĤ@
	 */
	function getFieldNameOneByName($name) {
		$names = $this->getNamePartsByName($name);
		return $names[0];
	}
	
	/**
	 * rqW3
	 * @param string $name
	 * @return array rqW3
	 */
	function getNamePartsByName($name) {
		list($name1, $name3) = explode('{#}',$name);
		list($name1, $name2) = explode('{@}',$name1);
		return array($name1, $name2, $name3);
	}
	/**
	 * lCrqiHTML
	 * @param string $type rq
	 * @param mix $fieldValue@rq
	 * @param string $rules Wh]ǦCơ^
	 * @param string $fieldName rqW
	 * @return string HTML
	 */
	function getThreadFieldValueHtml($type, $fieldValue, $rules, $fieldName = '') {
		if ($fieldName == 'fees') {
			$html = '';
			$feesTempValue = unserialize($fieldValue);
			foreach ($feesTempValue as $feesItem) {
				$html .= $this->getFeesRowHtml('', $feesItem['condition'], $feesItem['money'], 0, 0).', ';
			}
			$html = trim($html, ' ,');
		} elseif ($fieldName == 'feesdetail') {
			$html = '';
			$feesTempValue = unserialize($fieldValue);
			foreach ($feesTempValue as $feesItem) {
				$html .= $feesItem['item'].'/'.$feesItem['money']. getLangInfo('other','act_RMB') . ', ';
			}
			$html = trim($html, ' ,');
		} else {
			$html = $this->getFieldValueHTML($type, $fieldValue, $rules);
		}
		return $html;
	}
	
	function getActivityStatusValue($tid){
		
		$activityValue = array();
		$defaultValueTableName = getActivityValueTableNameByActmid();
		$activityValue = $this->db->get_one("SELECT iscancel,signupstarttime,signupendtime,endtime,starttime,maxparticipant FROM $defaultValueTableName dt WHERE dt.tid=".S::sqlEscape($tid));
		$activityStatusKey = $this->getActivityStatusKey($activityValue, $this->timestamp, $this->peopleAlreadySignup($tid));
		switch ($activityStatusKey){
			case 'activity_is_cancelled':
				$return = 3;
				break;
			case 'signup_is_ended':
				$return = 2;
				break;
			case 'activity_is_ended':
				$return = 2;
				break;
			case 'signup_number_limit_is_reached':
			case 'signup_is_available':
				$return = 1;
				break;
			default:
				$return = 0;
				break;
		}
		return $return;
	}
	
}
?>
