<?php
!function_exists('readover') && exit('Forbidden');

/**
 * l޲zާ@
 * 
 * @package Thread
 */
class PW_Threads {

	/**
	 * Rpw_threads@O
	 *
	 * @param int $threadId lid
	 * @return int
	 */
	function deleteByThreadId($threadId) {
		$threadId = S::int($threadId);
		if($threadId < 1){
			return false;
		}
		$_dbService = L::loadDB('threads', 'forum');
		return $_dbService->deleteByThreadId($threadId);
	}
	
	/**
	 * pw_threads@O
	 *
	 * @param int $threadId lid
	 * @return array
	 */
	function getByThreadId($threadId) {
		$threadId = S::int($threadId);
		if($threadId < 1){
			return false;
		}
		$_dbService = L::loadDB('threads', 'forum');
		return $_dbService->get($threadId);
	}
	
	/**
	 * 
	 * stpcA
	 * @param int $threadId
	 * @param int $b 
	 * @param int $v 0|1
	 */
	function setTpcStatusByThreadId($threadId,$b,$v = '1') {
		$b = intval($b);
		$threadId = intval($threadId);
		if (!$threadId) return false;
		$v != 1 && $v = '0';
		$threadInfo = $this->getByThreadId($threadId);
		if (!S::isArray($threadInfo)) return false;
		$tpcstatus = $threadInfo['tpcstatus'];
		setstatus($tpcstatus, $b ,$v);
		$_dbService = L::loadDB('threads', 'forum');
		$_dbService->update(array('tpcstatus' => $tpcstatus) ,$threadId);
		return true;
	}
	
	//** oxFFEF for tucool status
	function setTpcStatusByThreadIds($tids,$mask=0xFFEF){
		$_dbService = L::loadDB('threads', 'forum');
		$_dbService->setTpcStatusByThreadIds($tids,$mask=0xFFEF);
	}
	
	/**
	 * Rpw_threads@հO
	 *
	 * @param array $threadIds lid ]Ʋծ榡^
	 * @return int
	 */	
	function deleteByThreadIds($threadIds) {
		$threadIds = (array) $threadIds;
		$_dbService = L::loadDB('threads', 'forum');
		return $_dbService->deleteByThreadIds($threadIds);
	}
	
	/**
	 * ھڪOidRl
	 *
	 * @param int $forumId Oid
	 * @return int
	 */
	function deleteByForumId($forumId) {
		$forumId = S::int($forumId);
		if($forumId < 1){
			return false;
		}
		$_dbService = L::loadDB('threads', 'forum');
		return $_dbService->deleteByForumId($forumId);
	}
	
	/**
	 * ھڧ@id Rl
	 *
	 * @param int $authorId @id
	 * @return int
	 */
	function deleteByAuthorId($authorId) {
		$authorId = S::int($authorId);
		if($authorId < 1){
			return false;
		}
		$_dbService = L::loadDB('threads', 'forum');
		return $_dbService->deleteByAuthorId($authorId);
	}	
	
	function getLatestImageThreads($num){
		$num = intval($num);
		if (!$num) return array();
		$_dbService = L::loadDB('threads', 'forum');
		$threads = $_dbService->getLatestImageThreads($num);
		if ($threads) {
			$_attachService = L::loadDB('attachs', 'forum');
			$attaches = $_attachService->getByTid(array_keys($threads),null,null,'img');
			if (!$attaches) return $threads;
			krsort($attaches);
			foreach ($attaches as $k=>$v) {
				if (isset($threads[$v['tid']]['attachurl']) ) continue;
				$threads[$v['tid']]['attachurl'] = $v['attachurl'];
				$threads[$v['tid']]['ifthumb'] = $v['ifthumb'];
			}
		}
		return $threads;
	}
	
	function deleteTucoolThreadsByTids($tids){
		if(!S::isArray($tids)) return false;
		$_dbService = L::loadDB('threads', 'forum');
		$_dbService->deleteTucoolThreadsByTids($tids);
	}
	/**
	 * lH
	 * 
	 * @param int $tid
	 * @return array
	 */
	function getByTid($tid) {
		$tid = intval($tid);
		if ($tid < 1) return array(); 
		$threadsDb = $this->_getThreadsDB();
		return $threadsDb->get($tid);
	}

	/**
	 * @return PW_ThreasdDB
	 */
	function _getThreadsDB() {
		return L::loadDB('threads', 'forum');
	}
}

?>
