<?php
! defined ( 'P_W' ) && exit ( 'Forbidden' );
/**
 * ΤHwsA]tpUws pw_members, pw_memberdata, pw_memberInfo, pw_memberCredit, pw_singleRight
 *
 */
class GatherCache_PW_Members_Cache extends GatherCache_Base_Cache {
	var $_defaultCache = PW_CACHE_MEMCACHE;
	var $_prefix = 'member_';

	var $_membersField = array ('uid' => null, 'username' => null, 'password' => null, 'safecv' => null, 'email' => null, 'groupid' => null, 'memberid' => null, 'groups' => null, 'icon' => null, 'gender' => null, 'regdate' => null, 'signature' => null, 'introduce' => null, 'oicq' => null, 'aliww' => null, 'icq' => null, 'msn' => null, 'yahoo' => null, 'site' => null, 'location' => null, 'honor' => null, 'bday' => null, 'lastaddrst' => null, 'yz' => null, 'timedf' => null, 'style' => null, 'datefm' => null, 't_num' => null, 'p_num' => null, 'attach' => null, 'hack' => null, 'newpm' => null, 'banpm' => null, 'msggroups' => null, 'medals' => null, 'userstatus' => null, 'shortcut' => null );
	var $_memberDataField = array ('uid' => null, 'postnum' => null, 'digests' => null, 'rvrc' => null, 'money' => null, 'credit' => null, 'currency' => null, 'lastvisit' => null, 'thisvisit' => null, 'lastpost' => null, 'onlinetime' => null, 'monoltime' => null, 'todaypost' => null, 'monthpost' => null, 'uploadtime' => null, 'uploadnum' => null, 'follows' => null, 'fans' => null, 'newfans' => null, 'newreferto' => null, 'newcomment' => null, 'onlineip' => null, 'starttime' => null, 'postcheck' => null, 'pwdctime' => null, 'f_num' => null, 'creditpop' => null, 'jobnum' => null, 'lastmsg' => null, 'lastgrab' => null, 'punch' => null );
	var $_memberInfoField = array ('uid' => null, 'adsips' => null, 'credit' => null, 'deposit' => null, 'startdate' => null, 'ddeposit' => null, 'dstartdate' => null, 'regreason' => null, 'readmsg' => null, 'delmsg' => null, 'tooltime' => null, 'replyinfo' => null, 'lasttime' => null, 'digtid' => null, 'customdata' => null, 'tradeinfo' => null );
	var $_singleRightField = array ('uid' => null, 'visit' => null, 'post' => null, 'reply' => null );

	/**
	 * @membersH
	 *
	 * @param int $userId
	 * @return array
	 */
	function getMembersByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) {
			return false;
		}
		$key = $this->_getMembersKey ( $userId );
		$result = $this->_cacheService->get ( $key );
		if ($result === false) {
			$result = $this->_getMembersByUserIdNoCache ( $userId );
			$result = $result ? $result : array();
			$this->_cacheService->set ( $key,  $result);
		}
		return $result;
	}

	/**
	 * @MemberDataH
	 *
	 * @param int $userId
	 * @return array
	 */
	function getMemberDataByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) {
			return false;
		}
		$key = $this->_getMemberDataKey ( $userId );
		$result = $this->_cacheService->get ( $key );
		if ($result === false) {
			$result = $this->_getMemberDataByUserIdNoCache ( $userId );
			$result = $result ? $result : array();
			$this->_cacheService->set ( $key, $result );
		}
		return $result;
	}

	/**
	 * @MemberInfoH
	 *
	 * @param int $userId
	 * @return array
	 */
	function getMemberInfoByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) {
			return false;
		}
		$key = $this->_getMemberInfoKey ( $userId );
		$result = $this->_cacheService->get ( $key );
		if ($result === false ) {
			$result = $this->_getMemberInfoByUserIdNoCache ( $userId );
			$result = $result ? $result : array();
			$this->_cacheService->set ( $key, $result );
		}
		return $result;
	}

	/**
	 * @SingleRightH
	 *
	 * @param int $userId
	 * @return array
	 */
	function getSingleRightByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1 ) {
			return false;
		}
		$key = $this->_getSingleRightKey ( $userId );
		$result = $this->_cacheService->get ( $key );
		if ($result === false){
			$result = $this->_getSingleRightByUserIdNoCache ( $userId );
			$result = $result ? $result : array();
			$this->_cacheService->set ( $key, $result );
		}
		return $result;
	}

	/**
	 * q@MembersH
	 *
	 * @param array $userIds
	 * @return array
	 */
	function getMembersByUserIds($userIds) {
		if (! S::isArray ( $userIds )) {
			return false;
		}
		$userIds = array_unique ( $userIds );
		$result = $_tmpResult = $keys = $_tmpUserIds = array ();	
		foreach ( $userIds as $userId ) {
			$keys [$this->_getMembersKey ( $userId )] = $userId;
		}
		if (($members = $this->_cacheService->get ( array_keys($keys) ))) {
			$_unique = $this->getUnique();
			foreach ($keys as $key=>$userId){
				$_key = $_unique . $key;
				if (isset($members[$_key]) && is_array($members[$_key])){
					$_tmpUserIds [] = $userId;
					$result[$userId] = $members[$_key];
				}
			}
		}		
		$userIds = array_diff ( $userIds, $_tmpUserIds );
		if ($userIds) {
			$_tmpResult = $this->_getMembersByUserIdsNoCache ( $userIds );
			foreach ($userIds as $userId){
				$this->_cacheService->set ( $this->_getMembersKey ( $userId ), isset($_tmpResult[$userId]) ? $_tmpResult[$userId] : array() );
			}
		}			
		return  (array)$result + (array)$_tmpResult;
	}

	/**
	 * q@MemberDataH
	 *
	 * @param array $userIds
	 * @return array
	 */
	function getMemberDataByUserIds($userIds) {
		if (! S::isArray ( $userIds )) {
			return false;
		}
		$userIds = array_unique ( $userIds );
		$result = $_tmpResult = $keys = $_tmpUserIds = array ();
		foreach ( $userIds as $userId ) {
			$keys [$this->_getMemberDataKey ( $userId )] = $userId;
		}
		if (($members = $this->_cacheService->get ( array_keys($keys) ))) {
			$_unique = $this->getUnique();
			foreach ($keys as $key=>$userId){
				$_key = $_unique . $key;
				if (isset($members[$_key]) && is_array($members[$_key])){
					$_tmpUserIds [] = $userId;
					$result[$userId] = $members[$_key];
				}
			}
		}
		$userIds = array_diff ( $userIds, $_tmpUserIds );
		if ($userIds) {
			$_tmpResult = $this->_getMemberDataByUserIdsNoCache ( $userIds );
			foreach ($userIds as $userId){
				$this->_cacheService->set ( $this->_getMemberDataKey ( $userId ), isset($_tmpResult[$userId]) ? $_tmpResult[$userId] : array() );
			}
		}		
		
		return (array)$result + (array)$_tmpResult;
	}

	/**
	 * q@MemberInfoH
	 *
	 * @param array $userIds
	 * @return array
	 */
	function getMemberInfoByUserIds($userIds) {
		if (! S::isArray ( $userIds )) {
			return false;
		}
		$userIds = array_unique ( $userIds );
		$result = $_tmpResult = $keys = $_tmpUserIds = array ();
		foreach ( $userIds as $userId ) {
			$keys [$this->_getMemberInfoKey ( $userId )] = $userId;
		}
		if (($members = $this->_cacheService->get ( array_keys($keys) ))) {
			$_unique = $this->getUnique();
			foreach ($keys as $key=>$userId){
				$_key = $_unique . $key;
				if (isset($members[$_key]) && is_array($members[$_key])){
					$_tmpUserIds [] = $userId;
					$result[$userId] = $members[$_key];
				}
			}
		}		
		$userIds = array_diff ( $userIds, $_tmpUserIds );
		if ($userIds) {
			$_tmpResult = $this->_getMemberInfoByUserIdsNoCache ( $userIds );
			foreach ($userIds as $userId){
				$this->_cacheService->set ( $this->_getMemberInfoKey ( $userId ), isset($_tmpResult[$userId]) ? $_tmpResult[$userId] : array() );
			}
		}			
		return (array)$result + (array)$_tmpResult;
	}

	/**
	 * q@MemberCreditH
	 *
	 * @param array $userIds
	 * @return array
	 */
	function getMemberCreditByUserIds($userIds) {
		if (! S::isArray ( $userIds )) {
			return false;
		}
		$userIds = array_unique ( $userIds );
		$result = $_tmpResult = $keys = $_tmpUserIds = array ();
		foreach ( $userIds as $userId ) {
			$keys [$this->_getMemberCreditKey ( $userId )] = $userId;
		}
		if (($members = $this->_cacheService->get ( array_keys($keys) ))) {
			$_unique = $this->getUnique();
			foreach ($keys as $key=>$userId){
				$_key = $_unique . $key;
				if (isset($members[$_key]) && is_array($members[$_key])){
					$_tmpUserIds [] = $userId;
					$result[$userId] = $members[$_key];
				}
			}
		}
		$userIds = array_diff ( $userIds, $_tmpUserIds );
		if ($userIds) {
			$_tmpResult = $this->_getMemberCreditByUserIdsNoCache ( $userIds );
			foreach ($userIds as $userId){
				$this->_cacheService->set ( $this->_getMemberCreditKey ( $userId ), isset($_tmpResult[$userId]) ? $_tmpResult[$userId] : array() );
			}
		}

		return (array)$result + (array)$_tmpResult;
	}

	/**
	 * qΤsիHA Ȩread.phpbΤHɽե
	 *
	 * @param array $userIds
	 * @return array
	 */
	function getCmemberAndColonyByUserIds($userIds) {
		if (! S::isArray ( $userIds )) {
			return false;
		}
		$userIds = array_unique ( $userIds );
		$result = $_tmpResult = $keys = $_tmpUserIds = array ();
		foreach ( $userIds as $userId ) {
			$keys [$this->_getCmemberAndColonyKey ( $userId )] = $userId;
		}
		if (($members = $this->_cacheService->get ( array_keys($keys) ))) {
			$_unique = $this->getUnique();
			foreach ($keys as $key=>$userId){
				$_key = $_unique . $key;
				if (isset($members[$_key]) && is_array($members[$_key])){
					$_tmpUserIds [] = $userId;
					$result[$userId] = $members[$_key];
				}
			}
		}
		$userIds = array_diff ( $userIds, $_tmpUserIds );
		if ($userIds) {
			$_tmpResult = $this->_getCmemberAndColonyByUserIdsNoCache ( $userIds );
			foreach ($userIds as $userId){
				$this->_cacheService->set ( $this->_getCmemberAndColonyKey ( $userId ), isset($_tmpResult[$userId]) ? $_tmpResult[$userId] : array() );
			}
		}		
		return (array)$result + (array)$_tmpResult;
	}

	/**
	 * @Τ򥻫HMDataHMSingleRightHAȨglobal.phpgetUserByUidƽե
	 * {Fosqlyy "SELECT m.*, md.*, sr.* FROM pw_members m LEFT JOIN pw_memberdata md ON m.uid=md.uid LEFT JOIN pw_singleright sr ON m.uid=sr.uid WHERE m.uid=" . S::sqlEscape($uid) . " AND m.groupid<>'0' AND md.uid IS NOT NULL"
	 * 
	 * @param int $userId
	 * @return array
	 */
	/**
	function getMembersAndMemberDataAndSingleRightByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$membersAndMemberData = $this->getAllByUserId($userId, true, true);
		$singleRight = $this->getSingleRightByUserId($userId);
		return  (array)$membersAndMemberData + ($singleRight ? (array)$singleRight : $this->_singleRightField);
	}
	**/

	/**
	 * ھڤ@ӥΤidΤW
	 * 
	 * @param int $userId Τid
	 * @return string
	 */
	function getUserNameByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$result = $this->getMembersByUserId ( $userId );
		return $result ? $result['username'] : false;
	}

	/**
	 * ھڥΤidqΤW
	 * 
	 * @param array $userIds ΤidƲ
	 * @return array HuidkeyAΤWȪƲ
	 */
	function getUserNameByUserIds($userIds) {
		if (! S::isArray ( $userIds )) {
			return false;
		}
		if (!($members = $this->getMembersByUserIds($userIds))) return false;
		$_userNames = array ();
		foreach ( $members as $member ) {
			$_userNames [$member ['uid']] = $member ['username'];
		}
		return $_userNames;
	}

	/**
	 * ΤH
	 *
	 * @param int $userId ΤID
	 * @param bool $isMembers O_ΤDnH
	 * @param bool $isMemberData O_Τ򥻫H
	 * @param bool $isMemberInfo O_ΤH
	 * @return array|boolean
	 */
	
	function getAllFieldByUserId($userId, $isMembers = true, $isMemberData = false, $isMemberInfo = false) {
		$userId = S::int($userId);
		if ($userId < 1) return false;
		$members = $isMembers ? $this->getMembersByUserId($userId) : false;
		$memberData = $isMemberData ? $this->getMemberDataByUserId($userId) : false;
		$memberInfo = $isMemberInfo ? $this->getMemberInfoByUserId($userId) : false;
		return $this->_joinTables(array($isMembers, $isMemberData, $isMemberInfo), array($members, $memberData, $memberInfo));
	}
	
	
	/**
	 * qwsqΤ򥻫HADataHAInfoH
	 *
	 * @param array $userIds
	 * @return array
	 */
	
	function getAllFieldByUserIds($userIds, $isMembers = true, $isMemberData = false, $isMemberInfo = false) {
		if (! S::isArray ( $userIds )) return false;
		$arrMembers = $isMembers ? $this->getMembersByUserIds($userIds) : array();
		$arrMemberData = $isMemberData ? $this->getMemberDataByUserIds($userIds) : array();
		$arrMemberInfo = $isMemberInfo ? $this->getMemberInfoByUserIds($userIds) : array();
		$result = array();
		foreach ($userIds as $userId){
			$isMembers && $members = isset ( $arrMembers [$userId]) ?  $arrMembers [$userId] : false;
			$isMemberData && $memberData = isset ( $arrMemberData [$userId]) ?  $arrMemberData [$userId] : false;
			$isMemberInfo && $memberInfo = isset ( $arrMemberInfo [$userId]) ?  $arrMemberInfo [$userId] : false;
			$tmp = $this->_joinTables(array($isMembers, $isMemberData, $isMemberInfo), array($members, $memberData, $memberInfo));
			$tmp && $result [$userId] = $tmp;
		}
		return $result;
	}
	
	
	/**
	 * ƾڮwleft joinĪG
	 *
	 * @param array $tables  ݭndߪ array(true, false, true)
	 * @param array $values  Wݭndߪ array($result1, false, $result3)
	 * @return array
	 */
	function _joinTables($tables, $values){
		$tableField = array($this->_membersField, $this->_memberDataField, $this->_memberInfoField);
		$tableAlias = array('m.', 'md.', 'mi.');
		$first = false;
		$result = array();
		foreach ($tables as $k => $table){
			if (!$first && $table){
				if (!$values[$k]) return false;
				$first = true;
			}
			if ($first){
				!$values[$k] && $values[$k] = $tableField[$k];
				$values[$k][$tableAlias[$k]. 'uid'] = $values[$k]['uid'];
				if (isset($result['credit'])) {
					$values[$k]['creditinfo'] = $values[$k]['credit'];
					$values[$k][$tableAlias[$k]. 'credit'] = $values[$k]['credit'];
				}
				(!isset($result['credit']) && $table && $values[$k]['credit']) && $result['credit'] = $values[$k]['credit'];
				$result += $values[$k];
			}
		}
		return $first ? $result : false;
	}

	/**
	 * MΤ򥻫Hws
	 *
	 * @param array $userIds
	 */
	function clearCacheForMembersByUserIds($userIds) {
		$userIds = ( array ) $userIds;
		foreach ( $userIds as $uid ) {
			$this->_cacheService->delete ( $this->_getAllMembersKey ( $uid ) );
			$this->_cacheService->delete ( $this->_getMembersKey ( $uid ) );
		}
		return true;
	}

	/**
	 * MΤDataHws
	 *
	 * @param array $userIds
	 */
	function clearCacheForMemberDataByUserIds($userIds) {
		$userIds = ( array ) $userIds;
		foreach ( $userIds as $uid ) {
			$this->_cacheService->delete ( $this->_getAllMembersKey ( $uid ) );
			$this->_cacheService->delete ( $this->_getMemberDataKey ( $uid ) );
		}
		return true;
	}

	/**
	 * MΤInfoHws
	 *
	 * @param array $userIds
	 */
	function clearCacheForMemberInfoByUserIds($userIds) {
		$userIds = ( array ) $userIds;
		foreach ( $userIds as $uid ) {
			$this->_cacheService->delete ( $this->_getAllMembersKey ( $uid ) );
			$this->_cacheService->delete ( $this->_getMemberInfoKey ( $uid ) );
		}
		return true;
	}

	/**
	 * MΤ᪺SingleRightH
	 *
	 * @param array $userIds
	 */
	function clearCacheForSingleRightByUserIds($userIds) {
		$userIds = ( array ) $userIds;
		foreach ( $userIds as $uid ) {
			$this->_cacheService->delete ( $this->_getSingleRightKey ( $uid ) );
		}
		return true;
	}

	function clearCacheForMemberCreditByUserIds() {
		$userIds = ( array ) $userIds;
		foreach ( $userIds as $uid ) {
			$this->_cacheService->delete ( $this->_getMemberCreditKey ( $uid ) );
		}
		return true;
	}

	function clearCacheForCmemberAndColonyByUserIds() {
		$userIds = ( array ) $userIds;
		foreach ( $userIds as $uid ) {
			$this->_cacheService->delete ( $this->_getCmemberAndColonyKey ( $uid ) );
		}
		return true;
	}

	/**
	 * qLwsqƾڮw@եΤ򥻫H
	 *
	 * @param array $userIds ΤidƲ
	 * @return array
	 */
	function _getMembersByUserIdsNoCache($userIds) {
		if (! S::isArray ( $userIds )) return false;
		$membersDb = L::loadDB ( 'Members', 'user' );
		return $membersDb->getUsersByUserIds ( $userIds );
	}

	/**
	 * qLwsqƾڮw@եΤ᪺DataH
	 *
	 * @param array $userIds ΤidƲ
	 * @return array
	 */
	function _getMemberDataByUserIdsNoCache($userIds) {
		if (! S::isArray ( $userIds )) return false;
		$memberDataDb = L::loadDB ( 'MemberData', 'user' );
		return $memberDataDb->getUsersByUserIds ( $userIds );
	}

	/**
	 * qLwsqƾڮw@եΤ᪺InfoH
	 *
	 * @param array $userIds ΤidƲ
	 * @return array
	 */
	function _getMemberInfoByUserIdsNoCache($userIds) {
		if (! S::isArray ( $userIds )) return false;
		$memberInfoDb = L::loadDB ( 'MemberInfo', 'user' );
		return $memberInfoDb->getUsersByUserIds ( $userIds );
	}

	/**
	 * PLwsqƾڮw@Τ򥻫H
	 *
	 * @param int $userId Τid
	 * @return array
	 */
	function _getMembersByUserIdNoCache($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$membersDb = L::loadDB ( 'Members', 'user' );
		return $membersDb->get ( $userId );
	}

	/**
	 * PLwsqƾڮw@ΤDataH
	 *
	 * @param int $userId Τid
	 * @return array
	 */
	function _getMemberDataByUserIdNoCache($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$memberDataDb = L::loadDB ( 'MemberData', 'user' );
		return $memberDataDb->get ( $userId );
	}

	/**
	 * PLwsqƾڮw@ΤInfoH
	 *
	 * @param int $userId Τid
	 * @return array
	 */
	function _getMemberInfoByUserIdNoCache($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$memberInfoDb = L::loadDB ( 'MemberInfo', 'user' );
		return $memberInfoDb->get ( $userId );
	}

	/**
	 * qLwsqƾڮw@ΤvH, Ydpw_singleRight
	 *
	 * @param int $userId
	 * @return array
	 */
	function _getSingleRightByUserIdNoCache($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$singleRightDb = L::loadDB ( 'SingleRight', 'user' );
		return $singleRightDb->get ( $userId );
	}

	/**
	 * qƾڮw@MemberCreditƾ
	 *
	 * @param array $userIds
	 * @return array
	 */
	function _getMemberCreditByUserIdsNoCache($userIds) {
		if (!S::isArray($userIds)) return false;
		$memberCreditDb = L::loadDB ( 'MemberCredit', 'user' );
		$memberCredits = $memberCreditDb->gets ( $userIds );
		if (! S::isArray ( $memberCredits )) return false;
		$result = array ();
		foreach ( $memberCredits as $mc ) {
			$result [$mc ['uid']] [$mc ['cid']] = $mc ['value'];
			$result[$mc ['uid']]['uid'] = $mc ['uid'];
		}
		return $result;
	}

	/**
	 * qLwsqƾڮwΤsիHA ݭnsdpw_cmembersMpw_colonys
	 *
	 * @param int $threadId lid
	 * @return array
	 */
	function _getCmemberAndColonyByUserIdsNoCache($userIds) {
		$cmembersDb = L::loadDB ( 'cmembers', 'colony' );
		return $cmembersDb->getsCmemberAndColonyByUserIds ( $userIds );
	}

	/**
	 * Τ򥻫Hwskey
	 *
	 * @param int $userId Τid
	 * @return string
	 */
	function _getMembersKey($userId) {
		return $this->_prefix . 'main_uid_' . $userId;
	}

	/**
	 * ΤDataHwskey
	 *
	 * @param int $userId Τid
	 * @return string
	 */
	function _getMemberDataKey($userId) {
		return $this->_prefix . 'data_uid_' . $userId;
	}

	/**
	 * ΤInfoHwskey
	 *
	 * @param int $userId Τid
	 * @return string
	 */
	function _getMemberInfoKey($userId) {
		return $this->_prefix . 'info_uid_' . $userId;
	}

	/**
	 * SingleRightwskey
	 *
	 * @param int $userId
	 * @return string
	 */
	function _getSingleRightKey($userId) {
		return $this->_prefix . 'singleright_uid_' . $userId;
	}

	/**
	 * MemberCreditwskey
	 *
	 * @param int $userId
	 * @return string
	 */
	function _getMemberCreditKey($userId) {
		return $this->_prefix . 'credit_uid_' . $userId;
	}

	/**
	 * |sիHbmemcachewskey
	 *
	 * @param int $userId Τid
	 * @return string
	 */
	function _getCmemberAndColonyKey($userId) {
		return $this->_prefix . 'colony_uid_' . $userId;
	}

	
	
	
	/************************ j**********************************/

	function _getMembersAndMemberDataAndMemberInfoByUserIdsNoCache($userIds){
		global $customfield;
		$fieldinfo = '';
		if (is_array($customfield)) {
			foreach ($customfield as $value) {
				!$value['ifsys'] && $fieldinfo .= ',mi.field_'.(int)$value['id'];
			}
		}
		$membersDb = L::loadDB ( 'Members', 'user' );
		return $membersDb->getMembersAndMemberDataAndMemberInfoByUserIds ( $userIds,$fieldinfo );
	}
	function _getAllMembersKey($userId){
		return $this->_prefix . 'all_uid_' . $userId;
	}
	
	/**
	 * @եΤH
	 * dmembers,memberData, memberInfoTirqA Ȩglobal.php, read.phpSwaե
	 *
	 * @param array $userIds
	 * @param unknown_type $a ƥ
	 * @param unknown_type $b ƥ
	 * @param unknown_type $c ƥ
	 * @return array
	 */
	function getAllByUserIds($userIds, $a=false, $b=false, $c=false){
		$userIds = array_unique ( (array)$userIds );
		$result = $_tmpResult = $keys = $_tmpUserIds = array ();
		foreach ( $userIds as $userId ) {
			$keys [$this->_getAllMembersKey ( $userId )] = $userId;
		}
		if (($members = $this->_cacheService->get ( array_keys($keys) ))) {
			$_unique = $this->getUnique();
			foreach ($keys as $key=>$userId){
				$_key = $_unique . $key;
				if (isset($members[$_key]) && is_array($members[$_key])){
					$_tmpUserIds [] = $userId;
					$result[$userId] = $members[$_key];
				}
			}
		}
		$userIds = array_diff ( $userIds, $_tmpUserIds );
		if ($userIds) {
			$_tmpResult = $this->_getMembersAndMemberDataAndMemberInfoByUserIdsNoCache ( $userIds );
			foreach ($userIds as $userId){
				$this->_cacheService->set ( $this->_getAllMembersKey ( $userId ), isset($_tmpResult[$userId]) ? $_tmpResult[$userId] : array() );
			}
		}		
		return (array)$result + (array)$_tmpResult;		
	}
	
	/**
	 * @ΤH
	 * dmembers,memberData, memberInfoTirqA Ȩglobal.php, read.phpSwaե
	 *
	 * @param array $userIds
	 * @param unknown_type $a ƥ
	 * @param unknown_type $b ƥ
	 * @param unknown_type $c ƥ
	 * @return array
	 */	
	function getAllByUserId($userId, $a=false, $b=false, $c=false){
		$userId = S::int($userId);
		if ($userId < 1) return false;
		$members = $this->getAllByUserIds($userId);
		return $members ? current($members) : array();
	}
	
	/**
	 * @ΤH
	 * dmembers,memberData, singleRightTirqA Ȩglobal.phpSwaե
	 *
	 * @param array $userIds
	 * @return array
	 */		
	function getMembersAndMemberDataAndSingleRightByUserId($userId) {
		$userId = S::int ( $userId );
		if ($userId < 1) return false;
		$membersAndMemberData = $this->getAllByUserId($userId);
		if (!$membersAndMemberData) return array();
		$singleRight = $this->getSingleRightByUserId($userId);
		return  (array)$membersAndMemberData + ($singleRight ? (array)$singleRight : $this->_singleRightField);
	}		
	
}