<?php 
!defined('P_W') && exit('Forbidden');

/**
 * u@gDAO
 * @package PW_User_CareerDB
 */
class PW_UserCareerDB extends BaseDB{
	
	var $_tableName = 'pw_user_career';
	var $_companyTable = 'pw_company';
	var $_primaryKey = 'careerid';
	
	/**
	 * K[u@g
	 * @param array $data
	 * @return bool
	 */
	function addCareers($data){
		if (!S::isArray($data)) return false;
		return $this->_db->update("INSERT INTO $this->_tableName (uid,companyid,starttime) VALUES " . S::sqlMulti($data)."");
	}
	
	/**
	 * ھڥΤIDu@g
	 * @param int uid
	 * @return array
	 */
	function getCareers($uid){
		$uid = (int) $uid;
		if ($uid < 1) return array();
		$query = $this->_db->query("SELECT uc.*, c.companyname FROM  $this->_tableName uc LEFT JOIN $this->_companyTable c USING(companyid) WHERE uc.uid = " . S::sqlEscape($uid) . ' ORDER BY careerid ASC');
		return $this->_getAllResultFromQuery($query,'careerid');
	}
	
	/**
	 * ھڤqIDΤid
	 * @param int companyId
	 * @return array
	 */
	function getUserIdsByCompanyId($companyId){
		if (!$companyId) return array();
		$query = $this->_db->query("SELECT uid FROM  $this->_tableName WHERE companyid = " . S::sqlEscape($companyId) . "");
		return $this->_getAllResultFromQuery($query,'uid');
	}
	
	/**
	 * ھڤu@gID@u@g
	 * @param int careerId
	 * @return array
	 */
	function getCareer($careerId){
		if (!$careerId) return array();
		return $this->_get($careerId);
	}
	
	/**
	 * s@u@g
	 * @param int $uid Τid
	 * @param int $companyId qId
	 * @param int $startTime Jq~
	 * @return bool
	 */
	function editCareer($careerId,$companyId,$startTime){
		if (!$careerId || !$companyId || !$startTime) return false;
		return pwQuery::update($this->_tableName, "careerid=:careerid", array($careerId), array('companyid'=>$companyId,'starttime'=>$startTime));
	}
	
	/**
	 * ھڤu@gidqRu@g
	 * @param int careerIds u@gid
	 * @return bool
	 */
	function deleteCareers($careerIds){
		if(!$careerIds) return false;
		return pwQuery::delete($this->_tableName, 'IN(:careerid)', array($careerIds));
	}
	
	/**
	 * ھڤu@gidR@u@g
	 * @param int careerId u@gid
	 * @return bool
	 */
	function deleteCareer($careerId){
		if(!$careerId) return false;
		return pwQuery::delete($this->_tableName, 'careerid=:careerid', array($careerId));
	}
}