<?php
! defined ( 'P_W' ) && exit ( 'Forbidden' );
/**
 * wsq,wstmA,MemcacheBƾڮwMwsA
 * @author L.IuHu.I@2010/10/14 developer.liuhui@gmail.com
 * @CopyRight phpwind 
 */
define ( 'PW_CACHE_VERSION', '1.0.0' );
define ( 'PW_CACHE_DIR', R_P . 'lib/utility' ); //eؿ
define ( 'PW_CACHE_CONFIG', 'cache_config' ); //wstmW
! defined ( 'PW_CACHE_MEMCACHE' ) && define ( 'PW_CACHE_MEMCACHE', 'memcache' ); //sws
! defined ( 'PW_CACHE_FILECACHE' ) && define ( 'PW_CACHE_FILECACHE', 'filecache' ); //ws
! defined ( 'PW_CACHE_DBCACHE' ) && define ( 'PW_CACHE_DBCACHE', 'dbcache' ); //ƾڮwws
class PW_CacheService {
	var $_services = array ();
	function PW_CacheService() {
		$this->__construct ();
	}
	/*
	 * lƽwsA
	 */
	function __construct() {
		if (! isset ( $this->_services [PW_CACHE_CONFIG] ) || ! $this->_services [PW_CACHE_CONFIG]) {
			$this->_services [PW_CACHE_CONFIG] = new Cache_ServiceFactory ();
		}
	}
	/**
	 * ٹwkeysxvalue
	 * @param $key
	 * @param $value
	 * @param $cacheService
	 */
	function set($key, $value, $expire = 600, $cacheName = null) {
		if (! ($cacheService = $this->_services [PW_CACHE_CONFIG]->getService ( $cacheName ))) {
			return false;
		}
		return $cacheService->set ( $key, $value, $expire );
	}
	/**
	 * ٹwkeyƾ
	 * @param $key
	 * @param $cacheService
	 */
	function get($key, $cacheName = null) {
		if (! ($cacheService = $this->_services [PW_CACHE_CONFIG]->getService ( $cacheName ))) {
			return false;
		}
		return $cacheService->get ( $key );
	}
	/**
	 * ٹwkeyRƾ
	 * @param $key
	 * @param $cacheService
	 */
	function delete($key, $cacheName = null) {
		if (! ($cacheService = $this->_services [PW_CACHE_CONFIG]->getService ( $cacheName ))) {
			return false;
		}
		return $cacheService->delete ( $key );
	}
	
	function increment($key, $value = 1, $cacheName = null) {
		if (! ($cacheService = $this->_services [PW_CACHE_CONFIG]->getService ( $cacheName ))) {
			return false;
		}
		return $cacheService->increment ( $key, $value );
	}
	
	/**
	 * Mťwsƾ
	 * @param $cacheService
	 */
	function flush($cacheName = null) {
		if (! ($cacheService = $this->_services [PW_CACHE_CONFIG]->getService ( $cacheName ))) {
			return false;
		}
		return $cacheService->flush ();
	}
}
/*
 * qνwsut
 */
class Cache_ServiceFactory {
	var $_defaultService = null;
	var $_services = array ();
	function Cache_ServiceFactory() {
		$this->__construct ();
	}
	
	function __construct() {
		$this->_defaultService = $this->build ( Cache_Config_Default::defaultCache () );
	}
	
	function build($cacheName) {
		switch ($cacheName) {
			case PW_CACHE_MEMCACHE :
				return $this->getMemcacheService ();
			case PW_CACHE_FILECACHE :
				return $this->getFilecacheService ();
			case PW_CACHE_DBCACHE :
				return $this->getDbCacheService ();
			default :
				return false;
		}
	}
	
	function getService($cacheName) {
		return ($cacheName) ? $this->build ( $cacheName ) : $this->_defaultService;
	}
	/*
	 * sws
	 */
	function getMemcacheService() {
		if (! isset ( $this->_services [PW_CACHE_MEMCACHE] ) || ! $this->_services [PW_CACHE_MEMCACHE]) {
			$this->_services [PW_CACHE_MEMCACHE] = new PW_MemcacheService ();
		}
		return $this->_services [PW_CACHE_MEMCACHE];
	
	}
	/*
	 * ws
	 */
	function getFilecacheService() {
		if (! isset ( $this->_services [PW_CACHE_FILECACHE] ) || ! $this->_services [PW_CACHE_FILECACHE]) {
			$this->_services [PW_CACHE_FILECACHE] = new PW_FilecacheService ();
		}
		return $this->_services [PW_CACHE_FILECACHE];
	}
	/*
	 * ƾڮwws
	 */
	function getDbCacheService() {
		if (! isset ( $this->_services [PW_CACHE_DBCACHE] ) || ! $this->_services [PW_CACHE_DBCACHE]) {
			$this->_services [PW_CACHE_DBCACHE] = new PW_DbcacheService ();
		}
		return $this->_services [PW_CACHE_DBCACHE];
	}

}
/**
 * wstm,i۩wqtmPק,XphpwindƩΰtmXi
 * @author L.IuHu.I@2010/10/14
 */
class Cache_Config_Default {
	/*
	 * q{ws]m
	 */
	function defaultCache() {
		return PW_CACHE_MEMCACHE;
	}
	/**
	 * ߤ@ȫe
	 */
	function getUnique() {
		return $GLOBALS['db_memcache']['hash'];
	}
	
	function getCurrentTime() {
		return $GLOBALS ['timestamp'];
	}
}

/**
 * Memcachewstm
 */
class Cache_Config_Memcache {
	/**
	 * Memcachetm
	 */
	function load() {
		return ($GLOBALS ['db_memcache']) ? array ($GLOBALS ['db_memcache'] ) : array (array ('host' => 'localhost', 'port' => 11211 ) );
	}
}
/**
 * wstm
 */
class Cache_Config_Filecache {
	/**
	 * wsؿtm
	 */
	function getDirectory() {
		return D_P . 'data/gathercache/';
	}
	/**
	 * wstm
	 */
	function getExt() {
		return '.php';
	}
	/**
	 * Ыؤ|
	 * @param $key
	 */
	function createFile($key) {
		return Cache_Config_Filecache::getDirectory () . Cache_Config_Default::getUnique () . $key . Cache_Config_Filecache::getExt ();
	}
	/**
	 * Ū[iXiŪA]
	 */
	function readFile($fileName, $method = 'rb') {
		return readover ( $fileName, $method );
	}
	/**
	 * g[iXigA]
	 */
	function writeFile($fileName, $data, $method = 'rb+', $ifLock = true, $ifCheckPath = true, $ifChmod = true) {
		return writeover ( $fileName, $data, $method, $ifLock, $ifCheckPath, $ifChmod );
	}
}
/**
 * ƾڮwwstm
 */
class Cache_Config_Dbcache {
	
	function connect() {
		return $GLOBALS ['db']->sql;
	}
	/**
	 * ȳЫت,i۩wqhashXiƾڪ
	 * @param $key
	 */
	function getTable($key = null) {
		return 'pw_cache_storage';
	}
	
	function createTable() {
		//Ыتc
	}
}
/**
 * MemcachesxAȵ
 * @author L.IuHu.I@2010/10/14 developer.liuhui@gmail.com
 * @CopyRight phpwind 
 */
class PW_MemcacheService {
	var $_object = null;
	
	function PW_MemcacheService() {
		$this->__construct ();
	}
	
	function __construct() {
		$this->_load ();
	}
	/**
	 * sxƾ
	 * @param string $key
	 * @param mixture $value
	 * @param int $expire
	 */
	function set($key, $value, $expire = 600) {
		return (! $this->_check ()) ? false : $this->_object->set ( $this->_hash ( $key ), $value, 0, $expire );
	}
	
	function increment($key, $value = 1) {
		return (! $this->_check ()) ? false : $this->_object->increment ( $this->_hash ( $key ), $value );
	}
	/**
	 * ƾ
	 * @param string|array $key
	 */
	function get($key) {
		return (! $this->_check ()) ? false : $this->_object->get ( $this->_hash ( $key ) );
	}
	/**
	 * Rƾ
	 * @param string|array $key
	 */
	function delete($key) {
		return (! $this->_check ()) ? false : $this->_object->delete ( $this->_hash ( $key ) );
	}
	/**
	 * Mƾ
	 */
	function flush() {
		return (! $this->_check ()) ? false : $this->_object->flush ();
	}
	/**
	 * A
	 */
	function close() {
		return (! $this->_check ()) ? false : $this->_object->close ();
	}
	/**
	 * ߤ@ȥͦ(AȾh)
	 * @param $key
	 */
	function _hash($key) {
		$unique = Cache_Config_Default::getUnique ();
		if (! is_array ( $key )) {
			return $unique . $key;
		}
		$_tmpKey = array ();
		foreach ( $key as $k ) {
			$_tmpKey [] = $unique . $k;
		}
		return $_tmpKey;
	}
	/**
	 * ˬdA
	 */
	function _check() {
		return (is_object ( $this->_object )) ? true : false;
	}
	/**
	 * ҰʪA
	 */
	function _load() {
		if (! class_exists ( 'memcache' ) || ! ($configs = $this->_config ())) {
			return false;
		}
		$this->_object = new Memcache ();
		if (method_exists ( $this->_object, 'addServer' )) {
			foreach ( $configs as $config ) {
				$this->_object->addServer ( $config ['host'], $config ['port'] );
			}
		} else {
			$this->_object->connect ( $configs [0] ['host'], $configs [0] ['port'] );
		}
	}
	/**
	 * tmA
	 */
	function _config() {
		return Cache_Config_Memcache::load ();
	}

}
/**
 * sxAȵ[wPA]
 * @author L.IuHu.I@2010/10/15 developer.liuhui@gmail.com
 * @CopyRight phpwind 
 */
class PW_FilecacheService {
	var $_object = null;
	
	function PW_FilecacheService() {
		$this->__construct ();
	}
	
	function __construct() {
		$this->_load ();
	}
	/**
	 * sxƾ
	 * @param string $key
	 * @param string|array $value
	 */
	function set($key, $value, $expire = 600) {
		return ($this->_check ()) ? $this->_object->write ( $this->_hash ( $key ), $value, $expire ) : false;
	}
	/**
	 * ƾ
	 * @param string|array $key
	 */
	function get($key) {
		return ($this->_check ()) ? $this->_object->read ( $this->_hash ( $key ) ) : false;
	}
	/**
	 * Rƾ
	 * @param string|array $key
	 */
	function delete($key) {
		return ($this->_check ()) ? $this->_object->delete ( $this->_hash ( $key ) ) : false;
	}
	/**
	 * Mƾ
	 * @param string|array $key
	 */
	function flush() {
		return ($this->_check ()) ? $this->_object->flush () : false;
	}
	
	function increment($key, $value = 1) {
	
	}
	/**
	 * ոȤ
	 * @param string|array $key
	 */
	function _hash($key) {
		if (! is_array ( $key )) {
			return $key;
		}
		$_tmp = array ();
		foreach ( $key as $k ) {
			$_tmp [] = $k;
		}
		return $_tmp;
	}
	/**
	 * ҰʪA
	 */
	function _load() {
		if (! $this->_object) {
			$this->_object = new Cache_File_OperateService ();
		}
	}
	/**
	 * ˬdA
	 */
	function _check() {
		return (is_object ( $this->_object )) ? true : false;
	}

}
/**
 * ާ@A
 */
class Cache_File_OperateService {
	/*
	 * Ūާ@
	 */
	function read($key, $method = 'rb') {
		if (! is_array ( $key )) {
			return $this->_read ( $key, $method );
		}
		$_tmpData = array ();
		foreach ( $key as $k ) {
			$_tmpData [$k] = $this->_read ( $k, $method );
		}
		return $_tmpData;
	}
	
	function _read($key, $method = 'rb') {
		if (! ($fileName = Cache_Config_Filecache::createFile ( $key ))) {
			return array ();
		}
		$data = unserialize ( Cache_Config_Filecache::readFile ( $fileName, $method ) );
		$currentTime = Cache_Config_Default::getCurrentTime ();
		if (! $data || $data ['expire'] < $currentTime) {
			$this->delete ( $key );
			return array ();
		}
		return $data ['value'];
	}
	/*
	 * gJާ@
	 */
	function write($key, $value, $expire = 600) {
		$fileName = Cache_Config_Filecache::createFile ( $key );
		$expire = Cache_Config_Default::getCurrentTime () + $expire;
		return Cache_Config_Filecache::writeFile ( $fileName, serialize ( array ('expire' => $expire, 'value' => $value ) ) );
	}
	/*
	 * Rާ@
	 */
	function delete($key) {
		$fileName = Cache_Config_Filecache::createFile ( $key );
		if (! is_file ( $fileName ))
			return false;
		P_unlink ( $fileName );
	}
	
	/*
	 * MŤާ@
	 */
	function flush() {
		$directory = Cache_Config_Filecache::getDirectory ();
		if (! is_dir ( $directory )) {
			return false;
		}
		if (! ($dh = opendir ( $directory ))) {
			return false;
		}
		while ( (($file = readdir ( $dh )) !== false) ) {
			if (in_array ( $file, array ('.', '..' ) ))
				continue;
			$this->delete ( $directory . $file );
		}
		closedir ( $dh );
	}

}
/**
 * ƾڮwsxAȵ
 * @author L.IuHu.I@2010/10/15 developer.liuhui@gmail.com
 * @CopyRight phpwind  
 */
class PW_DbcacheService {
	var $_object = null;
	
	function PW_DbcacheService() {
		$this->__construct ();
	}
	
	function __construct() {
		$this->_load ();
	}
	/**
	 * sxƾ
	 * @param string $key
	 * @param string|array $value
	 * @param int $expire
	 */
	function set($key, $value, $expire = 600) {
		return ($this->_check ()) ? $this->_object->insert ( $this->_hash ( $key ), $value, $expire ) : false;
	}
	/**
	 * ƾ
	 * @param string|array $key
	 */
	function get($key) {
		return ($this->_check ()) ? $this->_object->get ( $this->_hash ( $key ) ) : false;
	}
	/**
	 * Rƾ
	 * @param string|array $key
	 */
	function delete($key) {
		return ($this->_check ()) ? $this->_object->delete ( $this->_hash ( $key ) ) : false;
	}
	/**
	 * Mƾ
	 */
	function flush() {
		return ($this->_check ()) ? $this->_object->flush () : false;
	}
	
	function increment($key, $value = 1) {
	
	}
	/**
	 * ͦߤ@
	 * @param $key
	 */
	function _hash($key) {
		$unique = Cache_Config_Default::getUnique ();
		if (! is_array ( $key )) {
			return $unique . $key;
		}
		$_tmp = array ();
		foreach ( $key as $k ) {
			$_tmp [] = $unique . $k;
		}
		return $_tmp;
	}
	/**
	 * ҰʪA
	 */
	function _load() {
		if (! $this->_object) {
			$this->_object = new Cache_Db_OperateService ();
		}
	}
	/**
	 * ˬdA
	 */
	function _check() {
		return (is_object ( $this->_object )) ? true : false;
	}
}
/**
 * ƾڮwާ@A
 */
class Cache_Db_OperateService {
	var $_conn = NULL;
	
	function Cache_Db_OperateService() {
		$this->__construct ();
	}
	function __construct() {
		$this->_conn = $this->connect ();
	}
	/*
	 * gJƾ
	 */
	function insert($key, $value, $expire = 600) {
		$expire = Cache_Config_Default::getCurrentTime () + $expire;
		return $this->query ( "REPLACE INTO " . $this->getTableName ( $key ) . " (ckey,cvalue,expire) VALUES (" . $this->escape ( $key ) . "," . $this->escape ( serialize ( $value ) ) . "," . $this->escape ( $expire ) . ")" );
	}
	/*
	 * ƾ
	 */
	function get($key) {
		$key = (is_array ( $key )) ? $key : array ($key );
		$currentTime = Cache_Config_Default::getCurrentTime ();
		$query = $this->query ( "SELECT ckey,cvalue FROM " . $this->getTableName ( $key ) . " WHERE ckey IN ( " . $this->escape ( $key ) . ") AND expire >= " . $this->escape ( $currentTime ) );
		$result = $this->fetchArray ( $query );
		return $result;
	}
	/*
	 * Rƾ
	 */
	function delete($key) {
		$key = (is_array ( $key )) ? $key : array ($key );
		return $this->query ( "DELETE FROM " . $this->getTableName ( $key ) . " WHERE ckey IN( " . $this->escape ( $key ) . ")" );
	}
	/*
	 * Mżƾ
	 */
	function flush() {
		return $this->query ( "TRUNCATE TABLE " . $this->getTableName () );
	}
	/*
	 * d
	 */
	function query($sql) {
		return mysql_query ( $sql, $this->_conn );
	}
	/*
	 * Lo
	 */
	function escape($key) {
		if (! is_array ( $key )) {
			return "'" . $key . "'";
		}
		$_tmp = '';
		foreach ( $key as $k ) {
			$_tmp .= (($_tmp) ? ',' : '') . "'" . $k . "'";
		}
		return $_tmp;
	}
	/*
	 * ո
	 */
	function fetchArray($result, $type = MYSQL_ASSOC) {
		$rt = array ();
		while ( $row = mysql_fetch_array ( $result, $type ) ) {
			$rt [$row ['ckey']] = unserialize ( $row ['cvalue'] );
		}
		return $rt;
	}
	/*
	 * ƾڪ
	 */
	function getTableName($key = null) {
		return Cache_Config_Dbcache::getTable ( $key );
	}
	/*
	 * s
	 */
	function connect() {
		return Cache_Config_Dbcache::connect ();
	}
}