/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko.events.impl;

import com.teamdev.jxbrowser.gecko.WebBrowser;
import com.teamdev.jxbrowser.gecko.events.LocationEvent;
import com.teamdev.jxbrowser.gecko.events.ProgressEvent;
import com.teamdev.jxbrowser.gecko.events.RequestListener;
import com.teamdev.jxbrowser.gecko.events.SecurityEvent;
import com.teamdev.jxbrowser.gecko.events.StateEvent;
import com.teamdev.jxbrowser.gecko.events.StatusEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestListenersSupport {
    private final WeakReference<WebBrowser> a;
    private final Set<RequestListener> b;

    public RequestListenersSupport(WebBrowser webBrowser) {
        this.a = new WeakReference<WebBrowser>(webBrowser);
        this.b = Collections.synchronizedSet(new HashSet());
    }

    public void addRequestListener(RequestListener requestListener) {
        this.b.add(requestListener);
    }

    public void removeRequestListener(RequestListener requestListener) {
        this.b.remove(requestListener);
    }

    public List<RequestListener> getRequestListeners() {
        return new ArrayList<RequestListener>(this.b);
    }

    public void fireStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3) {
        StateEvent stateEvent = new StateEvent((WebBrowser)this.a.get(), nsIWebProgress2, nsIRequest2, l2, l3);
        for (RequestListener requestListener : this.b) {
            requestListener.stateChanged(stateEvent);
        }
    }

    public void fireProgressChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, int n2, int n3, int n4, int n5) {
        ProgressEvent progressEvent = new ProgressEvent((WebBrowser)this.a.get(), nsIWebProgress2, nsIRequest2, n2, n3, n4, n5);
        for (RequestListener requestListener : this.b) {
            requestListener.progressChanged(progressEvent);
        }
    }

    public void fireLocationChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, nsIURI nsIURI2) {
        LocationEvent locationEvent = new LocationEvent((WebBrowser)this.a.get(), nsIWebProgress2, nsIRequest2, nsIURI2);
        for (RequestListener requestListener : this.b) {
            requestListener.locationChanged(locationEvent);
        }
    }

    public void fireStatusChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, String string) {
        StatusEvent statusEvent = new StatusEvent((WebBrowser)this.a.get(), nsIWebProgress2, nsIRequest2, l2, string);
        for (RequestListener requestListener : this.b) {
            requestListener.statusChanged(statusEvent);
        }
    }

    public void fireSecurityChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2) {
        SecurityEvent securityEvent = new SecurityEvent((WebBrowser)this.a.get(), nsIWebProgress2, nsIRequest2, l2);
        for (RequestListener requestListener : this.b) {
            requestListener.securityChanged(securityEvent);
        }
    }

    public void dispose() {
        this.b.clear();
    }
}

