/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko.xpcom;

import com.teamdev.jxbrowser.gecko.xpcom.KeyCodesUtil;
import com.teamdev.jxbrowser.gecko.xpcom.MozillaComponent;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMManager;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MouseKeyboardSupport
implements nsIDOMEventListener {
    private static final Logger a = LoggerFactory.getLogger(MouseKeyboardSupport.class);
    private static final String[] b = new String[]{"click", "dblclick", "mousedown", "mouseup", "mousemove", "keydown", "keyup", "keypress"};
    private final Component c;
    private final nsIWebBrowser d;

    public MouseKeyboardSupport(Component component, nsIWebBrowser nsIWebBrowser2) {
        this.c = component;
        this.d = nsIWebBrowser2;
        nsIDOMWindow nsIDOMWindow3 = nsIWebBrowser2.getContentDOMWindow();
        nsIDOMWindow2 nsIDOMWindow22 = XPCOMManager.getInstance().queryInterface(nsIDOMWindow3, nsIDOMWindow2.class);
        nsIDOMEventTarget nsIDOMEventTarget2 = nsIDOMWindow22.getWindowRoot();
        for (String string : b) {
            nsIDOMEventTarget2.addEventListener(string, ProxyObjectManager.getInstance().proxyForObject(this, nsIDOMEventListener.class, false), true);
        }
    }

    public void dispose() {
        nsIDOMWindow nsIDOMWindow3 = this.d.getContentDOMWindow();
        nsIDOMWindow2 nsIDOMWindow22 = XPCOMManager.getInstance().queryInterface(nsIDOMWindow3, nsIDOMWindow2.class);
        nsIDOMEventTarget nsIDOMEventTarget2 = nsIDOMWindow22.getWindowRoot();
        for (String string : b) {
            nsIDOMEventTarget2.removeEventListener(string, ProxyObjectManager.getInstance().proxyForObject(this, nsIDOMEventListener.class, false), true);
        }
    }

    public void handleEvent(nsIDOMEvent nsIDOMEvent2) {
        XPCOMManager xPCOMManager = XPCOMManager.getInstance();
        if (xPCOMManager.isInstanceOf(nsIDOMEvent2, nsIDOMMouseEvent.class)) {
            this.a(xPCOMManager.queryInterface(nsIDOMEvent2, nsIDOMMouseEvent.class));
        } else {
            this.a(xPCOMManager.queryInterface(nsIDOMEvent2, nsIDOMKeyEvent.class));
        }
    }

    public nsISupports queryInterface(String string) {
        return Mozilla.queryInterface(this, string);
    }

    private void a(nsIDOMKeyEvent nsIDOMKeyEvent2) {
        final int n2 = this.a(nsIDOMKeyEvent2.getType());
        final long l2 = System.currentTimeMillis();
        final int n3 = this.b(nsIDOMKeyEvent2);
        final int n4 = this.a(n2, nsIDOMKeyEvent2.getKeyCode());
        final char c2 = this.c(nsIDOMKeyEvent2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KeyEvent keyEvent = new KeyEvent(MouseKeyboardSupport.this.c, n2, l2, n3, n4, c2);
                if (c2 == '\u0000' && !keyEvent.isActionKey()) {
                    char c22 = (char)n4;
                    if (Character.isLetter(c22) && (n3 & 0x40) == 0) {
                        c22 = Character.toLowerCase(c22);
                    }
                    keyEvent.setKeyChar(c22);
                }
                Window window = SwingUtilities.getWindowAncestor(MouseKeyboardSupport.this.c);
                AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
                boolean bl = window.getFocusTraversalKeys(0).contains(aWTKeyStroke);
                boolean bl2 = window.getFocusTraversalKeys(1).contains(aWTKeyStroke);
                if (bl || bl2) {
                    KeyListener[] keyListenerArray;
                    block5: for (KeyListener keyListener : keyListenerArray = MouseKeyboardSupport.this.c.getKeyListeners()) {
                        switch (keyEvent.getID()) {
                            case 401: {
                                keyListener.keyPressed(keyEvent);
                                continue block5;
                            }
                            case 400: {
                                keyListener.keyTyped(keyEvent);
                                continue block5;
                            }
                            case 402: {
                                keyListener.keyReleased(keyEvent);
                            }
                        }
                    }
                    return;
                }
                ((MozillaComponent)((Object)MouseKeyboardSupport.this.c)).onDispatchEvent(keyEvent);
            }
        });
    }

    private int a(String string) {
        if (string.equals("keydown")) {
            return 401;
        }
        if (string.equals("keyup")) {
            return 402;
        }
        if (string.equals("keypress")) {
            return 400;
        }
        return 400;
    }

    private int b(nsIDOMKeyEvent nsIDOMKeyEvent2) {
        int n2 = 0;
        if (nsIDOMKeyEvent2.getShiftKey()) {
            n2 |= 0x40;
        }
        if (nsIDOMKeyEvent2.getCtrlKey()) {
            n2 |= 0x80;
        }
        if (nsIDOMKeyEvent2.getMetaKey()) {
            n2 |= 0x100;
        }
        if (nsIDOMKeyEvent2.getAltKey()) {
            n2 |= 0x200;
        }
        return n2;
    }

    private int a(int n2, long l2) {
        if (400 == n2) {
            return 0;
        }
        int n3 = (int)l2;
        int n4 = KeyCodesUtil.getAwtKeyCode(n3);
        if (n4 != -1) {
            return n4;
        }
        return n3;
    }

    private char c(nsIDOMKeyEvent nsIDOMKeyEvent2) {
        long l2 = nsIDOMKeyEvent2.getCharCode();
        if (l2 == 0L) {
            return '\u0000';
        }
        return (char)l2;
    }

    private void a(nsIDOMMouseEvent nsIDOMMouseEvent2) {
        int n2;
        String string = nsIDOMMouseEvent2.getType();
        if (string.equals("click") || string.equals("dblclick")) {
            n2 = 500;
        } else if (string.equals("mousedown")) {
            n2 = 501;
        } else if (string.equals("mouseup")) {
            n2 = 502;
        } else if (string.equals("mousemove")) {
            n2 = 503;
        } else {
            a.error("Unknown mouse event type " + string);
            return;
        }
        final long l2 = System.currentTimeMillis();
        int n3 = 0;
        if (nsIDOMMouseEvent2.getShiftKey()) {
            n3 |= 0x40;
        }
        if (nsIDOMMouseEvent2.getCtrlKey()) {
            n3 |= 0x80;
        }
        if (nsIDOMMouseEvent2.getMetaKey()) {
            n3 |= 0x100;
        }
        if (nsIDOMMouseEvent2.getAltKey()) {
            n3 |= 0x200;
        }
        if (nsIDOMMouseEvent2.getButton() == 0) {
            n3 |= 0x400;
        }
        if (nsIDOMMouseEvent2.getButton() == 1) {
            n3 |= 0x800;
        }
        if (nsIDOMMouseEvent2.getButton() == 2) {
            n3 |= 0x1000;
        }
        final int n4 = n3;
        final int n5 = nsIDOMMouseEvent2.getClientX();
        final int n6 = nsIDOMMouseEvent2.getClientY();
        int n7 = 0;
        if ("click".equals(nsIDOMMouseEvent2.getType())) {
            n7 = 1;
        } else if ("dblclick".equals(nsIDOMMouseEvent2.getType())) {
            n7 = 2;
        }
        final int n8 = n7;
        final int n9 = nsIDOMMouseEvent2.getButton() == 0 ? 1 : (nsIDOMMouseEvent2.getButton() == 1 ? 2 : (nsIDOMMouseEvent2.getButton() == 2 ? 3 : 0));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseEvent mouseEvent = new MouseEvent(MouseKeyboardSupport.this.c, n2, l2, n4, n5, n6, n8, false, n9);
                if (this.a()) {
                    ((MozillaComponent)((Object)MouseKeyboardSupport.this.c)).onDispatchEvent(mouseEvent);
                } else if (mouseEvent.getID() == 503) {
                    MouseMotionListener[] mouseMotionListenerArray;
                    for (MouseMotionListener mouseMotionListener : mouseMotionListenerArray = MouseKeyboardSupport.this.c.getMouseMotionListeners()) {
                        mouseMotionListener.mouseMoved(mouseEvent);
                    }
                } else {
                    MouseListener[] mouseListenerArray;
                    block6: for (MouseListener mouseListener : mouseListenerArray = MouseKeyboardSupport.this.c.getMouseListeners()) {
                        switch (mouseEvent.getID()) {
                            case 500: {
                                mouseListener.mouseClicked(mouseEvent);
                                continue block6;
                            }
                            case 501: {
                                mouseListener.mousePressed(mouseEvent);
                                continue block6;
                            }
                            case 502: {
                                mouseListener.mouseReleased(mouseEvent);
                            }
                        }
                    }
                }
            }

            private boolean a() {
                return Float.valueOf(System.getProperty("java.specification.version")).floatValue() >= 1.7f;
            }
        });
    }
}

