/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla;

import com.teamdev.jxbrowser.AbstractBrowser;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFunction;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.dom.DOMFactory;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.gecko.MozillaHttpObserver;
import com.teamdev.jxbrowser.gecko.SearchParams;
import com.teamdev.jxbrowser.gecko.WebBrowser;
import com.teamdev.jxbrowser.gecko.download.DownloadHandler;
import com.teamdev.jxbrowser.gecko.events.HttpObserver;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMManager;
import com.teamdev.jxbrowser.mozilla.MozillaConfigurable;
import com.teamdev.jxbrowser.mozilla.MozillaDownloadHandlerBridge;
import com.teamdev.jxbrowser.mozilla.MozillaHttpSecurity;
import com.teamdev.jxbrowser.mozilla.MozillaJavaScriptJavaBridge;
import com.teamdev.jxbrowser.mozilla.MozillaNewWindowManager;
import com.teamdev.jxbrowser.mozilla.MozillaOfflineHandler;
import com.teamdev.jxbrowser.mozilla.MozillaPrinting;
import com.teamdev.jxbrowser.mozilla.MozillaPrintingFactory;
import com.teamdev.jxbrowser.mozilla.a;
import com.teamdev.jxbrowser.mozilla.b.b;
import com.teamdev.jxbrowser.mozilla.d;
import com.teamdev.jxbrowser.mozilla.e;
import com.teamdev.jxbrowser.print.PrintListener;
import com.teamdev.jxbrowser.script.JavaScriptException;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mozilla.interfaces.nsIDOMMimeType;
import org.mozilla.interfaces.nsIDOMMimeTypeArray;
import org.mozilla.interfaces.nsIDOMNavigator;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMWindowInternal;
import org.mozilla.interfaces.nsIPrefBranch;
import org.mozilla.interfaces.nsIPrefService;
import org.mozilla.interfaces.nsIWebBrowser;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaBrowser
extends AbstractBrowser<WebBrowser> {
    private static MozillaOfflineHandler a;
    private final WebBrowser b;
    private final DOMFactory c;
    private final d d;
    private final MozillaPrinting e;
    private final Configurable f;
    private final a g;
    private final MozillaHttpSecurity h;
    private final com.teamdev.jxbrowser.mozilla.b i;
    private final MozillaJavaScriptJavaBridge j;
    private final MozillaDownloadHandlerBridge k;
    private final List<String> l;

    MozillaBrowser(WebBrowser webBrowser) {
        this.b = webBrowser;
        this.i = new com.teamdev.jxbrowser.mozilla.b(this);
        this.f = new MozillaConfigurable(this);
        this.h = new MozillaHttpSecurity(this);
        this.e = new MozillaPrintingFactory().create(this);
        this.d = new d(this);
        this.g = new a(this);
        this.b.setWindowCreator(MozillaNewWindowManager.getInstance());
        this.c = new b(this);
        this.j = new MozillaJavaScriptJavaBridge();
        this.k = new MozillaDownloadHandlerBridge(this, this.getEventsThread());
        if (a == null) {
            a = new MozillaOfflineHandler();
        }
        MozillaNewWindowManager.getInstance().register(this);
        com.teamdev.jxbrowser.mozilla.e.a().a(this);
        this.l = new ArrayList<String>();
        this.l.add("text/html");
        this.l.add("text/plain");
        this.l.add("text/xml");
        this.l.add("application/xml");
        this.l.add("application/xhtml+xml");
        this.l.add("image/svg+xml");
        this.l.add("image/png");
        this.l.add("image/jpeg");
        this.l.add("image/gif");
    }

    public void dispose() {
        super.dispose();
        if (!this.isDisposed()) {
            nsIWebBrowser nsIWebBrowser2 = this.b.getNsIWebBrowser();
            MozillaHttpObserver.getInstance().removeHttpObserver(nsIWebBrowser2);
            MozillaNewWindowManager.getInstance().unregister(this);
            com.teamdev.jxbrowser.mozilla.e.a().b(this);
            this.b.dispose();
            this.notifyListeners(new DisposeEvent((Browser)this));
        }
    }

    public Configurable getConfigurable() {
        return this.f;
    }

    public void setUserAgent(String string) {
        ProxyObjectManager proxyObjectManager = ProxyObjectManager.getInstance();
        XPCOMManager xPCOMManager = XPCOMManager.getInstance();
        nsIPrefService nsIPrefService2 = proxyObjectManager.proxyForObject(xPCOMManager.getService("@mozilla.org/preferences-service;1", nsIPrefService.class), nsIPrefService.class, true);
        nsIPrefBranch nsIPrefBranch3 = proxyObjectManager.proxyForObject(nsIPrefService2.getBranch("general.useragent."), nsIPrefBranch.class, true);
        if (string == null || string.length() == 0) {
            int n2 = nsIPrefBranch3.getPrefType("override");
            if (n2 != 0) {
                nsIPrefBranch3.clearUserPref("override");
            }
        } else {
            nsIPrefBranch3.setCharPref("override", string);
        }
    }

    public String executeScript(String string) {
        String string2 = null;
        try {
            string2 = this.b.evaluateScript(string);
        }
        catch (Exception exception) {
            throw new JavaScriptException(exception.getMessage());
        }
        return string2;
    }

    public Component getComponent() {
        return this.b.getComponent();
    }

    public String getContent() {
        return this.getContent("text/html");
    }

    public String getContent(String string) {
        return this.b.getDocumentContent(string);
    }

    public Document getDocument() {
        return this.c.createDocument(this.b.getDocument());
    }

    public String getStatusMessage() {
        return this.g.b();
    }

    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.i.a(contextMenuHandler);
    }

    public ContextMenuHandler getContextMenuHandler() {
        return this.i.a();
    }

    public String getTitle() {
        return this.b.getTitle();
    }

    public BrowserType getType() {
        return BrowserType.Mozilla;
    }

    public void goBack() {
        this.d.d();
    }

    public void goForward() {
        this.d.e();
    }

    public boolean isDisposed() {
        return this.b.isDisposed();
    }

    public boolean isNavigationFinished() {
        return this.g.a();
    }

    public void navigate(String string) {
        this.g.a(false);
        this.b.navigate(string);
    }

    public void navigate(String string, String string2) {
        this.g.a(false);
        this.b.navigate(string, string2);
    }

    public void navigate(String string, String string2, long l2) {
        this.g.a(false);
        this.b.navigate(string, string2, l2);
    }

    public void refresh() {
        this.b.refresh();
    }

    public void setContent(String string) {
        this.g.a(false);
        this.setContent(string, null);
    }

    public void setContent(String string, String string2) {
        this.b.setContentWithContext(string, "text/html", string2);
    }

    public void stop() {
        this.b.stop();
    }

    public Image toImage(boolean bl) {
        return this.b.toImage();
    }

    public Image toImage(Dimension dimension) {
        return this.b.toImage(dimension);
    }

    public HttpSecurityHandler getHttpSecurityHandler() {
        return this.h.getHandler();
    }

    public void setHttpSecurityHandler(HttpSecurityHandler httpSecurityHandler) {
        this.h.setHandler(httpSecurityHandler);
    }

    public String getCurrentLocation() {
        return this.b.getLocationURL();
    }

    public boolean canGoBack() {
        return this.d.f();
    }

    public boolean canGoForward() {
        return this.d.g();
    }

    public List<String> getAllHistory() {
        return this.d.a();
    }

    public int getCurrentIndex() {
        return this.d.b();
    }

    public WebBrowser getPeer() {
        return this.b;
    }

    public void setHttpObserver(HttpObserver httpObserver) {
        nsIWebBrowser nsIWebBrowser2 = this.b.getNsIWebBrowser();
        MozillaHttpObserver.getInstance().addHttpObserver(nsIWebBrowser2, httpObserver);
    }

    public boolean isMimeTypeSupported(final String string) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(this.l.contains(string));
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                XPCOMManager xPCOMManager = XPCOMManager.getInstance();
                nsIDOMWindow nsIDOMWindow3 = MozillaBrowser.this.b.getNsIWebBrowser().getContentDOMWindow();
                nsIDOMWindowInternal nsIDOMWindowInternal2 = xPCOMManager.queryInterface(nsIDOMWindow3, nsIDOMWindowInternal.class);
                nsIDOMNavigator nsIDOMNavigator2 = nsIDOMWindowInternal2.getNavigator();
                nsIDOMMimeTypeArray nsIDOMMimeTypeArray2 = nsIDOMNavigator2.getMimeTypes();
                long l2 = nsIDOMMimeTypeArray2.getLength();
                int n2 = 0;
                while ((long)n2 < l2) {
                    nsIDOMMimeType nsIDOMMimeType2 = nsIDOMMimeTypeArray2.item(n2);
                    String string2 = nsIDOMMimeType2.getType();
                    if (string2.equals(string)) {
                        atomicBoolean.set(true);
                        break;
                    }
                    ++n2;
                }
            }
        });
        return atomicBoolean.get();
    }

    public boolean isReady() {
        return this.isNavigationFinished();
    }

    public void registerFunction(String string, BrowserFunction browserFunction) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.j.getContractID();
        stringBuilder.append("window.").append(string).append(" = function ").append(string).append("() {\n").append("    netscape.security.PrivilegeManager.enablePrivilege(\"UniversalXPConnect\");\n").append("    var javaScriptJavaBridge = Components.classes['").append(string2).append("'].createInstance(Components.interfaces.nsIJavaScriptJavaBridge);\n").append("    var args = Components.classes[\"@mozilla.org/array;1\"].createInstance(Components.interfaces.nsIMutableArray);\n").append("    for (var i = 0; i < arguments.length; i++) {\n").append("        var variant = Components.classes[\"@mozilla.org/variant;1\"].createInstance(Components.interfaces.nsIWritableVariant);\n").append("        variant.setFromVariant(arguments[i]);\n").append("        args.appendElement(variant, false);\n").append("    }\n").append("    return javaScriptJavaBridge.callJavaFunction(\"").append(string).append("\", args);\n").append("}");
        this.executeScript(stringBuilder.toString());
        this.j.registerFunction(string, browserFunction);
    }

    public void print() {
        this.print(null);
    }

    public void print(PrintListener printListener) {
        if (this.e != null) {
            this.e.print(printListener);
        }
    }

    public void saveWebPage(File file, String string) {
        this.b.saveWebPage(file, string);
    }

    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.k.setDownloadHandler(downloadHandler);
    }

    public DownloadHandler getDownloadHandler() {
        return this.k.getDownloadHandler();
    }

    public boolean find(String string) {
        return this.find(string, new SearchParams());
    }

    public boolean find(final String string, final SearchParams searchParams) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("text can't be null or empty.");
        }
        if (searchParams == null) {
            throw new NullPointerException("params can't be null.");
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                atomicBoolean.set(MozillaBrowser.this.getPeer().findNext(string, searchParams));
            }
        });
        return atomicBoolean.get();
    }
}

