/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.xpcom.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.xpcom.internal.XPCOMJavaProxyBase;

public class XPCOMJavaProxy
implements InvocationHandler {
    protected long nativeXPCOMPtr;

    public XPCOMJavaProxy(long l2) {
        this.nativeXPCOMPtr = l2;
    }

    protected static long getNativeXPCOMInstance(Object object) {
        XPCOMJavaProxy xPCOMJavaProxy = (XPCOMJavaProxy)Proxy.getInvocationHandler(object);
        return xPCOMJavaProxy.nativeXPCOMPtr;
    }

    protected static Object createProxy(Class clazz, long l2) {
        return Proxy.newProxyInstance(XPCOMJavaProxy.class.getClassLoader(), new Class[]{clazz, XPCOMJavaProxyBase.class}, (InvocationHandler)new XPCOMJavaProxy(l2));
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if (string.equals("hashCode")) {
                return XPCOMJavaProxy.proxyHashCode(object);
            }
            if (string.equals("equals")) {
                return XPCOMJavaProxy.proxyEquals(object, objectArray[0]);
            }
            if (string.equals("toString")) {
                return XPCOMJavaProxy.proxyToString(object);
            }
            System.err.println("WARNING: Unhandled Object method [" + string + "]");
            return null;
        }
        if (method.getDeclaringClass() == XPCOMJavaProxyBase.class) {
            if (string.equals("finalize")) {
                this.finalizeProxy(object);
            } else {
                System.err.println("WARNING: Unhandled XPCOMJavaProxyBase method [" + string + "]");
            }
            return null;
        }
        return XPCOMJavaProxy.callXPCOMMethod(object, string, objectArray);
    }

    protected static Integer proxyHashCode(Object object) {
        return System.identityHashCode(object);
    }

    protected static Boolean proxyEquals(Object object, Object object2) {
        if (object == object2) {
            return Boolean.TRUE;
        }
        if (XPCOMJavaProxy.isXPCOMJavaProxy(object2) && XPCOMJavaProxy.isSameXPCOMObject(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static boolean isXPCOMJavaProxy(Object object) {
        InvocationHandler invocationHandler;
        return object != null && Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof XPCOMJavaProxy;
    }

    protected static native boolean isSameXPCOMObject(Object var0, Object var1);

    protected static String proxyToString(Object object) {
        return object.getClass().getInterfaces()[0].getName() + '@' + Integer.toHexString(object.hashCode());
    }

    protected void finalizeProxy(Object object) throws Throwable {
        XPCOMJavaProxy.finalizeProxyNative(object);
        super.finalize();
    }

    protected static native void finalizeProxyNative(Object var0);

    protected static native Object callXPCOMMethod(Object var0, String var1, Object[] var2);
}

