/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.gradient;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.jdesktop.swingx.painter.gradient.AbstractGradientPainter;

public class BasicGradientPainter
extends AbstractGradientPainter {
    public static final GradientPaint BLUE_EXPERIENCE = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(168, 204, 241), new Point2D.Double(0.0, 1.0), new Color(44, 61, 146));
    public static final GradientPaint MAC_OSX_SELECTED = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(81, 141, 236), new Point2D.Double(0.0, 1.0), new Color(36, 96, 192));
    public static final GradientPaint MAC_OSX = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(167, 210, 250), new Point2D.Double(0.0, 1.0), new Color(99, 147, 206));
    public static final GradientPaint AERITH = new GradientPaint(new Point2D.Double(0.0, 0.0), Color.WHITE, new Point2D.Double(0.0, 1.0), new Color(64, 110, 161));
    public static final GradientPaint GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(226, 226, 226), new Point2D.Double(0.0, 1.0), new Color(250, 248, 248));
    public static final GradientPaint RED_XP = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(236, 81, 81), new Point2D.Double(0.0, 1.0), new Color(192, 36, 36));
    public static final GradientPaint NIGHT_GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(102, 111, 127), new Point2D.Double(0.0, 1.0), new Color(38, 45, 61));
    public static final GradientPaint NIGHT_GRAY_LIGHT = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(129, 138, 155), new Point2D.Double(0.0, 1.0), new Color(58, 66, 82));
    private GradientPaint paint;

    public BasicGradientPainter() {
    }

    public BasicGradientPainter(GradientPaint paint) {
        this.paint = paint;
    }

    public BasicGradientPainter(float x1, float y1, Color startColor, float x2, float y2, Color endColor) {
        this.paint = new GradientPaint(x1, y1, startColor, x2, y2, endColor);
    }

    public BasicGradientPainter(Point2D startPoint, Color startColor, Point2D endPoint, Color endColor) {
        this.paint = new GradientPaint(startPoint, startColor, endPoint, endColor);
    }

    public BasicGradientPainter(float x1, float y1, Color startColor, float x2, float y2, Color endColor, boolean cyclic) {
        this.paint = new GradientPaint(x1, y1, startColor, x2, y2, endColor, cyclic);
    }

    public BasicGradientPainter(Point2D startPoint, Color startColor, Point2D endPoint, Color endColor, boolean cyclic) {
        this.paint = new GradientPaint(startPoint, startColor, endPoint, endColor, cyclic);
    }

    public void setGradientPaint(GradientPaint paint) {
        GradientPaint old = this.getGradientPaint();
        this.paint = paint;
        this.firePropertyChange("gradientPaint", old, this.getGradientPaint());
    }

    public GradientPaint getGradientPaint() {
        return this.paint;
    }

    protected Paint calculateSizedPaint(int width, int height) {
        GradientPaint paint = this.getGradientPaint();
        if (paint == null) {
            return null;
        }
        Point2D startPoint = paint.getPoint1();
        Point2D endPoint = paint.getPoint2();
        double x1 = this.isResizeHorizontal() ? startPoint.getX() * (double)width : startPoint.getX();
        double y1 = this.isResizeVertical() ? startPoint.getY() * (double)height : startPoint.getY();
        double x2 = this.isResizeHorizontal() ? endPoint.getX() * (double)width : endPoint.getX();
        double y2 = this.isResizeVertical() ? endPoint.getY() * (double)height : endPoint.getY();
        startPoint = new Point2D.Double(x1, y1);
        endPoint = new Point2D.Double(x2, y2);
        return new GradientPaint(startPoint, paint.getColor1(), endPoint, paint.getColor2());
    }
}

