/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.wsi.test.ToolEnvironment;
import org.wsi.test.util.XMLInfo;
import org.wsi.util.Utils;

public class ToolInfo {
    public static final String PROP_TOOL_VERSION = "wsi.tool.version";
    public static final String PROP_TOOL_RELEASE_DATE = "wsi.tool.release.date";
    public static final String PROP_TOOL_IMPLEMENTER = "wsi.tool.implementer";
    public static final String PROP_TOOL_LOCATION = "wsi.tool.location";
    private static final String DEF_TOOL_VERSION = "1.1";
    private static final String DEF_TOOL_RELEASE_DATE = "2005-06-22";
    private static final String DEF_TOOL_IMPLEMENTER = "WS-I Organization";
    private static final String DEF_TOOL_LOCATION = "http://www.ws-i.org";
    protected String name;
    protected String version;
    protected String releaseDate;
    protected String implementer;
    protected String location;
    protected ToolEnvironment toolEnvironment = null;
    public static final String PROP_FILENAME = "org.wsi.test.toolinfo";
    private static final String COMMENTS = "";

    public ToolInfo() {
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String string) {
        this.name = string;
        this.getProperties();
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.version = string2;
        this.releaseDate = string3;
        this.implementer = string4;
        this.location = string5;
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String string, String string2, String string3, String string4, String string5, XMLInfo xMLInfo) {
        this.name = string;
        this.version = string2;
        this.releaseDate = string3;
        this.implementer = string4;
        this.location = string5;
        this.toolEnvironment = new ToolEnvironment(xMLInfo);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getImplementer() {
        return this.implementer;
    }

    public String getLocation() {
        return this.location;
    }

    public ToolEnvironment getToolEnvironment() {
        return this.toolEnvironment;
    }

    public void setImplementer(String string) {
        this.implementer = string;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReleaseDate(String string) {
        this.releaseDate = string;
    }

    public void setToolEnvironment(ToolEnvironment toolEnvironment) {
        this.toolEnvironment = toolEnvironment;
    }

    public void setAdditionalToolEnvironment(XMLInfo xMLInfo) {
        this.toolEnvironment.setAdditionalToolEnvironment(xMLInfo);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getStartXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals(COMMENTS)) {
            string2 = string2 + ":";
        }
        printWriter.print("  <" + string2 + this.getName().toLowerCase() + " ");
        printWriter.print("version=\"" + this.getVersion() + "\" ");
        printWriter.println("releaseDate=\"" + this.getReleaseDate() + "\">");
        printWriter.print("    <" + string2 + "implementer" + " ");
        printWriter.print("name=\"" + this.getImplementer() + "\" ");
        printWriter.println("location=\"" + this.getLocation() + "\"/>");
        printWriter.print(this.toolEnvironment.toXMLString(string));
        return stringWriter.toString();
    }

    public String getEndXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals(COMMENTS)) {
            string2 = string2 + ":";
        }
        printWriter.println("  </" + string2 + this.getName().toLowerCase() + ">");
        return stringWriter.toString();
    }

    protected void getProperties() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PROP_FILENAME);
            this.version = this.getProperty(resourceBundle, PROP_TOOL_VERSION, DEF_TOOL_VERSION);
            this.releaseDate = this.getProperty(resourceBundle, PROP_TOOL_RELEASE_DATE, DEF_TOOL_RELEASE_DATE);
            this.implementer = this.getProperty(resourceBundle, PROP_TOOL_IMPLEMENTER, DEF_TOOL_IMPLEMENTER);
            this.location = this.getProperty(resourceBundle, PROP_TOOL_LOCATION, DEF_TOOL_LOCATION);
        }
        catch (MissingResourceException missingResourceException) {
            this.version = DEF_TOOL_VERSION;
            this.releaseDate = DEF_TOOL_RELEASE_DATE;
            this.implementer = DEF_TOOL_IMPLEMENTER;
            this.location = DEF_TOOL_LOCATION;
        }
    }

    protected String getProperty(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = resourceBundle.getString(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private String formatToolLocation(String string) {
        String string2 = string;
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2 + this.getName() + ".html";
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = PROP_FILENAME;
        String string2 = DEF_TOOL_VERSION;
        String string3 = DEF_TOOL_IMPLEMENTER;
        String string4 = DEF_TOOL_LOCATION;
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        if (stringArray.length >= 3) {
            string3 = stringArray[2];
        }
        if (stringArray.length >= 4) {
            string4 = stringArray[3];
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(COMMENTS);
            printWriter.println("wsi.tool.version=" + string2);
            printWriter.println("wsi.tool.release.date=" + Utils.getDate());
            printWriter.println("wsi.tool.implementer=" + string3);
            printWriter.println("wsi.tool.location=" + string4);
            fileWriter.close();
            System.out.println("File [" + string + "] created.");
        }
        catch (IOException iOException) {
            n = 1;
            System.out.println("EXCEPTION: " + iOException.toString());
            iOException.printStackTrace();
        }
        System.exit(n);
    }
}

