/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.analyzer.config.impl;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSIFileNotFoundException;
import org.wsi.test.analyzer.config.AnalyzerConfig;
import org.wsi.test.analyzer.config.AnalyzerConfigReader;
import org.wsi.test.analyzer.config.AssertionResultType;
import org.wsi.test.analyzer.config.AssertionResultsOption;
import org.wsi.test.analyzer.config.WSDLElement;
import org.wsi.test.analyzer.config.impl.AnalyzerConfigImpl;
import org.wsi.test.analyzer.config.impl.AssertionResultsOptionImpl;
import org.wsi.test.analyzer.config.impl.UDDIReferenceImpl;
import org.wsi.test.analyzer.config.impl.WSDLElementImpl;
import org.wsi.test.analyzer.config.impl.WSDLReferenceImpl;
import org.wsi.test.common.impl.AddStyleSheetImpl;
import org.wsi.test.util.TestUtils;
import org.wsi.util.MessageList;
import org.wsi.xml.XMLUtils;

public class AnalyzerConfigReaderImpl
implements AnalyzerConfigReader {
    protected MessageList messageList;
    protected String documentURI;

    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    public AnalyzerConfig readAnalyzerConfig(String string) throws WSIException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WSIFileNotFoundException(this.getMessage("config01", string, "Could not find analyzer config file: "), fileNotFoundException);
        }
        catch (Exception exception) {
            throw new WSIException(this.getMessage("config08", string, "Could not read analyzer config file: "), exception);
        }
        return this.readAnalyzerConfig(fileReader);
    }

    public AnalyzerConfig readAnalyzerConfig(Reader reader) throws WSIException {
        AnalyzerConfigImpl analyzerConfigImpl = new AnalyzerConfigImpl();
        Document document = XMLUtils.parseXML(reader);
        this.parseConfigElement(analyzerConfigImpl, document.getDocumentElement());
        return analyzerConfigImpl;
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String string) {
        this.documentURI = string;
    }

    private void parseConfigElement(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            Object object;
            if (this.isElement(element2, "description")) {
                analyzerConfig.setDescription(XMLUtils.getText(element2));
            } else if (this.isElement(element2, "verbose")) {
                analyzerConfig.setVerboseOption(XMLUtils.getBooleanValue(element2, false));
            } else if (this.isElement(element2, "assertionResults")) {
                object = new AssertionResultsOptionImpl();
                analyzerConfig.setAssertionResultsOption((AssertionResultsOption)object);
                String string = XMLUtils.getAttributeValue(element2, "type");
                object.setAssertionResultType(AssertionResultType.newInstance(string));
                object.setShowMessageEntry(XMLUtils.getBooleanValue(element2, "messageEntry", object.getShowMessageEntry()));
                object.setShowFailureMessage(XMLUtils.getBooleanValue(element2, "failureMessage", object.getShowFailureMessage()));
                object.setShowFailureDetail(XMLUtils.getBooleanValue(element2, "failureDetail", object.getShowFailureDetail()));
            } else if (this.isElement(element2, "reportFile")) {
                this.parseReportFileElement(analyzerConfig, element2);
            } else if (this.isElement(element2, "testAssertionsFile")) {
                analyzerConfig.setTestAssertionsDocumentLocation(XMLUtils.getText(element2));
            } else if (this.isElement(element2, "logFile")) {
                object = XMLUtils.getAttributeValue(element2, "correlationType");
                analyzerConfig.setCorrelationType((String)(object == null ? "operation" : object));
                analyzerConfig.setLogLocation(XMLUtils.getText(element2));
            } else if (this.isElement(element2, "wsdlReference")) {
                this.parseWsdlReference(analyzerConfig, element2);
            } else if (this.isElement(element2, "uddiReference")) {
                this.parseUddiReference(analyzerConfig, element2);
            } else {
                throw new IllegalArgumentException(this.getMessage("config06", element2.getLocalName(), "Invalid analyzer config element:"));
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
    }

    private void parseReportFileElement(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        analyzerConfig.setReplaceReport(XMLUtils.getBooleanValue(element, "replace", false));
        analyzerConfig.setReportLocation(XMLUtils.getAttributeValue(element, "location", "report.xml"));
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            if (!this.isElement(element2, "addStyleSheet")) {
                throw new IllegalArgumentException(this.getMessage("config06", element2.getLocalName(), "Invalid analyzer config element:"));
            }
            AddStyleSheetImpl addStyleSheetImpl = new AddStyleSheetImpl();
            TestUtils.parseAddStyleSheet(element2, addStyleSheetImpl, "../common/xsl/report.xsl");
            analyzerConfig.setAddStyleSheet(addStyleSheetImpl);
            element2 = XMLUtils.getNextSibling(element2);
        }
    }

    private void parseWsdlReference(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        WSDLReferenceImpl wSDLReferenceImpl = new WSDLReferenceImpl();
        analyzerConfig.setWSDLReference(wSDLReferenceImpl);
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            if (this.isElement(element2, "wsdlURI")) {
                wSDLReferenceImpl.setWSDLLocation(XMLUtils.getText(element2));
            } else if (this.isElement(element2, "serviceLocation")) {
                wSDLReferenceImpl.setServiceLocation(XMLUtils.getText(element2));
            } else if (this.isElement(element2, "wsdlElement")) {
                wSDLReferenceImpl.setWSDLElement(this.parseWsdlElement(element2));
            } else {
                throw new IllegalArgumentException(this.getMessage("config06", element2.getLocalName(), "Invalid analyzer config element:"));
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
        if (wSDLReferenceImpl.getWSDLElement() == null || wSDLReferenceImpl.getWSDLLocation() == null) {
            throw new IllegalArgumentException(this.getMessage("config07", "Both the <wsdlElement> and <wsdlURI> elements must be specified."));
        }
        if ((wSDLReferenceImpl.getWSDLElement().getType().equalsIgnoreCase("port") || wSDLReferenceImpl.getWSDLElement().getType().equalsIgnoreCase("operation")) && wSDLReferenceImpl.getWSDLElement().getParentElementName() == null) {
            throw new IllegalArgumentException(this.getMessage("config09", "The parentElementName attribute must be specified with a WSDL type of port or operation."));
        }
    }

    private void parseUddiReference(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        UDDIReferenceImpl uDDIReferenceImpl = new UDDIReferenceImpl();
        analyzerConfig.setUDDIReference(uDDIReferenceImpl);
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            if (this.isElement(element2, "inquiryURL")) {
                uDDIReferenceImpl.setInquiryURL(XMLUtils.getText(element2));
            } else if (this.isElement(element2, "uddiKey")) {
                uDDIReferenceImpl.setKey(XMLUtils.getText(element2));
                uDDIReferenceImpl.setKeyType(XMLUtils.getAttributeValue(element2, "type"));
            } else if (this.isElement(element2, "wsdlElement")) {
                uDDIReferenceImpl.setWSDLElement(this.parseWsdlElement(element2));
            } else if (this.isElement(element2, "serviceLocation")) {
                uDDIReferenceImpl.setServiceLocation(XMLUtils.getText(element2));
            } else {
                throw new IllegalArgumentException(this.getMessage("config06", element2.getLocalName(), "Invalid analyzer config element:"));
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
    }

    private WSDLElement parseWsdlElement(Element element) throws WSIException {
        WSDLElementImpl wSDLElementImpl = new WSDLElementImpl();
        wSDLElementImpl.setType(XMLUtils.getAttributeValue(element, "type"));
        wSDLElementImpl.setNamespace(XMLUtils.getAttributeValue(element, "namespace"));
        wSDLElementImpl.setParentElementName(XMLUtils.getAttributeValue(element, "parentElementName"));
        String string = XMLUtils.getText(element);
        if (string.equals("")) {
            throw new IllegalArgumentException(this.getMessage("config19", "The WSDL element name must be specified."));
        }
        wSDLElementImpl.setName(string);
        return wSDLElementImpl;
    }

    private boolean isElement(Element element, String string) {
        return this.isElement(element, AnalyzerConfigReaderImpl.getValidWSIAnalyzerConfigNamespaces(), string);
    }

    public static List getValidWSIAnalyzerConfigNamespaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("http://www.ws-i.org/testing/2003/03/analyzerConfig/");
        arrayList.add("http://www.ws-i.org/testing/2004/07/analyzerConfig/");
        return arrayList;
    }

    private boolean isElement(Element element, List list, String string) {
        return XMLUtils.isElement(element, list, string);
    }

    private boolean isElement(Element element, String string, String string2) {
        return XMLUtils.isElement(element, string, string2);
    }

    private String getMessage(String string, String string2) {
        return this.getMessage(string, null, string2);
    }

    private String getMessage(String string, String string2, String string3) {
        String string4 = string3;
        string4 = this.messageList != null ? this.messageList.getMessage(string, string2, string3) : string4 + " " + string2 + ".";
        return string4;
    }
}

