/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Vector;
import org.wsi.WSIConstants;
import org.wsi.WSIException;
import org.wsi.WSIFileNotFoundException;
import org.wsi.test.ToolInfo;
import org.wsi.test.document.DocumentFactory;
import org.wsi.test.log.Log;
import org.wsi.test.log.LogWriter;
import org.wsi.test.monitor.MessageEntryQueue;
import org.wsi.test.monitor.ServerSocketListener;
import org.wsi.test.monitor.config.ManInTheMiddle;
import org.wsi.test.monitor.config.MonitorConfig;
import org.wsi.test.monitor.config.Redirect;
import org.wsi.test.util.TestUtils;
import org.wsi.util.MessageList;

public class Monitor {
    protected MessageList messageList = null;
    private static final String RESOURCE_BUNDLE_NAME = "org.wsi.test.monitor.Monitor";
    public static final String USAGE_MESSAGE = "Usage: Monitor -config <configFilename>";
    private int conversationId = 1;
    private Log log = null;
    private LogWriter logWriter = null;
    private MonitorConfig monitorConfig = null;
    public static final String TOOL_NAME = "Monitor";
    protected ToolInfo toolInfo = null;
    protected Vector listenerList = new Vector();
    protected MessageEntryQueue messageEntryQueue = null;

    public Monitor(String[] stringArray) throws WSIException {
        this.messageList = new MessageList(RESOURCE_BUNDLE_NAME);
        this.toolInfo = new ToolInfo(TOOL_NAME);
        DocumentFactory documentFactory = DocumentFactory.newInstance();
        this.monitorConfig = documentFactory.newMonitorConfig();
        this.monitorConfig.init(this.messageList);
        this.monitorConfig.parseArgs(stringArray);
        String string = this.monitorConfig.getLogLocation();
        if (string.indexOf(WSIConstants.PATH_SEPARATOR) > -1) {
            throw new WSIException(this.messageList.getMessage("config11", this.monitorConfig.getLogLocation(), "The log file location value cannot contain the pass separator character:"));
        }
        File file = null;
        try {
            file = new File(this.monitorConfig.getLogLocation());
        }
        catch (Exception exception) {
            throw new WSIException(this.messageList.getMessage("config07", "Could not get log file location."), exception);
        }
        if (file.exists() && !this.monitorConfig.getReplaceLog()) {
            throw new IllegalArgumentException(this.messageList.getMessage("config08", this.monitorConfig.getLogLocation(), "Log file already exists:"));
        }
        try {
            this.log = documentFactory.newLog();
            this.log.setStyleSheetString(this.monitorConfig.getAddStyleSheet().getStyleSheetString());
            this.logWriter = documentFactory.newLogWriter();
            this.logWriter.setWriter(this.monitorConfig.getLogLocation());
            this.logWriter.write(new StringReader(this.log.getStartXMLString("")));
            this.logWriter.write(new StringReader(this.toXMLString("")));
            this.messageEntryQueue = new MessageEntryQueue(this, this.log, this.logWriter);
        }
        catch (Exception exception) {
            throw new WSIException(this.messageList.getMessage("error03", "Could not create log or log writer."), exception);
        }
        ManInTheMiddle manInTheMiddle = this.monitorConfig.getManInTheMiddle();
        Iterator iterator = manInTheMiddle.getRedirectList().iterator();
        while (iterator.hasNext()) {
            Redirect redirect = (Redirect)iterator.next();
            this.listenerList.add(new ServerSocketListener(this, redirect));
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        Console console = new Console();
        console.start();
    }

    public MonitorConfig getMonitorConfig() {
        return this.monitorConfig;
    }

    public Log getLog() {
        return this.log;
    }

    public MessageEntryQueue getMessageEntryQueue() {
        return this.messageEntryQueue;
    }

    void exitMonitor() {
        this.printMessage("stopping01", "Stopping the monitor...");
        System.exit(0);
    }

    void exitMonitor(Exception exception) {
        this.printMessage("stopping02", "Stopping monitor because an exception occurred.");
        System.err.println("EXCEPTION: " + exception.toString());
        if (this.monitorConfig.getVerboseOption()) {
            exception.printStackTrace();
        }
        this.exitMonitor();
    }

    void stopMonitor() {
        try {
            Iterator iterator = this.listenerList.iterator();
            while (iterator.hasNext()) {
                ((ServerSocketListener)iterator.next()).shutdown();
            }
            Thread.sleep(this.monitorConfig.getTimeout() * 1000);
            if (this.logWriter != null) {
                this.logWriter.write(new StringReader(this.log.getEndXMLString("")));
                this.logWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.printMessage("stopped01", "Monitor stopped.");
    }

    public static void main(String[] stringArray) {
        Monitor monitor = null;
        try {
            if (stringArray.length < 2) {
                Monitor.staticPrintMessage("usage01", USAGE_MESSAGE);
                System.exit(1);
            }
            if (!stringArray[0].equalsIgnoreCase("-config")) {
                Monitor.staticPrintMessage("usage01", USAGE_MESSAGE);
                System.exit(1);
            }
            monitor = new Monitor(stringArray);
        }
        catch (Exception exception) {
            String string;
            String string2;
            String string3;
            boolean bl = true;
            if (exception instanceof WSIFileNotFoundException || exception instanceof IllegalArgumentException) {
                bl = false;
                string3 = "error01";
                string2 = "Monitor Error:";
                string = exception.getMessage();
            } else {
                bl = true;
                string3 = "error02";
                string2 = "Monitor Stopped By Exception:";
                string = exception.toString();
            }
            if (monitor != null) {
                monitor.printMessage(string3, string, string2);
            } else {
                Monitor.staticPrintMessage(string3, string, string2);
            }
            if (bl) {
                exception.printStackTrace();
            }
            if (monitor != null) {
                monitor.exitMonitor();
            }
            System.exit(2);
        }
    }

    public void printMessage(String string, String string2) {
        this.printMessage(string, null, string2);
    }

    public void printMessage(String string, String string2, String string3) {
        this.messageList.printMessage(string, string2, string3);
    }

    public static void staticPrintMessage(String string, String string2) {
        Monitor.staticPrintMessage(string, null, string2);
    }

    public static void staticPrintMessage(String string, String string2, String string3) {
        MessageList.printMessage(RESOURCE_BUNDLE_NAME, string, string2, string3);
    }

    synchronized int getNextConversationId() {
        return this.conversationId++;
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(this.toolInfo.getStartXMLString(string));
        printWriter.print(this.monitorConfig.toXMLString("wsi-monConfig"));
        printWriter.println(this.toolInfo.getEndXMLString(string));
        return stringWriter.toString();
    }

    class Console
    extends Thread {
        Console() {
        }

        public void run() {
            Object var1_1 = null;
            String string = Monitor.this.messageList.getMessage("exit01", "exit");
            TestUtils.printToolInfo(Monitor.this.toolInfo);
            System.out.print(Monitor.this.monitorConfig.toString());
            System.out.println(" ");
            Monitor.this.printMessage("start01", "The " + Monitor.this.toolInfo.getName() + " tool is ready to intercept and log web service messages.");
            Monitor.this.printMessage("start02", "Type \"exit\" to stop the " + Monitor.this.toolInfo.getName() + ".");
            System.out.println(" ");
            long l = System.currentTimeMillis() + (long)(Monitor.this.monitorConfig.getLogDuration() * 1000);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                boolean bl = false;
                while (!bl && System.currentTimeMillis() < l) {
                    Thread.sleep(500L);
                    if (!bufferedReader.ready() || !bufferedReader.readLine().equalsIgnoreCase(string)) continue;
                    bl = true;
                }
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
            Monitor.this.exitMonitor();
        }
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            Monitor.this.stopMonitor();
        }
    }
}

