/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor;

import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.log.MessageEntry;
import org.wsi.test.log.MimeParts;
import org.wsi.test.monitor.ConnectionListener;
import org.wsi.test.monitor.Monitor;
import org.wsi.test.monitor.SocketHandler;
import org.wsi.test.monitor.config.Redirect;
import org.wsi.util.Utils;

public class SocketConnection
extends Thread {
    protected Monitor monitor;
    protected Redirect redirect;
    protected Socket inSocket;
    protected Socket outSocket;
    protected String httpProxyHost = null;
    protected int httpProxyPort;
    protected SocketHandler requestSocketHandler = null;
    protected SocketHandler responseSocketHandler = null;
    private Vector listeners = new Vector();

    public SocketConnection(Monitor monitor, Redirect redirect, Socket socket) {
        this.monitor = monitor;
        this.redirect = redirect;
        this.inSocket = socket;
        this.start();
    }

    public void run() {
        this.loadHttpProxySettings();
        try {
            this.outSocket = new Socket(this.redirect.getToHost(), this.redirect.getToPort());
            this.inSocket.setSoTimeout(this.redirect.getReadTimeoutSeconds() * 1000);
            int n = this.monitor.getNextConversationId();
            this.requestSocketHandler = new SocketHandler(this, "request", n, this.redirect.getToHost(), this.inSocket, this.outSocket, this.redirect.getReadTimeoutSeconds());
            this.responseSocketHandler = new SocketHandler(this, "response", n, this.redirect.getToHost(), this.outSocket, this.inSocket, this.redirect.getReadTimeoutSeconds());
            this.requestSocketHandler.setPairedSocketHandler(this.responseSocketHandler);
            this.responseSocketHandler.setPairedSocketHandler(this.requestSocketHandler);
        }
        catch (Exception exception) {
            Monitor.staticPrintMessage("error04", this.redirect.getToHost(), "Monitor cannot connect to a redirect host:");
            this.shutdown();
            try {
                this.inSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void logMessage(int n, String string, String string2, String string3, String string4, StringBuffer stringBuffer, int n2, String string5) throws WSIException {
        MessageEntry messageEntry = null;
        messageEntry = this.createMessageEntry(n, string, string2, string3, string4, stringBuffer.toString(), n2, string5);
        this.monitor.getMessageEntryQueue().addMessageEntry(messageEntry);
    }

    private MessageEntry createMessageEntry(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6) throws WSIException {
        MessageEntry messageEntry = this.monitor.getLog().createLogEntry();
        messageEntry.setConversationId(String.valueOf(n));
        messageEntry.setType(string);
        messageEntry.setTimestamp(string2);
        messageEntry.setSenderHostAndPort(string3);
        messageEntry.setReceiverHostAndPort(string4);
        messageEntry.setEncoding(string6);
        String string7 = Utils.getHTTPHeaders(string5);
        messageEntry.setHTTPHeaders(string7);
        if (Utils.isMultipartRelatedMessage(string7)) {
            MimeParts mimeParts = Utils.parseMultipartRelatedMessage(string5, string7, string6);
            if (mimeParts == null) {
                String string8 = Utils.getContent(string5);
                messageEntry.setMessage(string8);
                messageEntry.setMimeContent(false);
            } else {
                messageEntry.setMimeParts(mimeParts);
                messageEntry.setMimeContent(true);
            }
        } else {
            String string9 = Utils.getContent(string5);
            messageEntry.setMessage(string9);
            messageEntry.setMimeContent(false);
        }
        if (n2 != 0) {
            messageEntry.setBOM(n2);
        }
        return messageEntry;
    }

    public void loadHttpProxySettings() {
        this.httpProxyHost = System.getProperty("http.proxyHost");
        if (this.httpProxyHost != null && this.httpProxyHost.equals("")) {
            this.httpProxyHost = null;
        }
        if (this.httpProxyHost != null) {
            String string = System.getProperty("http.proxyPort");
            this.httpProxyPort = string == null || string.equals("") ? 80 : Integer.parseInt(string);
        }
    }

    Monitor getMonitor() {
        return this.monitor;
    }

    synchronized void wakeUp() {
        this.fireConnectionClosed();
        this.notifyAll();
    }

    public void shutdown() {
        if (this.requestSocketHandler != null) {
            this.requestSocketHandler.shutdown();
        }
        if (this.responseSocketHandler != null) {
            this.responseSocketHandler.shutdown();
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.listeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.listeners.remove(connectionListener);
    }

    private void fireConnectionClosed() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionListener connectionListener = (ConnectionListener)iterator.next();
            connectionListener.connectionClosed(this);
        }
    }
}

