/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor.config.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.wsi.WSIException;
import org.wsi.test.common.AddStyleSheet;
import org.wsi.test.common.impl.AddStyleSheetImpl;
import org.wsi.test.document.DocumentElement;
import org.wsi.test.monitor.config.Comment;
import org.wsi.test.monitor.config.ManInTheMiddle;
import org.wsi.test.monitor.config.MonitorConfig;
import org.wsi.test.monitor.config.impl.CommentImpl;
import org.wsi.test.monitor.config.impl.ManInTheMiddleImpl;
import org.wsi.test.monitor.config.impl.MonitorConfigReaderImpl;
import org.wsi.test.monitor.config.impl.RedirectImpl;
import org.wsi.util.MessageList;

public class MonitorConfigImpl
implements MonitorConfig {
    protected MessageList messageList = null;
    protected String documentURI = null;
    protected Comment comment = null;
    protected String logURI;
    protected boolean replaceLog = false;
    protected AddStyleSheet addStyleSheet;
    protected int logDuration = 600;
    protected int timeout = 3;
    protected ManInTheMiddle manInTheMiddle = null;
    protected boolean verbose = false;

    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public String getLogLocation() {
        return this.logURI;
    }

    public void setLogLocation(String string) {
        this.logURI = string;
    }

    public boolean getReplaceLog() {
        return this.replaceLog;
    }

    public void setReplaceLog(boolean bl) {
        this.replaceLog = bl;
    }

    public AddStyleSheet getAddStyleSheet() {
        return this.addStyleSheet;
    }

    public void setAddStyleSheet(AddStyleSheet addStyleSheet) {
        this.addStyleSheet = addStyleSheet;
    }

    public int getLogDuration() {
        return this.logDuration;
    }

    public void setLogDuration(int n) {
        this.logDuration = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public ManInTheMiddle getManInTheMiddle() {
        return this.manInTheMiddle;
    }

    public void setManInTheMiddle(ManInTheMiddle manInTheMiddle) {
        this.manInTheMiddle = manInTheMiddle;
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String string) {
        this.documentURI = string;
    }

    public boolean getVerboseOption() {
        return this.verbose;
    }

    public void setVerboseOption(boolean bl) {
        this.verbose = bl;
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("") && !string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        printWriter.println("    <" + string2 + "configuration" + ">");
        if (this.comment != null) {
            printWriter.print(this.comment.toXMLString(string2));
        }
        printWriter.print("      <" + string2 + "logFile" + " ");
        printWriter.print("replace=\"" + this.replaceLog + "\" ");
        printWriter.println("location=\"" + this.logURI + "\">");
        printWriter.print(this.getAddStyleSheet().toXMLString(string));
        printWriter.println("    </" + string2 + "logFile" + ">");
        printWriter.print("      <" + string2 + "logDuration" + ">");
        printWriter.print(this.logDuration);
        printWriter.println("</" + string2 + "logDuration" + ">");
        printWriter.print("      <" + string2 + "cleanupTimeoutSeconds" + ">");
        printWriter.print(this.timeout);
        printWriter.println("</" + string2 + "cleanupTimeoutSeconds" + ">");
        if (this.manInTheMiddle != null) {
            printWriter.print(this.manInTheMiddle.toXMLString(string2));
        }
        printWriter.println("    </" + string2 + "configuration" + ">");
        return stringWriter.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("  comment ..................... " + this.comment);
        printWriter.println("  logURI ...................... " + this.logURI);
        printWriter.println("  replaceLog .................. " + this.replaceLog);
        printWriter.println("  logDuration ................. " + this.logDuration);
        printWriter.println("  timeout ..................... " + this.timeout);
        if (this.addStyleSheet != null) {
            printWriter.println("  addStyleSheet ............... " + this.addStyleSheet.toString());
        }
        if (this.manInTheMiddle != null) {
            printWriter.print(this.manInTheMiddle.toString());
        }
        return stringWriter.toString();
    }

    private void setConfig(MonitorConfig monitorConfig) {
        this.comment = monitorConfig.getComment();
        this.documentURI = monitorConfig.getLocation();
        this.logURI = monitorConfig.getLogLocation();
        this.replaceLog = monitorConfig.getReplaceLog();
        this.logDuration = monitorConfig.getLogDuration();
        this.timeout = monitorConfig.getTimeout();
        this.manInTheMiddle = monitorConfig.getManInTheMiddle();
        this.addStyleSheet = monitorConfig.getAddStyleSheet();
        this.verbose = monitorConfig.getVerboseOption();
    }

    private void verifyConfig() throws WSIException {
        if (this.manInTheMiddle == null || this.manInTheMiddle.getRedirectList() == null || this.manInTheMiddle.getRedirectList().size() == 0) {
            throw new IllegalArgumentException(this.getMessage("config05", "Monitor config file did not contain any redirect statements."));
        }
        if (this.logURI == null) {
            throw new IllegalArgumentException(this.getMessage("config06", "Monitor config file did not contain the log file URI."));
        }
    }

    public void parseArgs(String[] stringArray) throws WSIException {
        int n;
        MonitorConfigReaderImpl monitorConfigReaderImpl = new MonitorConfigReaderImpl();
        MonitorConfig monitorConfig = null;
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(this.getMessage("usage01", "Usage: Monitor -config <configFilename>"));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase("-config") && !stringArray[n].equals("-c")) continue;
            monitorConfig = monitorConfigReaderImpl.readMonitorConfig(stringArray[++n]);
        }
        if (monitorConfig == null) {
            monitorConfig = new MonitorConfigImpl();
            monitorConfig.init(this.messageList);
        }
        for (n = 0; n < stringArray.length; ++n) {
            DocumentElement documentElement;
            if (stringArray[n].equalsIgnoreCase("-config") || stringArray[n].equals("-c")) {
                ++n;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-comment") || stringArray[n].equals("-C")) {
                documentElement = new CommentImpl();
                documentElement.setText(stringArray[++n]);
                monitorConfig.setComment((Comment)documentElement);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-logFile") || stringArray[n].equals("-l")) {
                monitorConfig.setLogLocation(stringArray[++n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-replace") || stringArray[n].equals("-r")) {
                monitorConfig.setReplaceLog(Boolean.valueOf(stringArray[++n]));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-logDuration") || stringArray[n].equals("-d")) {
                monitorConfig.setLogDuration(Integer.valueOf(stringArray[++n]));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-timeout") || stringArray[n].equals("-t")) {
                monitorConfig.setTimeout(Integer.valueOf(stringArray[++n]));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-manInTheMiddle") || stringArray[n].equals("-m")) {
                documentElement = null;
                ++n;
                documentElement = monitorConfig.getManInTheMiddle();
                if (documentElement == null) {
                    documentElement = new ManInTheMiddleImpl();
                }
                RedirectImpl redirectImpl = new RedirectImpl();
                redirectImpl.setListenPort(Integer.valueOf(stringArray[n++]));
                redirectImpl.setHost(stringArray[n++]);
                redirectImpl.setMaxConnections(Integer.valueOf(stringArray[n++]));
                redirectImpl.setReadTimeoutSeconds(Integer.valueOf(stringArray[n++]));
                documentElement.addRedirect(redirectImpl);
                monitorConfig.setManInTheMiddle((ManInTheMiddle)documentElement);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-verbose") || stringArray[n].equals("-v")) {
                ++n;
                monitorConfig.setVerboseOption(true);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-GUI")) continue;
            throw new IllegalArgumentException(this.getMessage("config01", stringArray[n], "The specified option is not supported."));
        }
        if (monitorConfig.getAddStyleSheet() == null) {
            AddStyleSheetImpl addStyleSheetImpl = new AddStyleSheetImpl();
            addStyleSheetImpl.setHref("../common/xsl/log.xsl");
            addStyleSheetImpl.setType("text/xsl");
            addStyleSheetImpl.setComment(true);
            monitorConfig.setAddStyleSheet(addStyleSheetImpl);
        }
        this.setConfig(monitorConfig);
        this.verifyConfig();
    }

    private String getMessage(String string, String string2) {
        return this.getMessage(string, null, string2);
    }

    private String getMessage(String string, String string2, String string3) {
        String string4 = string3;
        string4 = this.messageList != null ? this.messageList.getMessage(string, string2, string3) : string4 + " " + string2 + ".";
        return string4;
    }
}

