/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.impl;

import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.wsi.WSIException;
import org.wsi.test.profile.EntryTypeList;
import org.wsi.test.profile.ProfileArtifact;
import org.wsi.test.profile.ProfileAssertions;
import org.wsi.test.profile.ProfileAssertionsReader;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.impl.EntryTypeListImpl;
import org.wsi.test.profile.impl.ProfileAssertionsImpl;
import org.wsi.test.profile.impl.TestAssertionImpl;
import org.wsi.test.util.ArtifactType;
import org.wsi.util.Utils;
import org.wsi.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileAssertionsReaderImpl
implements ProfileAssertionsReader {
    protected ProfileAssertions profileAssertions;
    protected TreeMap artifactList = new TreeMap();

    public ProfileAssertions readProfileAssertions(String string) throws WSIException {
        return this.readProfileAssertions(new InputSource(string));
    }

    public ProfileAssertions readProfileAssertions(Reader reader) throws WSIException {
        return this.readProfileAssertions(new InputSource(reader));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProfileAssertions readProfileAssertions(InputSource inputSource) throws WSIException {
        LinkedList linkedList;
        Object object;
        this.profileAssertions = new ProfileAssertionsImpl();
        this.artifactList = new TreeMap();
        try {
            try {
                object = XMLUtils.getXMLReader();
                object.setContentHandler(new ProfileAssertionsHandler());
                object.parse(inputSource);
            }
            catch (Exception exception) {
                throw new WSIException("Could not read and parse profile definition.", exception);
            }
            linkedList = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Utils.isValidProfileTADVersion(this.profileAssertions)) {
                throw new WSIException("\nVersion " + this.profileAssertions.getTADVersion() + " of the \"" + this.profileAssertions.getTADName() + "\"\n" + "document is not compatible with this version of" + "\n" + "the test tools.");
            }
            throw throwable;
        }
        if (!Utils.isValidProfileTADVersion(this.profileAssertions)) {
            throw new WSIException("\nVersion " + this.profileAssertions.getTADVersion() + " of the \"" + this.profileAssertions.getTADName() + "\"\n" + "document is not compatible with this version of" + "\n" + "the test tools.");
        }
        object = this.artifactList.keySet().iterator();
        while (true) {
            if (!object.hasNext()) {
                this.profileAssertions.setArtifactList(this.artifactList);
                return this.profileAssertions;
            }
            ProfileArtifact profileArtifact = (ProfileArtifact)this.artifactList.get(object.next());
            linkedList = new LinkedList();
            Iterator iterator = profileArtifact.getTestAssertionList().iterator();
            while (iterator.hasNext()) {
                this.sortTestAssertions(profileArtifact, (TestAssertion)iterator.next(), linkedList);
            }
            profileArtifact.getTestAssertionList().clear();
            profileArtifact.getTestAssertionList().addAll(linkedList);
        }
    }

    public String getLocation() {
        return null;
    }

    public void setLocation(String string) {
    }

    private void sortTestAssertions(ProfileArtifact profileArtifact, TestAssertion testAssertion, List list) {
        if (testAssertion == null || list.contains(testAssertion)) {
            return;
        }
        if (testAssertion.getPrereqIdList().isEmpty()) {
            list.add(testAssertion);
            return;
        }
        Iterator iterator = testAssertion.getPrereqIdList().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.sortTestAssertions(profileArtifact, profileArtifact.getTestAssertion(string), list);
        }
        list.add(testAssertion);
    }

    class ProfileAssertionsHandler
    extends DefaultHandler {
        private ProfileArtifact artifact;
        private String id;
        private StringBuffer context;
        private StringBuffer assertionDescription;
        private StringBuffer failureMessage;
        private StringBuffer failureDetailDescription;
        private StringBuffer detailDescription;
        private StringBuffer testAssertionId;
        private TreeMap assertions;
        private String currentElement;
        private TestAssertion testAssertion;
        private StringBuffer logInput;
        private StringBuffer wsdlInput;
        private StringBuffer uddiInput;
        private EntryTypeList entryTypeList;

        ProfileAssertionsHandler() {
            this.artifact = ProfileAssertionsReaderImpl.this.profileAssertions.createArtifact();
            this.context = null;
            this.assertionDescription = null;
            this.failureMessage = null;
            this.failureDetailDescription = null;
            this.detailDescription = null;
            this.testAssertionId = null;
            this.assertions = new TreeMap();
            this.currentElement = null;
            this.testAssertion = null;
            this.logInput = null;
            this.wsdlInput = null;
            this.uddiInput = null;
            this.entryTypeList = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string != null && (string.equals("http://www.ws-i.org/testing/2003/03/assertions/") || string.equals("http://www.ws-i.org/testing/2004/07/assertions/"))) {
                this.currentElement = string2;
                if (string2.equals("artifact")) {
                    this.artifact = ProfileAssertionsReaderImpl.this.profileAssertions.createArtifact();
                    this.artifact.setType(ArtifactType.newArtifactType(attributes.getValue("type")));
                    ProfileAssertionsReaderImpl.this.artifactList.put(this.artifact.getType().getTypeName(), this.artifact);
                } else if (string2.equals("testAssertion")) {
                    this.testAssertion = new TestAssertionImpl();
                    this.testAssertion.setId(attributes.getValue("", "id"));
                    this.testAssertion.setType(attributes.getValue("", "type"));
                    this.testAssertion.setEntryTypeName(attributes.getValue("", "entryType"));
                    this.testAssertion.setEnabled(Boolean.valueOf(attributes.getValue("", "enabled")));
                    this.artifact.addTestAssertion(this.testAssertion);
                } else if (string2.equals("context")) {
                    this.context = new StringBuffer();
                } else if (string2.equals("assertionDescription")) {
                    this.assertionDescription = new StringBuffer();
                } else if (string2.equals("failureMessage")) {
                    this.failureMessage = new StringBuffer();
                } else if (string2.equals("failureDetailDescription")) {
                    this.failureDetailDescription = new StringBuffer();
                } else if (string2.equals("detailDescription")) {
                    this.detailDescription = new StringBuffer();
                } else if (string2.equals("testAssertionID")) {
                    this.testAssertionId = new StringBuffer();
                } else if (string2.equals("additionalEntryTypeList")) {
                    this.entryTypeList = new EntryTypeListImpl();
                } else if (string2.equals("messageInput")) {
                    this.logInput = new StringBuffer();
                } else if (string2.equals("wsdlInput")) {
                    this.wsdlInput = new StringBuffer();
                } else if (string2.equals("profileAssertions")) {
                    ProfileAssertionsReaderImpl.this.profileAssertions.setTADName(attributes.getValue("", "name"));
                    ProfileAssertionsReaderImpl.this.profileAssertions.setTADVersion(attributes.getValue("", "version"));
                }
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string != null && (string.equals("http://www.ws-i.org/testing/2003/03/assertions/") || string.equals("http://www.ws-i.org/testing/2004/07/assertions/"))) {
                if (string2.equals("context")) {
                    this.testAssertion.setContext(this.context.toString());
                    this.context = null;
                } else if (string2.equals("assertionDescription")) {
                    this.testAssertion.setAssertionDescription(this.assertionDescription.toString());
                    this.assertionDescription = null;
                } else if (string2.equals("failureMessage")) {
                    this.testAssertion.setFailureMessage(this.failureMessage.toString());
                    this.failureMessage = null;
                } else if (string2.equals("failureDetailDescription")) {
                    this.testAssertion.setFailureDetailDescription(this.failureDetailDescription.toString());
                    this.failureDetailDescription = null;
                } else if (string2.equals("detailDescription")) {
                    this.testAssertion.setDetailDescription(this.detailDescription.toString());
                    this.detailDescription = null;
                } else if (string2.equals("testAssertionID")) {
                    this.testAssertion.addPrereqId(this.testAssertionId.toString());
                    this.testAssertionId = null;
                } else if (string2.equals("additionalEntryTypeList")) {
                    this.testAssertion.setAdditionalEntryTypeList(this.entryTypeList);
                    this.entryTypeList = null;
                } else if (string2.equals("messageInput")) {
                    this.entryTypeList.setLogInput(this.logInput.toString());
                    this.logInput = null;
                } else if (string2.equals("wsdlInput")) {
                    this.entryTypeList.setWSDLInput(this.wsdlInput.toString());
                    this.wsdlInput = null;
                } else if (string2.equals("profileAssertions")) {
                    // empty if block
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.context != null && this.currentElement.equals("context")) {
                this.context.append(cArray, n, n2);
            } else if (this.assertionDescription != null && this.currentElement.equals("assertionDescription")) {
                this.assertionDescription.append(cArray, n, n2);
            } else if (this.failureMessage != null && this.currentElement.equals("failureMessage")) {
                this.failureMessage.append(cArray, n, n2);
            } else if (this.failureDetailDescription != null && this.currentElement.equals("failureDetailDescription")) {
                this.failureDetailDescription.append(cArray, n, n2);
            } else if (this.detailDescription != null && this.currentElement.equals("detailDescription")) {
                this.detailDescription.append(cArray, n, n2);
            } else if (this.testAssertionId != null && this.currentElement.equals("testAssertionID")) {
                this.testAssertionId.append(cArray, n, n2);
            } else if (this.logInput != null && this.currentElement.equals("messageInput")) {
                this.logInput.append(cArray, n, n2);
            } else if (this.wsdlInput != null && this.currentElement.equals("wsdlInput")) {
                this.wsdlInput.append(cArray, n, n2);
            }
        }
    }
}

