/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.MIMEUtils;

public class AP1928
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public AP1928(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Message message;
            List list;
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), document);
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if ("request".equals(entryContext.getEntry().getEntryType())) {
                list = bindingOperation.getBindingInput() == null ? null : bindingOperation.getBindingInput().getExtensibilityElements();
                message = bindingOperation.getOperation().getInput() == null ? null : bindingOperation.getOperation().getInput().getMessage();
            } else {
                list = bindingOperation.getBindingOutput() == null ? null : bindingOperation.getBindingOutput().getExtensibilityElements();
                Message message2 = message = bindingOperation.getOperation().getOutput() == null ? null : bindingOperation.getOperation().getOutput().getMessage();
            }
            if (list == null || list.size() < 1) {
                throw new AssertionNotApplicableException();
            }
            List list2 = this.getSwaRefs((ExtensibilityElement)list.get(0), message);
            if (list2.isEmpty()) {
                throw new AssertionNotApplicableException();
            }
            for (int i = 0; i < list2.size(); ++i) {
                QName qName = (QName)list2.get(i);
                NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart());
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    String string;
                    Node node = nodeList.item(j);
                    String string2 = string = node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue();
                    if (string == null) {
                        throw new AssertionFailException("The element " + node.getNodeName() + " of the ref:swaRef schema type is specified, but its vaule" + " is invalid.");
                    }
                    if (!string.startsWith("cid:")) {
                        throw new AssertionFailException("The URI " + string + " of the ref:swaRef schema type must use the cid: prefix.");
                    }
                    boolean bl = false;
                    Iterator iterator = mimeParts.getParts().iterator();
                    while (iterator.hasNext()) {
                        MimePart mimePart = (MimePart)iterator.next();
                        String string3 = MIMEUtils.getMimeHeaderAttribute(mimePart.getHeaders(), "Content-ID");
                        if (string3 == null || !string3.equals('<' + string.substring(4) + '>')) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    throw new AssertionFailException("The SOAP message does not contain a MIME part with the <" + string.substring(4) + "> Content-ID.");
                }
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private List getSwaRefs(ExtensibilityElement extensibilityElement, Message message) {
        List list;
        ArrayList<QName> arrayList = new ArrayList<QName>();
        if (extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_MULTIPART) && (list = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts()).size() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ExtensibilityElement extensibilityElement2;
            int n;
            List list2 = ((MIMEPart)list.get(0)).getExtensibilityElements();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (n = 0; n < list2.size(); ++n) {
                Object object6;
                extensibilityElement2 = (ExtensibilityElement)list2.get(n);
                if (extensibilityElement2.getElementType().equals(WSITag.WSDL_SOAP_BODY) && message != null) {
                    object5 = ((SOAPBody)extensibilityElement2).getParts();
                    object6 = message.getParts().values().iterator();
                    while (object6.hasNext()) {
                        object4 = (Part)object6.next();
                        if (object5 != null && !object5.contains(object4.getName())) continue;
                        arrayList2.add(object4);
                    }
                    continue;
                }
                if (!extensibilityElement2.getElementType().equals(WSITag.WSDL_SOAP_HEADER)) continue;
                if (extensibilityElement2 instanceof SOAPHeader) {
                    object4 = (SOAPHeader)extensibilityElement2;
                    object5 = object4.getMessage();
                    object6 = object4.getPart();
                } else {
                    object4 = ((UnknownExtensibilityElement)extensibilityElement2).getElement();
                    object3 = object4.getAttribute("message");
                    int n2 = ((String)object3).indexOf(":");
                    object2 = null;
                    Object object7 = object = n2 > -1 ? ((String)object3).substring(n2 + 1) : object3;
                    if (n2 > -1) {
                        object2 = this.validator.getWSDLDocument().getDefinitions().getNamespace(((String)object3).substring(0, n2));
                    }
                    object5 = new QName((String)object2, (String)object);
                    object6 = object4.getAttribute("part");
                }
                object4 = this.validator.getWSDLDocument().getDefinitions().getMessage((QName)object5);
                if (object4 == null || (object3 = object4.getPart((String)object6)) == null) continue;
                arrayList2.add(object3);
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                int n3;
                extensibilityElement2 = (Part)arrayList2.get(n);
                object5 = extensibilityElement2.getTypeName();
                if (object5 != null) {
                    n3 = 3;
                } else {
                    object5 = extensibilityElement2.getElementName();
                    if (object5 == null) continue;
                    n3 = 2;
                }
                object4 = this.validator.getWSDLDocument().getSchemas();
                object3 = object4.values().iterator();
                while (object3.hasNext()) {
                    XSModel xSModel = (XSModel)object3.next();
                    object2 = null;
                    if (n3 == 2) {
                        object = xSModel.getElementDeclaration(((QName)object5).getLocalPart(), ((QName)object5).getNamespaceURI());
                        if (object != null && "http://ws-i.org/profiles/basic/1.1/xsd".equals((object2 = object.getTypeDefinition()).getName()) && "swaRef".equals(object2.getNamespace())) {
                            arrayList.add(new QName(object.getNamespace(), object.getName()));
                        }
                    } else {
                        object2 = xSModel.getTypeDefinition(((QName)object5).getLocalPart(), ((QName)object5).getNamespaceURI());
                    }
                    arrayList.addAll(this.collectSwaRefs((XSTypeDefinition)object2));
                }
            }
        }
        return arrayList;
    }

    private List collectSwaRefs(XSTypeDefinition xSTypeDefinition) {
        XSComplexTypeDefinition xSComplexTypeDefinition;
        ArrayList arrayList = new ArrayList();
        if (xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 15 && (xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition).getParticle() != null) {
            arrayList.addAll(this.collectSwaRefs(xSComplexTypeDefinition.getParticle().getTerm()));
        }
        return arrayList;
    }

    private List collectSwaRefs(XSTerm xSTerm) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        if (xSTerm.getType() == 2) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
            XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
            if ("http://ws-i.org/profiles/basic/1.1/xsd".equals(xSTypeDefinition.getNamespace()) && "swaRef".equals(xSTypeDefinition.getName())) {
                arrayList.add(new QName(xSElementDeclaration.getNamespace(), xSElementDeclaration.getName()));
            } else {
                arrayList.addAll(this.collectSwaRefs(xSTypeDefinition));
            }
        } else if (xSTerm.getType() == 7) {
            XSObjectList xSObjectList = ((XSModelGroup)xSTerm).getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                arrayList.addAll(this.collectSwaRefs(((XSParticle)xSObjectList.item(i)).getTerm()));
            }
        }
        return arrayList;
    }
}

