/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1012
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1012(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document document = entryContext.getRequestDocument();
            if (document == null) {
                throw new AssertionNotApplicableException();
            }
            Element element = document.getDocumentElement();
            if (!element.getLocalName().equals("Envelope") || element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                throw new AssertionNotApplicableException();
            }
            Document document2 = XMLUtils.parseXML(entryContext.getResponse().getMessage());
            NodeList nodeList = document2.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new AssertionFailException("--- REQUEST:\n" + entryContext.getRequest().getMessage() + "\n--- RESPONSE:\n" + entryContext.getResponse().getMessage());
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

