/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1214
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1214(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            Element element = null;
            if (this.validator.isFault(document) || (element = this.validator.getSoapBodyChild(document)) == null) {
                throw new AssertionNotApplicableException();
            }
            QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
            BindingOperation[] bindingOperationArray = this.validator.getMatchingBindingOps("rpc", this.validator.analyzerContext.getCandidateInfo().getBindings());
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), qName, bindingOperationArray);
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (!this.validator.isLiteral(list)) {
                throw new AssertionNotApplicableException();
            }
            List list2 = null;
            SOAPBody sOAPBody = this.validator.getSOAPBody(list);
            if (sOAPBody != null) {
                list2 = sOAPBody.getParts();
            }
            if (list2 != null && list2.isEmpty() && !XMLUtils.getChildElements(element).isEmpty()) {
                throw new AssertionFailException("wsdl:operation name is " + bindingOperation.getName());
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

