/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.log.MessageEntry;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1302
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1302(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String string = null;
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            MessageEntry messageEntry = entryContext.getResponse();
            if (messageEntry != null) {
                string = messageEntry.getMessage();
                Document document = XMLUtils.parseXML(string);
                NodeList nodeList = document.getElementsByTagName("faultcode");
                if (nodeList.getLength() <= 0) {
                    this.result = "notApplicable";
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node == null) {
                        this.result = "notApplicable";
                        continue;
                    }
                    if (node.getNodeType() == 1) {
                        if (this.isValidFaultCode((Element)node)) {
                            this.result = "passed";
                            continue;
                        }
                        this.result = "warning";
                        this.failureDetail = this.validator.createFailureDetail(string, entryContext);
                        continue;
                    }
                    this.result = "notApplicable";
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    public boolean isValidFaultCode(Element element) {
        if (element == null) {
            return true;
        }
        String string = element.getFirstChild().getNodeValue().trim();
        if (string == null) {
            return false;
        }
        String string2 = element.getParentNode().getPrefix();
        String string3 = null;
        String string4 = string;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1, string.length());
        }
        if (string2 != null && string3 != null) {
            if (string3.equals(string2)) {
                return string4.equals("MustUnderstand") || string4.equals("VersionMismatch") || string4.equals("Client") || string4.equals("Server");
            }
            return true;
        }
        return string4.equals("MustUnderstand") || string4.equals("VersionMismatch") || string4.equals("Client") || string4.equals("Server") || string4.startsWith("MustUnderstand.") || string4.startsWith("VersionMismatch.") || string4.startsWith("Client.") || string4.startsWith("Server.");
    }
}

