/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP4100
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP4100(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                throw new AssertionNotApplicableException();
            }
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            if (nodeList2 == null || nodeList2.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object;
                if (nodeList2.item(i).hasAttributes() && (object = nodeList2.item(i).getAttributes().getNamedItem(element.getPrefix() + ":" + "mustUnderstand")) != null && object.getNodeValue().equals("1")) {
                    throw new AssertionPassException();
                }
                object = nodeList2.item(i).getLocalName();
                if (object == null) continue;
                boolean bl = false;
                Binding[] bindingArray = this.validator.getWSDLDocument().getBindings();
                for (int j = 0; j < bindingArray.length; ++j) {
                    List list = bindingArray[j].getBindingOperations();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && !bl) {
                        BindingInput bindingInput;
                        BindingOperation bindingOperation = (BindingOperation)iterator.next();
                        if (entryContext.getMessageEntry().getType().equals("request")) {
                            bindingInput = bindingOperation.getBindingInput();
                            if (bindingInput == null) continue;
                            bl = this.blockNameExists(bindingInput.getExtensibilityElements(), (String)object);
                            continue;
                        }
                        bindingInput = bindingOperation.getBindingOutput();
                        if (bindingInput == null) continue;
                        bl = this.blockNameExists(bindingInput.getExtensibilityElements(), (String)object);
                    }
                }
                if (bl) continue;
                throw new AssertionPassException();
            }
            this.result = "notApplicable";
        }
        catch (AssertionPassException assertionPassException) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean blockNameExists(List list, String string) {
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SOAPHeader sOAPHeader;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            String string2 = extensibilityElement.getElementType().getLocalPart();
            if (!string2.equals("header") || !(sOAPHeader = (SOAPHeader)extensibilityElement).getPart().equals(string)) continue;
            return true;
        }
        return false;
    }
}

