/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class SSBP9704
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public SSBP9704(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                throw new AssertionNotApplicableException();
            }
            Element element = document.getDocumentElement();
            if (!element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || !element.getLocalName().equals("Envelope")) {
                throw new AssertionNotApplicableException();
            }
            String string = this.getIncorrectElementName(element);
            if (string != null) {
                throw new AssertionFailException("The name of an element containing such namespace declaration is \"" + string + "\".");
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getIncorrectElementName(Element element) {
        String string = element.getAttributeNS("http://www.w3.org/2000/xmlns/", "xml");
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return element.getNodeName();
        }
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            String string2 = this.getIncorrectElementName(element2);
            if (string2 != null) {
                return string2;
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
        return null;
    }
}

