/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.MIMEUtils;
import org.wsi.util.Utils;

public class AP1915
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1915(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        block14: {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                this.result = "notApplicable";
            } else {
                MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
                MimePart mimePart = mimeParts.getRootPart();
                if (mimePart == null) {
                    this.result = "notApplicable";
                } else {
                    String string = null;
                    String string2 = MIMEUtils.getMimeHeaderSubAttribute(mimePart.getHeaders(), "Content-Type", "charset");
                    try {
                        if (string2 != null && (string2.equalsIgnoreCase("utf-8") || string2.equalsIgnoreCase("utf-16"))) {
                            int n = 0;
                            n = entryContext.getMessageEntry().getBOM();
                            if (n != 0) {
                                if (n == 0xEFBBBF && !string2.equalsIgnoreCase("utf-8") || n == 65534 && !string2.equalsIgnoreCase("utf-16") || n == 65279 && !string2.equalsIgnoreCase("utf-16")) {
                                    throw new AssertionFailException("The BOM (" + n + ") and charset value (" + string2 + ")do not match.");
                                }
                            } else {
                                string = Utils.getXMLEncoding(mimePart.getContent());
                                if (string != null && !string.equals("")) {
                                    if (!string.equalsIgnoreCase(string2)) {
                                        throw new AssertionFailException("The XML declaration encoding (" + string + ") and charset value (" + string2 + ") do not match.");
                                    }
                                } else if (!string2.equalsIgnoreCase("utf-8")) {
                                    throw new AssertionFailException("The no BOM attribute and no XML declaration, and the charset value is (" + string2 + ")");
                                }
                            }
                            break block14;
                        }
                        throw new AssertionFailException("Either the Content-Type header is not present in the Root Part or a charset value is invalid.");
                    }
                    catch (AssertionFailException assertionFailException) {
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
                    }
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

