/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.Utils;

public class BP1101
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1101(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (entryContext.getMessageEntry().getMessage() == null || "".equals(entryContext.getMessageEntry().getMessage())) {
            String string = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
            if (!"200".equals(string) && !"202".equals(string)) {
                if (string.startsWith("4")) {
                    this.result = "notApplicable";
                } else {
                    this.result = "warning";
                    this.failureDetail = this.validator.createFailureDetail("\nResponse message:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "Message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

