/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.StringTokenizer;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.HTTPUtils;

public class BP4105
extends AssertionProcess {
    private static final String GZIP_VALUE = "gzip";
    private static final String COMPRESS_VALUE = "compress";
    private static final String DEFLATE_VALUE = "deflate";
    private final BaseMessageValidator validator;

    public BP4105(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String string = (String)HTTPUtils.getHttpHeaderTokens(entryContext.getMessageEntry().getHTTPHeaders(), ":").get("Content-Encoding");
        if (string != null) {
            string = string.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals(GZIP_VALUE) || string2.equals(COMPRESS_VALUE) || string2.equals(DEFLATE_VALUE)) continue;
                this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
                break;
            }
        }
        if (this.failureDetail == null) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

