/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import java.util.Vector;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionResultException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.UDDIUtils;

public class WSI3006
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3006(UDDIValidatorImpl uDDIValidatorImpl) {
        super(uDDIValidatorImpl);
        this.validator = uDDIValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        this.failureDetailMessage = null;
        KeyedReference keyedReference = null;
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        try {
            keyedReference = this.conformanceClaimMade(tModel);
            if (keyedReference == null) {
                throw new AssertionResultException("notApplicable");
            }
            if (!keyedReference.getKeyValue().equals("http://ws-i.org/profiles/basic/1.0")) {
                throw new AssertionResultException("failed", "The tModel key is: [" + tModel.getTModelKey() + "].\nThe categoryBag is: [" + tModel.getCategoryBag() + "].");
            }
        }
        catch (AssertionResultException assertionResultException) {
            this.result = assertionResultException.getMessage();
            this.failureDetailMessage = assertionResultException.getDetailMessage();
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private KeyedReference checkCategoryBag(UDDIProxy uDDIProxy, CategoryBag categoryBag) {
        String string = null;
        try {
            string = UDDIUtils.getWSIConformanceTModelKey(uDDIProxy);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        boolean bl = true;
        KeyedReference keyedReference = null;
        if (categoryBag != null) {
            Vector vector = categoryBag.getKeyedReferenceVector();
            for (int i = 0; i < vector.size() && bl; ++i) {
                KeyedReference keyedReference2 = (KeyedReference)vector.get(i);
                if (!keyedReference2.getTModelKey().equalsIgnoreCase(string)) continue;
                bl = true;
                keyedReference = keyedReference2;
            }
        }
        return keyedReference;
    }

    private KeyedReference conformanceClaimMade(TModel tModel) throws WSIException {
        if (tModel == null) {
            throw new IllegalArgumentException("tModel cannot be null");
        }
        CategoryBag categoryBag = tModel.getCategoryBag();
        return this.checkCategoryBag(this.validator.uddiProxy, categoryBag);
    }
}

