/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import java.util.Vector;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.UDDIUtils;

public class WSI3021
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3021(UDDIValidatorImpl uDDIValidatorImpl) {
        super(uDDIValidatorImpl);
        this.validator = uDDIValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        TModel tModel = UDDIUtils.getTModelByKey(this.validator.uddiProxy, UDDIUtils.getWSIConformanceTModelKey(this.validator.uddiProxy));
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
        } else {
            boolean bl = tModel.getOverviewDoc() != null && "http://ws-i.org/schemas/conformanceClaim/".equals(tModel.getOverviewDoc().getOverviewURLString());
            boolean bl2 = this.checkCategoryBag(tModel.getCategoryBag());
            if (bl && bl2) {
                this.result = "passed";
            } else {
                this.result = "failed";
                this.failureDetailMessage = this.validator.uddiReference.getInquiryURL();
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private boolean checkCategoryBag(CategoryBag categoryBag) {
        boolean bl = false;
        if (categoryBag != null) {
            Vector vector = categoryBag.getKeyedReferenceVector();
            for (int i = 0; i < vector.size() && !bl; ++i) {
                KeyedReference keyedReference = (KeyedReference)vector.get(i);
                bl = "uddi-org:types:categorization".equals(keyedReference.getKeyName()) && "categorization".equals(keyedReference.getKeyValue()) && "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4".equals(keyedReference.getTModelKey());
            }
        }
        return bl;
    }
}

