/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.Utils;
import org.wsi.xml.XMLUtils;

public class BP2018
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public BP2018(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    private boolean isExtensibilityElement(Element element) {
        boolean bl = true;
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_BINDING);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_DEFINITIONS);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_DOCUMENTATION);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_FAULT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_IMPORT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_INPUT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_MESSAGE);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_OPERATION);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_OUTPUT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_PART);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_PORT);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_PORTTYPE);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_SERVICE);
        bl = bl && !XMLUtils.equals(element, WSITag.WSDL_TYPES);
        return bl;
    }

    private void createFailed(String string, Element element, EntryContext entryContext) {
        QName qName = element != null ? new QName(element.getNamespaceURI(), element.getLocalName()) : new QName("definition");
        this.result = "failed";
        this.failureDetail = this.validator.createFailureDetail(string, entryContext);
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        try {
            Document document = this.validator.parseXMLDocumentURL(definition.getDocumentBaseURI(), null);
            Element element = document.getDocumentElement();
            Element element2 = XMLUtils.findChildElement(element, WSITag.WSDL_TYPES);
            if (element2 != null) {
                boolean bl;
                Element element3 = XMLUtils.findPreviousSibling(element2);
                while (this.isExtensibilityElement(element3) && element3 != null) {
                    if (element3 == null) continue;
                    element3 = XMLUtils.findPreviousSibling(element3);
                }
                boolean bl2 = XMLUtils.findChildElement(element, WSITag.WSDL_DOCUMENTATION) != null;
                boolean bl3 = bl = XMLUtils.findChildElement(element, WSITag.WSDL_IMPORT) != null;
                if (bl) {
                    if (!XMLUtils.equals(element3, WSITag.WSDL_IMPORT)) {
                        this.createFailed("Types element can not follow import element.", element3, entryContext);
                        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
                    }
                    element3 = XMLUtils.findPreviousSibling(element3);
                }
                while (this.isExtensibilityElement(element3) && element3 != null) {
                    if (element3 == null) continue;
                    element3 = XMLUtils.findPreviousSibling(element3);
                }
                if (bl2) {
                    if (!XMLUtils.equals(element3, WSITag.WSDL_DOCUMENTATION)) {
                        this.createFailed("Types element must follow only a documentation element.", element3, entryContext);
                        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
                    }
                    element3 = XMLUtils.findPreviousSibling(element3);
                }
                if (!bl && !bl2 && element3 != null) {
                    this.createFailed("Types element must follow only a documentation element.", element3, entryContext);
                }
                if (bl && bl2 && element3 != null && !XMLUtils.equals(element3, WSITag.WSDL_DEFINITIONS) && element3.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
                    this.createFailed("Types element must not follow the " + element3.getTagName() + " element.", element3, entryContext);
                }
            }
        }
        catch (Throwable throwable) {
            this.result = "notApplicable";
            this.failureDetail = this.validator.createFailureDetail("An error occurred while processing the document at " + definition.getDocumentBaseURI() + ".\n\n" + Utils.getExceptionDetails(throwable), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

