/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.HashMap;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2113
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2113(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Definition definition = (Definition)wSDLTraversalContext.getParameter("definition");
        Message message = definition.getMessage(sOAPHeader.getMessage());
        if (message != null) {
            this.checkPart(message.getPart(sOAPHeader.getPart()), wSDLTraversalContext.getBinding());
        }
    }

    public void visit(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Definition definition = (Definition)wSDLTraversalContext.getParameter("definition");
        Message message = definition.getMessage(sOAPHeaderFault.getMessage());
        if (message != null) {
            this.checkPart(message.getPart(sOAPHeaderFault.getPart()), wSDLTraversalContext.getBinding());
        }
    }

    public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Operation operation;
        String string = sOAPFault.getName();
        if (string == null) {
            string = wSDLTraversalContext.getBindingFault().getName();
        }
        if ((operation = wSDLTraversalContext.getBindingOperation().getOperation()) == null) {
            return;
        }
        Fault fault = operation.getFault(string);
        if (fault == null) {
            return;
        }
        Message message = fault.getMessage();
        if (message == null || message.getParts() == null || message.getParts().size() != 1) {
            return;
        }
        this.checkPart((Part)message.getOrderedParts(null).get(0), wSDLTraversalContext.getBinding());
    }

    private void checkPart(Part part, Binding binding) {
        if (part != null && part.getElementName() == null) {
            this.errors.add(binding.getQName(), part.getName());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitSOAPHeader(true);
        wSDLTraversal.visitSOAPHeaderFault(true);
        wSDLTraversal.visitSOAPFault(true);
        HashMap<String, Definition> hashMap = new HashMap<String, Definition>();
        Definition definition = entryContext.getWSDLDocument().getDefinitions();
        WSDLUtil.expandDefinition(definition);
        hashMap.put("definition", definition);
        wSDLTraversal.traverse((Binding)entryContext.getEntry().getEntryDetail(), hashMap);
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

