/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2114
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    public Map messages = new HashMap();

    public BP2114(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (message != null && !this.messages.containsKey(message) && message.getOrderedParts(null) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = message.getOrderedParts(null).iterator();
            while (iterator.hasNext()) {
                hashSet.add(((Part)iterator.next()).getName());
            }
            if (hashSet.size() > 0) {
                this.messages.put(message.getQName(), hashSet);
            }
        }
    }

    public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        wSDLTraversalContext.addParameter("style", string);
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPOperation.getStyle();
        if (string != null) {
            wSDLTraversalContext.addParameter("style", string);
        }
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Operation operation = wSDLTraversalContext.getBindingOperation().getOperation();
        if (operation == null) {
            return;
        }
        Message message = null;
        if (object instanceof BindingInput) {
            if (operation.getInput() == null) {
                return;
            }
            message = operation.getInput().getMessage();
        } else if (object instanceof BindingOutput) {
            if (operation.getOutput() == null) {
                return;
            }
            message = operation.getOutput().getMessage();
        }
        if (message == null) {
            return;
        }
        List list = WSDLUtil.getParts(operation, message, sOAPBody, null);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removePart(message.getQName(), ((Part)iterator.next()).getName());
        }
    }

    public void visit(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.removePart(sOAPHeader.getMessage(), sOAPHeader.getPart());
    }

    public void visit(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        QName qName = sOAPHeaderFault.getMessage();
        if (qName == null) {
            qName = wSDLTraversalContext.getSOAPHeader().getMessage();
        }
        this.removePart(qName, sOAPHeaderFault.getPart());
    }

    public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Operation operation;
        String string = sOAPFault.getName();
        if (string == null) {
            string = wSDLTraversalContext.getBindingFault().getName();
        }
        if ((operation = wSDLTraversalContext.getBindingOperation().getOperation()) == null) {
            return;
        }
        Fault fault = operation.getFault(string);
        if (fault == null || fault.getMessage() == null || fault.getMessage().getParts().size() != 1) {
            return;
        }
        Part part = (Part)fault.getMessage().getOrderedParts(null).get(0);
        this.removePart(fault.getMessage().getQName(), part.getName());
    }

    private void removePart(QName qName, String string) {
        Set set = (Set)this.messages.get(qName);
        if (set != null) {
            set.remove(string);
            if (set.size() == 0) {
                this.messages.remove(qName);
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "warning";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitMessage(true);
        wSDLTraversal.visitSOAPBinding(true);
        wSDLTraversal.visitSOAPBody(true);
        wSDLTraversal.visitSOAPHeader(true);
        wSDLTraversal.visitSOAPHeaderFault(true);
        wSDLTraversal.visitSOAPFault(true);
        wSDLTraversal.visitSOAPOperation(true);
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        wSDLTraversal.traverse(binding);
        if (this.messages.size() > 0) {
            this.errors.add(binding.getQName());
        }
        if (!this.errors.isEmpty()) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

