/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2117
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean rpcLiteralFound = false;
    private ErrorList errors = new ErrorList();

    public BP2117(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        wSDLTraversalContext.addParameter("style", string);
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if ("literal".equals(sOAPBody.getUse()) && ((String)wSDLTraversalContext.getParameter("style")).equals("rpc")) {
            this.rpcLiteralFound = true;
        }
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPOperation.getStyle();
        if (string == null) {
            string = (String)wSDLTraversalContext.getParameter("style");
        }
        if (!"rpc".equals(string)) {
            wSDLTraversalContext.cancelBindingOperationProcessing();
        }
    }

    public void visit(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.check(sOAPHeader.getUse(), sOAPHeader.getNamespaceURI(), wSDLTraversalContext);
    }

    public void visit(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.check(sOAPHeaderFault.getUse(), sOAPHeaderFault.getNamespaceURI(), wSDLTraversalContext);
    }

    public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.check(sOAPFault.getUse(), sOAPFault.getNamespaceURI(), wSDLTraversalContext);
    }

    private void check(String string, String string2, WSDLTraversalContext wSDLTraversalContext) {
        if ("literal".equals(string) && string2 != null) {
            this.errors.add(wSDLTraversalContext.getBinding().getQName());
            wSDLTraversalContext.cancelProcessing();
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitSOAPBinding(true);
        wSDLTraversal.visitSOAPBody(true);
        wSDLTraversal.visitSOAPHeader(true);
        wSDLTraversal.visitSOAPHeaderFault(true);
        wSDLTraversal.visitSOAPFault(true);
        wSDLTraversal.visitSOAPOperation(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.rpcLiteralFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

