/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2416
extends AssertionProcessVisitor {
    private final WSDLValidatorImpl validator;
    private static final String NS_LIST_KEY = "namespaces";

    public BP2416(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    private void checkNamespace(QName qName, WSDLTraversalContext wSDLTraversalContext) {
        List list;
        String string;
        if (qName != null && (string = qName.getNamespaceURI()) != null && !(list = (List)wSDLTraversalContext.getParameter(NS_LIST_KEY)).contains(string)) {
            this.result = "failed";
            this.failureDetailMessage = string;
            wSDLTraversalContext.cancelProcessing();
        }
    }

    public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Binding binding;
        if (port != null && (binding = port.getBinding()) != null) {
            this.checkNamespace(binding.getQName(), wSDLTraversalContext);
        }
    }

    public void visit(Binding binding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        PortType portType;
        if (binding != null && (portType = binding.getPortType()) != null) {
            this.checkNamespace(portType.getQName(), wSDLTraversalContext);
        }
    }

    public void visit(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (operation != null) {
            Output output;
            Input input = operation.getInput();
            if (input != null && input.getMessage() != null) {
                this.checkNamespace(input.getMessage().getQName(), wSDLTraversalContext);
            }
            if ((output = operation.getOutput()) != null && output.getMessage() != null) {
                this.checkNamespace(output.getMessage().getQName(), wSDLTraversalContext);
            }
            Map map = operation.getFaults();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                if (fault.getMessage() == null) continue;
                this.checkNamespace(fault.getMessage().getQName(), wSDLTraversalContext);
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        List list = this.validator.getWSDLTargetNamespaceList(definition);
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put(NS_LIST_KEY, list);
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitOperation(true);
        wSDLTraversal.visitBinding(true);
        wSDLTraversal.visitMessage(true);
        wSDLTraversal.visitPort(true);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse(definition, hashMap);
        if (this.result.equals("failed")) {
            this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

