/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class BP4200
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errorList = new ErrorList();

    public BP4200(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (!(object instanceof Types || extensibilityElement.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/") || extensibilityElement.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/"))) {
            this.errorList.add(extensibilityElement.getElementType());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitExtensibilityElement(true);
        wSDLTraversal.visitElement(true);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse(definition);
        try {
            Document document = XMLUtils.parseXMLDocument(definition.getDocumentBaseURI());
            if (document != null) {
                this.checkElement(document.getDocumentElement());
                if (this.errorList.isEmpty()) {
                    this.result = "notApplicable";
                } else {
                    this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription() + "\n\n" + this.errorList.toString(), entryContext);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void checkElement(Element element) {
        while (element != null) {
            String string = element.getNamespaceURI();
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string2 = attr.getNamespaceURI();
                    if (string2 == null || string2.equals("http://www.w3.org/2000/xmlns/") || string2.equals("http://schemas.xmlsoap.org/wsdl/") || string2.equals("http://schemas.xmlsoap.org/wsdl/soap/")) continue;
                    this.errorList.add("Extensibility attribute " + attr.getName() + "for the " + element.getNodeName() + " element is found.");
                }
            }
            if (!string.equals("http://www.w3.org/2001/XMLSchema")) {
                this.checkElement(XMLUtils.getFirstChild(element));
            }
            element = XMLUtils.getNextSibling(element);
        }
    }
}

