/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLTraversal;

public class SSBP2403
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public SSBP2403(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    private boolean isNonConformantBindingExtension(String string) {
        boolean bl = false;
        if (string != null && (string.equals("http://schemas.xmlsoap.org/wsdl/mime/") || string.equals("http://schemas.xmlsoap.org/wsdl/http/") || string.equals("http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/"))) {
            bl = true;
        }
        return bl;
    }

    public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (this.isNonConformantBindingExtension(extensibilityElement.getElementType().getNamespaceURI())) {
            this.errors.add(extensibilityElement.getElementType());
        } else if (extensibilityElement instanceof UnknownExtensibilityElement) {
            Element element = ((UnknownExtensibilityElement)extensibilityElement).getElement();
            XMLTraversalCheckingExtensions xMLTraversalCheckingExtensions = new XMLTraversalCheckingExtensions();
            xMLTraversalCheckingExtensions.visit(element);
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitElement(true);
        wSDLTraversal.visitExtensibilityElement(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private class XMLTraversalCheckingExtensions
    extends XMLTraversal {
        boolean nonConformantExtensionFound = false;

        private XMLTraversalCheckingExtensions() {
        }

        public boolean action(Node node) {
            return !this.nonConformantExtensionFound;
        }

        public void visit(Attr attr) {
            if (this.action(attr) && SSBP2403.this.isNonConformantBindingExtension(attr.getNamespaceURI())) {
                SSBP2403.this.errors.add(attr.getName());
                this.nonConformantExtensionFound = true;
            }
        }

        public void visit(Element element) {
            if (this.action(element)) {
                if (SSBP2403.this.isNonConformantBindingExtension(element.getNamespaceURI())) {
                    SSBP2403.this.errors.add(element.getNodeName());
                    this.nonConformantExtensionFound = true;
                } else {
                    this.visit(element.getAttributes());
                    for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                        this.doVisit(node);
                    }
                }
            }
        }
    }
}

