/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Service;
import javax.wsdl.Types;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class WSI2099
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean containsClaims = false;

    public WSI2099(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Element element, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (this.containsConformanceClaim(element)) {
            this.containsClaims = true;
            if (object instanceof BindingFault) {
                this.errors.add(WSITag.WSDL_FAULT, ((BindingFault)object).getName());
            } else if (object instanceof BindingInput) {
                this.errors.add(WSITag.WSDL_INPUT, ((BindingInput)object).getName());
            } else if (object instanceof BindingOperation) {
                this.errors.add(WSITag.WSDL_OPERATION, ((BindingOperation)object).getName());
            } else if (object instanceof BindingOutput) {
                this.errors.add(WSITag.WSDL_OUTPUT, ((BindingOutput)object).getName());
            } else if (object instanceof Definition) {
                this.errors.add(WSITag.WSDL_DEFINITIONS, ((Definition)object).getQName());
            } else if (object instanceof Service) {
                this.errors.add(WSITag.WSDL_SERVICE, ((Service)object).getQName());
            } else if (object instanceof Fault) {
                this.errors.add(WSITag.WSDL_FAULT, ((Fault)object).getName());
            } else if (object instanceof Output) {
                this.errors.add(WSITag.WSDL_INPUT, ((Output)object).getName());
            } else if (object instanceof Import) {
                this.errors.add(WSITag.WSDL_IMPORT, ((Import)object).getNamespaceURI());
            } else if (object instanceof Input) {
                this.errors.add(WSITag.WSDL_INPUT, ((Input)object).getName());
            } else if (object instanceof Part) {
                this.errors.add(WSITag.WSDL_PART, ((Part)object).getName());
            } else if (object instanceof Types) {
                this.errors.add(WSITag.WSDL_TYPES);
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitElement(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
            this.result = "failed";
        } else {
            this.result = !this.containsClaims ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsConformanceClaim(Element element) {
        if (element == null) {
            return false;
        }
        return (element = XMLUtils.findChildElement(element, WSITag.WSI_CLAIM)) != null;
    }
}

