/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class WSI2100
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean containsClaims = false;
    private ErrorList errors = new ErrorList();

    public WSI2100(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (port != null && !this.containsLegalClaim(port.getDocumentationElement())) {
            this.errors.add(WSITag.WSDL_PORT, port.getName());
        }
    }

    public void visit(Binding binding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (binding != null && !this.containsLegalClaim(binding.getDocumentationElement())) {
            this.errors.add(WSITag.WSDL_BINDING, binding.getQName());
        }
    }

    public void visit(PortType portType, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (portType != null && !this.containsLegalClaim(portType.getDocumentationElement())) {
            this.errors.add(WSITag.WSDL_PORTTYPE, portType.getQName());
        }
    }

    public void visit(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (operation != null && !this.containsLegalClaim(operation.getDocumentationElement())) {
            this.errors.add(WSITag.WSDL_OPERATION, operation.getName());
        }
    }

    public void visit(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (message != null && !this.containsLegalClaim(message.getDocumentationElement())) {
            this.errors.add(WSITag.WSDL_MESSAGE, message.getQName());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitOperation(true);
        wSDLTraversal.visitBinding(true);
        wSDLTraversal.visitMessage(true);
        wSDLTraversal.visitPort(true);
        wSDLTraversal.visitPortType(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
            this.result = "failed";
        } else {
            this.result = !this.containsClaims ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsLegalClaim(Element element) {
        if (element == null) {
            return true;
        }
        if ((element = XMLUtils.findChildElement(element, WSITag.WSI_CLAIM)) != null) {
            this.containsClaims = true;
        }
        while (element != null) {
            if (XMLUtils.getAttribute(element, WSITag.ATTR_CLAIM_CONFORMSTO) == null || XMLUtils.getAttribute(element, WSITag.ATTR_SOAP_MUSTUNDERSTAND) != null) {
                return false;
            }
            element = XMLUtils.findElement(element, WSITag.WSI_CLAIM);
        }
        return true;
    }
}

