/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.wsdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import org.wsi.wsdl.WSDLElementList;
import org.wsi.wsdl.WSDLReaderImpl;
import org.wsi.wsdl.xsd.InlineSchemaValidator;
import org.wsi.xml.XMLTags;

public class WSDLDocument {
    protected String fileName = null;
    protected Definition definitions = null;
    protected WSDLElementList wsdlElementList = null;
    private Map schemas = new HashMap();
    private List schemasValidationErrors = new ArrayList();
    static /* synthetic */ Class class$org$wsi$wsdl$WSDLDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDLDocument(String string) throws WSDLException {
        this.fileName = string;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((class$org$wsi$wsdl$WSDLDocument == null ? (class$org$wsi$wsdl$WSDLDocument = WSDLDocument.class$("org.wsi.wsdl.WSDLDocument")) : class$org$wsi$wsdl$WSDLDocument).getClassLoader());
            WSDLReaderImpl wSDLReaderImpl = new WSDLReaderImpl();
            wSDLReaderImpl.setFeature("javax.wsdl.verbose", false);
            wSDLReaderImpl.setFeature("javax.wsdl.importDocuments", true);
            this.definitions = wSDLReaderImpl.readWSDL(null, string);
            this.validateSchemas();
            this.wsdlElementList = wSDLReaderImpl.getElementList();
        }
        catch (ClassCastException classCastException) {
            this.wsdlElementList = null;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public WSDLDocument(String string, Definition definition) {
        this.fileName = string;
        this.definitions = definition;
        this.schemas.clear();
        this.schemasValidationErrors.clear();
    }

    public String getLocation() {
        return this.fileName;
    }

    public Definition getDefinitions() {
        return this.definitions;
    }

    public PortType[] getPortTypes() {
        return this.definitions.getPortTypes().values().toArray(new PortType[0]);
    }

    public Binding[] getBindings() {
        return this.definitions.getBindings().values().toArray(new Binding[0]);
    }

    public Service[] getServices() {
        return this.definitions.getServices().values().toArray(new Service[0]);
    }

    public String toString() {
        return this.definitions == null ? "WSDL definition element not found." : this.definitions.toString();
    }

    public WSDLElementList getElementList() {
        return this.wsdlElementList;
    }

    public Map getSchemas() {
        return this.schemas;
    }

    public List getSchemasValidationErrors() {
        return this.schemasValidationErrors;
    }

    private void validateSchemas() {
        this.schemas.clear();
        this.schemasValidationErrors.clear();
        if (this.definitions != null && this.definitions.getTypes() != null && this.definitions.getTypes().getExtensibilityElements() != null) {
            InlineSchemaValidator inlineSchemaValidator = new InlineSchemaValidator();
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(this.definitions.getTypes());
            arrayList.add(this.definitions);
            Iterator iterator = this.definitions.getTypes().getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!extensibilityElement.getElementType().equals(XMLTags.ELEM_XSD_SCHEMA)) continue;
                Map map = null;
                try {
                    map = inlineSchemaValidator.validate(extensibilityElement, arrayList, this.fileName);
                }
                catch (Exception exception) {
                    this.schemasValidationErrors.add(exception.getMessage());
                }
                if (map == null) continue;
                this.schemas.putAll(map);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            WSDLDocument wSDLDocument = new WSDLDocument(stringArray[0]);
            System.out.println(wSDLDocument.toString());
        }
        catch (Exception exception) {
            exception.toString();
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

