/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.WorkspaceListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIActionMapping;
import com.eviware.soapui.support.action.support.DefaultActionMapping;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.desktop.DesktopListener;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class RecentItemsListener
extends WorkspaceListenerAdapter
implements WorkspaceListener,
DesktopListener {
    private static final String RECENT_WORKSPACES_SETTING = "RecentWorkspaces";
    private static final String RECENT_PROJECTS_SETTING = "RecentProjects";
    private static final String EMPTYMARKER = "- empty -";
    private static final String CLEAR_ITEMS = "Clear Items";
    private JMenu recentProjectsMenu;
    private JMenu recentWorkspacesMenu;
    private JMenu recentEditorsMenu;
    private boolean switchingWorkspace;

    public RecentItemsListener(JMenu recentWorkspacesMenu2, JMenu recentProjectsMenu2, JMenu recentEditorsMenu2) {
        this.recentWorkspacesMenu = recentWorkspacesMenu2;
        this.recentProjectsMenu = recentProjectsMenu2;
        this.recentEditorsMenu = recentEditorsMenu2;
        this.recentEditorsMenu.add(EMPTYMARKER).setEnabled(false);
        this.recentEditorsMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                int editorCount = 0;
                for (int c = 0; c < RecentItemsListener.this.recentEditorsMenu.getItemCount(); ++c) {
                    ShowEditorAction action = RecentItemsListener.this.getShowEditorAction(RecentItemsListener.this.recentEditorsMenu, c);
                    if (action == null) continue;
                    ++editorCount;
                    if (action.isReleased()) {
                        RecentItemsListener.this.recentEditorsMenu.remove(c);
                        --c;
                        continue;
                    }
                    try {
                        action.update();
                        continue;
                    }
                    catch (Throwable e1) {
                        RecentItemsListener.this.recentEditorsMenu.remove(c);
                        --c;
                    }
                }
                JMenuItem clearAllItem = null;
                for (int i = 0; i < RecentItemsListener.this.recentEditorsMenu.getItemCount(); ++i) {
                    JMenuItem editorItem = RecentItemsListener.this.recentEditorsMenu.getItem(i);
                    if (editorItem == null || !editorItem.getText().equals(RecentItemsListener.CLEAR_ITEMS)) continue;
                    clearAllItem = editorItem;
                }
                if (clearAllItem == null) {
                    clearAllItem = new JMenuItem(new ClearEditorsAction());
                    RecentItemsListener.this.recentEditorsMenu.addSeparator();
                    RecentItemsListener.this.recentEditorsMenu.add(clearAllItem);
                }
                clearAllItem.setEnabled(editorCount > 0);
                if (editorCount == 0 && RecentItemsListener.this.recentEditorsMenu.getItemCount() <= 2) {
                    RecentItemsListener.this.recentEditorsMenu.add((Component)new JMenuItem(RecentItemsListener.EMPTYMARKER), 0).setEnabled(false);
                }
            }
        });
        this.updateRecentWorkspacesMenu();
        this.updateRecentProjectsMenu();
    }

    private void updateRecentWorkspacesMenu() {
        String recent = SoapUI.getSettings().getString(RECENT_WORKSPACES_SETTING, null);
        StringToStringMap history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        this.recentWorkspacesMenu.removeAll();
        if (history.size() > 0) {
            for (String filePath : history.keySet()) {
                DefaultActionMapping mapping = new DefaultActionMapping("SwitchWorkspaceAction", null, null, false, filePath);
                String wsName = (String)history.get(filePath);
                if (SoapUI.getWorkspace().getPath().equals(filePath)) continue;
                mapping.setName(wsName);
                mapping.setDescription("Switches to the [" + wsName + "] workspace");
                SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
                this.recentWorkspacesMenu.add(new JMenuItem(delegate));
            }
        } else {
            this.recentWorkspacesMenu.add(EMPTYMARKER).setEnabled(false);
        }
        this.recentWorkspacesMenu.addSeparator();
        this.recentWorkspacesMenu.add(new ClearWorkspacesAction()).setEnabled(history.size() > 0);
    }

    private void updateRecentProjectsMenu() {
        StringToStringMap history;
        this.recentProjectsMenu.removeAll();
        String recent = SoapUI.getSettings().getString(RECENT_PROJECTS_SETTING, null);
        StringToStringMap stringToStringMap = history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        if (history.size() > 0) {
            for (String filePath : history.keySet()) {
                DefaultActionMapping mapping = new DefaultActionMapping("ImportWsdlProjectAction", null, null, false, filePath);
                String wsName = (String)history.get(filePath);
                mapping.setName(wsName);
                mapping.setDescription("Switches to the [" + wsName + "] project");
                SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
                this.recentProjectsMenu.add(new JMenuItem(delegate));
            }
        } else {
            this.recentProjectsMenu.add(EMPTYMARKER).setEnabled(false);
        }
        this.recentProjectsMenu.addSeparator();
        this.recentProjectsMenu.add(new ClearProjectsAction()).setEnabled(history.size() > 0);
    }

    public void projectAdded(Project project) {
        if (this.switchingWorkspace) {
            return;
        }
        String filePath = ((WsdlProject)project).getPath();
        if (filePath == null) {
            return;
        }
        String recent = SoapUI.getSettings().getString(RECENT_PROJECTS_SETTING, null);
        if (recent != null) {
            StringToStringMap history = StringToStringMap.fromXml(recent);
            history.remove(filePath);
            SoapUI.getSettings().setString(RECENT_PROJECTS_SETTING, history.toXml());
        }
        for (int c = 0; c < this.recentProjectsMenu.getItemCount() - 2; ++c) {
            SoapUIActionMapping mapping;
            SwingActionDelegate actionDelegate;
            Action action;
            JMenuItem item = this.recentProjectsMenu.getItem(c);
            if (item == null || !((action = item.getAction()) instanceof SwingActionDelegate) || (actionDelegate = (SwingActionDelegate)action) == null || !filePath.equals((mapping = actionDelegate.getMapping()).getParam())) continue;
            this.recentProjectsMenu.remove(c);
            break;
        }
        if (this.recentProjectsMenu.getItemCount() == 2) {
            this.recentProjectsMenu.add((Component)new JMenuItem(EMPTYMARKER), 0).setEnabled(false);
            this.recentProjectsMenu.getItem(this.recentProjectsMenu.getItemCount() - 1).setEnabled(false);
        }
    }

    public void projectChanged(Project project) {
    }

    public void projectRemoved(Project project) {
        if (this.switchingWorkspace) {
            return;
        }
        String filePath = ((WsdlProject)project).getPath();
        String recent = SoapUI.getSettings().getString(RECENT_PROJECTS_SETTING, null);
        StringToStringMap history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        history.put(filePath, project.getName());
        SoapUI.getSettings().setString(RECENT_PROJECTS_SETTING, history.toXml());
        DefaultActionMapping mapping = new DefaultActionMapping("ImportWsdlProjectAction", null, null, false, filePath);
        mapping.setName(project.getName());
        mapping.setDescription("Switches to the [" + project.getName() + "] project");
        SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
        this.recentProjectsMenu.add((Component)new JMenuItem(delegate), this.recentProjectsMenu.getItemCount() - 2);
        this.recentProjectsMenu.getItem(this.recentProjectsMenu.getItemCount() - 1).setEnabled(true);
        if (this.isEmptyMarker(this.recentProjectsMenu.getItem(0))) {
            this.recentProjectsMenu.remove(0);
        }
        this.removeProjectEditors(project);
    }

    private void removeProjectEditors(Project project) {
        for (int c = 0; c < this.recentEditorsMenu.getItemCount(); ++c) {
            ShowEditorAction action = this.getShowEditorAction(this.recentEditorsMenu, c);
            if (action == null) continue;
            if (action.isReleased()) {
                this.recentEditorsMenu.remove(c);
                --c;
                continue;
            }
            try {
                action.update();
                if (!this.dependsOnProject(action.getModelItem(), project)) continue;
                this.recentEditorsMenu.remove(c);
                --c;
                continue;
            }
            catch (Throwable e1) {
                this.recentEditorsMenu.remove(c);
                --c;
            }
        }
    }

    private boolean dependsOnProject(ModelItem modelItem, Project project) {
        if (modelItem instanceof Interface) {
            return ((Interface)modelItem).getProject() == project;
        }
        if (modelItem instanceof Operation) {
            return ((Operation)modelItem).getInterface().getProject() == project;
        }
        if (modelItem instanceof Request) {
            return ((Request)modelItem).getOperation().getInterface().getProject() == project;
        }
        if (modelItem instanceof TestSuite) {
            return ((TestSuite)modelItem).getProject() == project;
        }
        if (modelItem instanceof TestCase) {
            return ((TestCase)modelItem).getTestSuite().getProject() == project;
        }
        if (modelItem instanceof TestStep) {
            return ((TestStep)modelItem).getTestCase().getTestSuite().getProject() == project;
        }
        if (modelItem instanceof LoadTest) {
            return ((LoadTest)modelItem).getTestCase().getTestSuite().getProject() == project;
        }
        if (modelItem instanceof MockService) {
            return ((MockService)modelItem).getProject() == project;
        }
        if (modelItem instanceof MockOperation) {
            return ((MockOperation)modelItem).getMockService().getProject() == project;
        }
        if (modelItem instanceof MockResponse) {
            return ((MockResponse)modelItem).getMockOperation().getMockService().getProject() == project;
        }
        return false;
    }

    public void workspaceSwitched(Workspace workspace) {
        this.switchingWorkspace = false;
        String filePath = workspace.getPath();
        String recent = SoapUI.getSettings().getString(RECENT_WORKSPACES_SETTING, null);
        if (recent != null) {
            StringToStringMap history = StringToStringMap.fromXml(recent);
            history.remove(filePath);
            SoapUI.getSettings().setString(RECENT_WORKSPACES_SETTING, history.toXml());
        }
        for (int c = 0; c < this.recentWorkspacesMenu.getItemCount(); ++c) {
            SoapUIActionMapping mapping;
            SwingActionDelegate actionDelegate;
            Action action;
            JMenuItem item = this.recentWorkspacesMenu.getItem(c);
            if (item == null || !((action = item.getAction()) instanceof SwingActionDelegate) || (actionDelegate = (SwingActionDelegate)action) == null || !filePath.equals((mapping = actionDelegate.getMapping()).getParam())) continue;
            this.recentWorkspacesMenu.remove(c);
            break;
        }
        if (this.recentWorkspacesMenu.getItemCount() == 2) {
            this.recentWorkspacesMenu.add((Component)new JMenuItem(EMPTYMARKER), 0).setEnabled(false);
        }
    }

    public void workspaceSwitching(Workspace workspace) {
        this.switchingWorkspace = true;
        this.recentEditorsMenu.removeAll();
        if (this.recentEditorsMenu.getItemCount() == 0) {
            this.recentEditorsMenu.add(EMPTYMARKER).setEnabled(false);
        }
        String filePath = workspace.getPath();
        DefaultActionMapping mapping = new DefaultActionMapping("SwitchWorkspaceAction", null, null, false, filePath);
        mapping.setName(workspace.getName());
        mapping.setDescription("Switches to the [" + workspace.getName() + "] workspace");
        SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
        this.recentWorkspacesMenu.add((Component)new JMenuItem(delegate), this.recentWorkspacesMenu.getItemCount() - 2);
        this.recentWorkspacesMenu.getItem(this.recentWorkspacesMenu.getItemCount() - 1).setEnabled(true);
        System.out.println(this.recentWorkspacesMenu.getItem(this.recentWorkspacesMenu.getItemCount() - 1).getText());
        String recent = SoapUI.getSettings().getString(RECENT_WORKSPACES_SETTING, null);
        StringToStringMap history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        history.put(filePath, workspace.getName());
        SoapUI.getSettings().setString(RECENT_WORKSPACES_SETTING, history.toXml());
        if (this.isEmptyMarker(this.recentWorkspacesMenu.getItem(0))) {
            this.recentWorkspacesMenu.remove(0);
        }
        this.recentEditorsMenu.removeAll();
    }

    public void desktopPanelClosed(DesktopPanel desktopPanel) {
        ModelItem modelItem = desktopPanel.getModelItem();
        if (modelItem == null || this.recentEditorsMenu.getItemCount() == 0) {
            return;
        }
        if (this.isEmptyMarker(this.recentEditorsMenu.getItem(0))) {
            this.recentEditorsMenu.remove(0);
        }
        this.recentEditorsMenu.add((Component)new JMenuItem(new ShowEditorAction(modelItem)), 0);
    }

    public void desktopPanelCreated(DesktopPanel desktopPanel) {
        for (int c = 0; c < this.recentEditorsMenu.getItemCount(); ++c) {
            ShowEditorAction action = this.getShowEditorAction(this.recentEditorsMenu, c);
            if (action == null) continue;
            if (action.isReleased()) {
                this.recentEditorsMenu.remove(c);
                --c;
                continue;
            }
            if (!action.getModelItem().equals(desktopPanel.getModelItem())) continue;
            this.recentEditorsMenu.remove(c);
            break;
        }
        if (this.recentEditorsMenu.getItemCount() == 2) {
            this.recentEditorsMenu.add((Component)new JMenuItem(EMPTYMARKER), 0).setEnabled(false);
        }
    }

    public void desktopPanelSelected(DesktopPanel desktopPanel) {
    }

    private ShowEditorAction getShowEditorAction(JMenu menu, int i) {
        JMenuItem menuItem = this.recentEditorsMenu.getItem(i);
        if (menuItem == null) {
            return null;
        }
        Action unknownAction = menuItem.getAction();
        if (unknownAction == null || !(unknownAction instanceof ShowEditorAction)) {
            return null;
        }
        return (ShowEditorAction)unknownAction;
    }

    private boolean isEmptyMarker(JMenuItem item) {
        if (item == null) {
            return false;
        }
        return item.getText().equals(EMPTYMARKER);
    }

    private class ClearEditorsAction
    extends AbstractAction {
        public ClearEditorsAction() {
            super(RecentItemsListener.CLEAR_ITEMS);
            this.putValue("ShortDescription", "Clear all recent Editors");
        }

        public void actionPerformed(ActionEvent e) {
            if (!UISupport.confirm("Remove all Editors from this menu?", "Question")) {
                return;
            }
            RecentItemsListener.this.recentEditorsMenu.removeAll();
            RecentItemsListener.this.recentEditorsMenu.add(RecentItemsListener.EMPTYMARKER).setEnabled(false);
            RecentItemsListener.this.recentEditorsMenu.addSeparator();
            RecentItemsListener.this.recentEditorsMenu.add(new ClearEditorsAction());
        }
    }

    private class ClearWorkspacesAction
    extends AbstractAction {
        public ClearWorkspacesAction() {
            super(RecentItemsListener.CLEAR_ITEMS);
            this.putValue("ShortDescription", "Clear all recent workspaces");
        }

        public void actionPerformed(ActionEvent e) {
            if (!UISupport.confirm("Remove all Workspaces from this menu?", "Question")) {
                return;
            }
            StringToStringMap emptyMap = new StringToStringMap();
            SoapUI.getSettings().setString(RecentItemsListener.RECENT_WORKSPACES_SETTING, emptyMap.toXml());
            RecentItemsListener.this.updateRecentWorkspacesMenu();
        }
    }

    private class ClearProjectsAction
    extends AbstractAction {
        public ClearProjectsAction() {
            super(RecentItemsListener.CLEAR_ITEMS);
            this.putValue("ShortDescription", "Clear all recent projects");
        }

        public void actionPerformed(ActionEvent e) {
            if (!UISupport.confirm("Remove all Projects from this menu?", "Question")) {
                return;
            }
            StringToStringMap emptyMap = new StringToStringMap();
            SoapUI.getSettings().setString(RecentItemsListener.RECENT_PROJECTS_SETTING, emptyMap.toXml());
            RecentItemsListener.this.updateRecentProjectsMenu();
        }
    }

    private static class ShowEditorAction
    extends AbstractAction {
        private Reference<ModelItem> ref;

        public ShowEditorAction(ModelItem modelItem) {
            super(modelItem.getName());
            this.putValue("ShortDescription", "Reopen editor for [" + modelItem.getName() + "]");
            this.ref = new WeakReference<ModelItem>(modelItem);
        }

        public ModelItem getModelItem() {
            return this.ref.get();
        }

        public void update() {
            ModelItem modelItem = this.ref.get();
            if (modelItem == null) {
                return;
            }
            this.putValue("Name", modelItem.getName());
            this.putValue("ShortDescription", "Reopen editor for [" + modelItem.getName() + "]");
        }

        public boolean isReleased() {
            return this.ref.get() == null;
        }

        public void actionPerformed(ActionEvent e) {
            ModelItem modelItem = this.ref.get();
            if (modelItem != null) {
                UISupport.showDesktopPanel(modelItem);
            } else {
                UISupport.showErrorMessage("Item [" + this.getValue("Name") + "] is no longer available");
            }
        }
    }
}

