/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.RecentItemsListener;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.SoapUISplash;
import com.eviware.soapui.SoapUIThreadCreator;
import com.eviware.soapui.StandaloneSoapUICore;
import com.eviware.soapui.SwingSoapUICore;
import com.eviware.soapui.actions.ShowSystemPropertiesAction;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.actions.StartHermesJMSButtonAction;
import com.eviware.soapui.actions.SwitchDesktopPanelAction;
import com.eviware.soapui.actions.VersionUpdateAction;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.project.StartLoadUI;
import com.eviware.soapui.impl.wsdl.actions.support.OpenUrlAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.HermesUtils;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.integration.impl.CajoServer;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.environment.EnvironmentListener;
import com.eviware.soapui.model.environment.Property;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.util.PanelBuilderRegistry;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceFactory;
import com.eviware.soapui.monitor.MockEngine;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.VersionUpdateSettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.SoapUIVersionUpdate;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.dnd.NavigatorDragAndDropable;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropHandler;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistry;
import com.eviware.soapui.support.jnlp.WebstartUtilCore;
import com.eviware.soapui.support.listener.SoapUIListenerRegistry;
import com.eviware.soapui.support.log.InspectorLog4JMonitor;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.log.Log4JMonitor;
import com.eviware.soapui.support.log.LogDisablingTestMonitorListener;
import com.eviware.soapui.support.monitor.MonitorPanel;
import com.eviware.soapui.support.monitor.RuntimeMemoryMonitorSource;
import com.eviware.soapui.support.swing.MenuScroller;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.tools.CmdLineRunner;
import com.eviware.soapui.ui.JDesktopPanelsList;
import com.eviware.soapui.ui.Navigator;
import com.eviware.soapui.ui.NavigatorListener;
import com.eviware.soapui.ui.URLDesktopPanel;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.DesktopRegistry;
import com.eviware.soapui.ui.desktop.NullDesktop;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.soapui.ui.desktop.standalone.StandaloneDesktop;
import com.eviware.soapui.ui.support.DesktopListenerAdapter;
import com.eviware.x.impl.swing.SwingDialogs;
import com.google.common.base.Objects;
import com.jgoodies.looks.HeaderStyle;
import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.BrowserType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SoapUI {
    public static final String DEFAULT_DESKTOP = "Default";
    public static final String CURRENT_SOAPUI_WORKSPACE = SoapUI.class.getName() + "@workspace";
    public static final Logger log = Logger.getLogger(SoapUI.class);
    public static final String SOAPUI_VERSION = (String)Objects.firstNonNull((Object)System.getProperty("soapui.version"), (Object)Objects.firstNonNull((Object)SoapUI.class.getPackage().getImplementationVersion(), (Object)"UNKNOWN VERSION"));
    public static final String DEFAULT_WORKSPACE_FILE = "default-soapui-workspace.xml";
    public static final String SOAPUI_SPLASH = "soapui-splash.png";
    public static final String SOAPUI_TITLE = "/branded/branded.properties";
    private static final int DEFAULT_DESKTOP_ACTIONS_COUNT = 3;
    public static final String PROXY_ENABLED_ICON = "/proxyEnabled.png";
    public static final String PROXY_DISABLED_ICON = "/proxyDisabled.png";
    public static String PUSH_PAGE_URL = "http://soapui.org/Appindex/soapui-starterpage.html?version=" + URLEncoder.encode(SOAPUI_VERSION);
    public static String FRAME_ICON = "/16-perc.gif";
    public static String PUSH_PAGE_ERROR_URL = "file://" + System.getProperty("soapui.home", ".") + "/starter-page.html";
    private static List<Object> logCache = new ArrayList<Object>();
    private static SoapUICore soapUICore;
    private static Timer soapUITimer;
    private static JFrame frame;
    private static Navigator navigator;
    private static SoapUIDesktop desktop;
    private static Workspace workspace;
    private static Log4JMonitor logMonitor;
    private static Logger errorLog;
    private static boolean isStandalone;
    private static boolean isCommandLine;
    private static TestMonitor testMonitor;
    private JMenu desktopMenu;
    private JMenu helpMenu;
    private JMenu fileMenu;
    private static JMenuBar menuBar;
    private JDesktopPanelsList desktopPanelsList;
    private static Boolean checkedGroovyLogMonitor;
    private static Boolean launchedTestRunner;
    private JPanel overviewPanel;
    private JMenu toolsMenu;
    private boolean saveOnExit = true;
    private InternalDesktopListener internalDesktopListener = new InternalDesktopListener();
    private JInspectorPanel mainInspector;
    private static AutoSaveTimerTask autoSaveTimerTask;
    private static String workspaceName;
    private static StringToStringMap projectOptions;
    private static URLDesktopPanel urlDesktopPanel;
    private static JXToolBar mainToolbar;
    private static String[] mainArgs;
    private static GCTimerTask gcTimerTask;
    private static final ThreadPoolExecutor threadPool;
    private JTextField searchField;
    private static JToggleButton applyProxyButton;
    private static Logger groovyLogger;
    private static Logger loadUILogger;
    private static JButton launchLoadUIButton;
    private static CmdLineRunner soapUIRunner;

    private SoapUI() {
    }

    private static int getSystemPropertyAsInt(String string, int defaultValue) {
        String strValue = System.getProperty("soapui.threadpool.max");
        int parseInt = defaultValue;
        try {
            parseInt = Integer.parseInt(strValue);
        }
        catch (Exception e) {
            // empty catch block
        }
        return parseInt;
    }

    private void buildUI() {
        log.info((Object)("Used java version: " + System.getProperty("java.version")));
        frame.addWindowListener(new MainFrameWindowListener());
        UISupport.setMainFrame(frame);
        navigator = new Navigator(workspace);
        navigator.addNavigatorListener(new InternalNavigatorListener());
        this.desktopPanelsList = new JDesktopPanelsList(desktop);
        this.mainInspector = JInspectorPanelFactory.build(this.buildContentPanel(), 2);
        this.mainInspector.addInspector(new JComponentInspector<JComponent>(this.buildMainPanel(), "Navigator", "The soapUI Navigator", true));
        this.mainInspector.setCurrentInspector("Navigator");
        frame.setJMenuBar(this.buildMainMenu());
        frame.getContentPane().add((Component)this.buildToolbar(), "North");
        frame.getContentPane().add((Component)this.mainInspector.getComponent(), "Center");
        frame.setDefaultCloseOperation(0);
        frame.setSize(1000, 750);
        this.mainInspector.setDividerLocation(250);
        this.mainInspector.setResizeWeight(0.1);
        navigator.selectModelItem(workspace);
        desktop.addDesktopListener(this.internalDesktopListener);
        ToolTipManager.sharedInstance().setInitialDelay(200);
        JTree mainTree = navigator.getMainTree();
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler navigatorDragAndDropHandler = new SoapUIDragAndDropHandler(new NavigatorDragAndDropable(mainTree), 6);
        dragSource.createDefaultDragGestureRecognizer(mainTree, 3, navigatorDragAndDropHandler);
        desktop.init();
    }

    public static JToggleButton getApplyProxyButton() {
        return applyProxyButton;
    }

    private JComponent buildToolbar() {
        mainToolbar = new JXToolBar();
        mainToolbar.setFloatable(false);
        mainToolbar.setRollover(true);
        mainToolbar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        mainToolbar.add(new NewWsdlProjectActionDelegate());
        mainToolbar.add(new ImportWsdlProjectActionDelegate());
        mainToolbar.add(new SaveAllActionDelegate());
        mainToolbar.addSpace(2);
        mainToolbar.add(new ShowOnlineHelpAction("User Guide", "http://www.soapui.org/userguide/index.html", "Opens the soapUI User-Guide in a browser"));
        mainToolbar.add(new ShowOnlineHelpAction("Forum", "http://www.eviware.com/forums", "Opens the soapUI Forum in a browser", "/group_go.png"));
        mainToolbar.addSpace(2);
        mainToolbar.add(new ShowOnlineHelpAction("Trial", "http://www.eviware.com/soapui/trial", "Apply for soapUI Pro Trial License", "/favicon.png"));
        mainToolbar.addSpace(2);
        mainToolbar.add(new PreferencesActionDelegate());
        applyProxyButton = (JToggleButton)mainToolbar.add(new JToggleButton(new ApplyProxyButtonAction()));
        ProxyUtils.setProxyEnabled(SoapUI.getSettings().getBoolean(ProxySettings.ENABLE_PROXY));
        if (ProxyUtils.isProxyEnabled()) {
            applyProxyButton.setIcon(UISupport.createImageIcon(PROXY_ENABLED_ICON));
            applyProxyButton.setSelected(true);
            ProxyUtils.setProxyEnabled(true);
        } else {
            applyProxyButton.setIcon(UISupport.createImageIcon(PROXY_DISABLED_ICON));
            ProxyUtils.setProxyEnabled(false);
        }
        launchLoadUIButton = mainToolbar.add(new LaunchLoadUIButtonAction());
        mainToolbar.addGlue();
        this.searchField = new JTextField(20);
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    SoapUI.this.doForumSearch(SoapUI.this.searchField.getText());
                }
            }
        });
        mainToolbar.addLabeledFixed("Search Forum", this.searchField);
        mainToolbar.add(new ToolbarForumSearchAction());
        mainToolbar.add(new ShowOnlineHelpAction("http://www.soapui.org/userguide/index.html"));
        for (int i = 0; i < mainToolbar.getComponentCount(); ++i) {
            if (!(mainToolbar.getComponent(i) instanceof JComponent)) continue;
            ((JComponent)mainToolbar.getComponent(i)).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        }
        mainToolbar.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 1));
        return mainToolbar;
    }

    public void doForumSearch(String text) {
        if (!this.searchField.getText().equals(text)) {
            this.searchField.setText(text);
        }
        if (StringUtils.hasContent(text)) {
            Tools.openURL("http://www.eviware.com/forums/search.php?keywords=" + URLEncoder.encode(text.trim()));
        } else {
            Tools.openURL("http://www.eviware.com/forums");
        }
    }

    private JMenuBar buildMainMenu() {
        menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        menuBar.add(this.buildFileMenu());
        menuBar.add(this.buildToolsMenu());
        menuBar.add(this.buildDesktopMenu());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    public static ThreadPoolExecutor getThreadPool() {
        return threadPool;
    }

    public static Workspace getWorkspace() {
        return workspace;
    }

    private JMenu buildDesktopMenu() {
        this.desktopMenu = new JMenu("Desktop");
        this.desktopMenu.setMnemonic(68);
        this.desktopMenu.add(new SwitchDesktopPanelAction(this.desktopPanelsList));
        this.desktopMenu.add(new MaximizeDesktopAction((InspectorLog4JMonitor)logMonitor));
        this.desktopMenu.addSeparator();
        ActionSupport.addActions(desktop.getActions(), this.desktopMenu);
        return this.desktopMenu;
    }

    private JMenu buildHelpMenu() {
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.helpMenu.add(new ShowPushPageAction());
        this.helpMenu.addSeparator();
        this.helpMenu.add(new ShowOnlineHelpAction("User Guide", "http://www.soapui.org/userguide/index.html"));
        this.helpMenu.add(new ShowOnlineHelpAction("Getting Started", "http://www.soapui.org/gettingstarted/index.html"));
        this.helpMenu.add(new SearchForumAction());
        this.helpMenu.addSeparator();
        this.helpMenu.add(new ShowSystemPropertiesAction());
        this.helpMenu.addSeparator();
        this.helpMenu.add(new VersionUpdateAction());
        this.helpMenu.addSeparator();
        this.helpMenu.add(new ShowOnlineHelpAction("soapUI Pro Trial", "http://www.eviware.com/soapui/trial", "Apply for soapUI Pro Trial License", "/favicon.png"));
        this.helpMenu.addSeparator();
        this.helpMenu.add(new OpenUrlAction("soapui.org", "http://www.soapui.org"));
        this.helpMenu.add(new OpenUrlAction("smartbear.com", "http://smartbear.com"));
        this.helpMenu.addSeparator();
        this.helpMenu.add(new AboutAction());
        return this.helpMenu;
    }

    private JMenu buildToolsMenu() {
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.toolsMenu.add(SwingActionDelegate.createDelegate("WSToolsWsdl2JavaAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("JBossWSConsumeAction"));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(SwingActionDelegate.createDelegate("WSCompileAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("WSImportAction"));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(SwingActionDelegate.createDelegate("Axis1XWSDL2JavaAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("Axis2WSDL2CodeAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("CXFAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("XFireAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("OracleWsaGenProxyAction"));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(SwingActionDelegate.createDelegate("XmlBeans2Action"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("JaxbXjcAction"));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(SwingActionDelegate.createDelegate("DotNetWsdlAction"));
        this.toolsMenu.add(SwingActionDelegate.createDelegate("GSoapAction"));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(SwingActionDelegate.createDelegate("TcpMonAction"));
        this.toolsMenu.addSeparator();
        StartHermesJMSButtonAction hermesJMSButtonAction = new StartHermesJMSButtonAction();
        hermesJMSButtonAction.setEnabled(HermesUtils.isHermesJMSSupported());
        this.toolsMenu.add(hermesJMSButtonAction);
        return this.toolsMenu;
    }

    private JMenu buildFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        ActionList actions = ActionListBuilder.buildActions(workspace);
        actions.removeAction(actions.getActionCount() - 1);
        ActionSupport.addActions(actions, this.fileMenu);
        this.fileMenu.add(SoapUIPreferencesAction.getInstance());
        this.fileMenu.add(new SavePreferencesAction());
        this.fileMenu.add(new ImportPreferencesAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.buildRecentMenu());
        this.fileMenu.addSeparator();
        this.fileMenu.add(new ExitAction());
        this.fileMenu.add(new ExitWithoutSavingAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(new ShowOnlineHelpAction("http://www.soapui.org/userguide/overview.html"));
        return this.fileMenu;
    }

    private JMenuItem buildRecentMenu() {
        JMenu recentMenu = new JMenu("Recent");
        JMenu recentProjectsMenu = new JMenu("Projects");
        JMenu recentWorkspacesMenu = new JMenu("Workspaces");
        JMenu recentEditorsMenu = new JMenu("Editors");
        recentMenu.add(recentEditorsMenu);
        recentMenu.add(recentProjectsMenu);
        recentMenu.add(recentWorkspacesMenu);
        MenuScroller.setScrollerFor(recentEditorsMenu, 24, 125, 0, 1);
        MenuScroller.setScrollerFor(recentProjectsMenu, 24, 125, 0, 1);
        MenuScroller.setScrollerFor(recentWorkspacesMenu, 24, 125, 0, 1);
        RecentItemsListener recentItemsListener = new RecentItemsListener(recentWorkspacesMenu, recentProjectsMenu, recentEditorsMenu);
        workspace.addWorkspaceListener(recentItemsListener);
        desktop.addDesktopListener(recentItemsListener);
        return recentMenu;
    }

    public static JFrame getFrame() {
        return frame;
    }

    private JComponent buildMainPanel() {
        JInspectorPanel inspectorPanel = JInspectorPanelFactory.build(navigator);
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildOverviewPanel(), "Properties", "Properties for the currently selected item", true));
        inspectorPanel.setDividerLocation(500);
        inspectorPanel.setResizeWeight(0.6);
        inspectorPanel.setCurrentInspector("Properties");
        return inspectorPanel.getComponent();
    }

    private JComponent buildOverviewPanel() {
        this.overviewPanel = new JPanel(new BorderLayout());
        this.overviewPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 2));
        return this.overviewPanel;
    }

    private void setOverviewPanel(Component panel) {
        if (this.overviewPanel.getComponentCount() == 0 && panel == null) {
            return;
        }
        this.overviewPanel.removeAll();
        if (panel != null) {
            this.overviewPanel.add(panel, "Center");
        }
        this.overviewPanel.revalidate();
        this.overviewPanel.repaint();
    }

    private JComponent buildContentPanel() {
        return this.buildLogPanel(true, "soapUI log");
    }

    private JComponent buildLogPanel(boolean hasDefault, String defaultName) {
        InspectorLog4JMonitor inspectorLog4JMonitor = new InspectorLog4JMonitor(desktop.getDesktopComponent());
        JComponent monitor = SoapUI.initLogMonitor(hasDefault, defaultName, inspectorLog4JMonitor);
        if (!SoapUI.getSettings().getBoolean(UISettings.SHOW_LOGS_AT_STARTUP)) {
            inspectorLog4JMonitor.activate(null);
        }
        MonitorPanel monitorPanel = new MonitorPanel(new RuntimeMemoryMonitorSource());
        monitorPanel.start();
        inspectorLog4JMonitor.addInspector(new JComponentInspector<MonitorPanel>(monitorPanel, "memory log", "Shows runtime memory consumption", true));
        return monitor;
    }

    public static JComponent initLogMonitor(boolean hasDefault, String defaultName, Log4JMonitor logMonitor) {
        SoapUI.logMonitor = logMonitor;
        logMonitor.addLogArea(defaultName, "com.eviware.soapui", hasDefault).setLevel(Level.DEBUG);
        logMonitor.addLogArea("http log", "org.apache.http.wire", false).setLevel(Level.DEBUG);
        logMonitor.addLogArea("jetty log", "jetty", false).setLevel(Level.INFO);
        logMonitor.addLogArea("error log", "soapui.errorlog", false).setLevel(Level.DEBUG);
        logMonitor.addLogArea("wsrm log", "wsrm", false).setLevel(Level.INFO);
        for (Object message : logCache) {
            logMonitor.logEvent(message);
        }
        return logMonitor.getComponent();
    }

    public static synchronized void log(final Object msg) {
        if (logMonitor == null) {
            if (!isCommandLine && logCache.size() < 1000) {
                logCache.add(msg);
            }
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            logMonitor.logEvent(msg);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    logMonitor.logEvent(msg);
                }
            });
        }
    }

    public static void main(String[] args) throws Exception {
        WebstartUtilCore.init();
        mainArgs = args;
        SoapUIRunner soapuiRunner = new SoapUIRunner();
        if (!SoapUI.isJXBrowserDisabled(true) && PlatformContext.isMacOS()) {
            SwingUtilities.invokeLater(soapuiRunner);
        } else {
            soapuiRunner.run();
        }
    }

    public static String[] getMainArgs() {
        return mainArgs;
    }

    public static SoapUI startSoapUI(String[] args, String title, String splashImage, SwingSoapUICore core) throws Exception {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "SoapUI");
        frame = new JFrame(title);
        SoapUISplash splash = new SoapUISplash(splashImage, frame);
        frame.setIconImage(UISupport.createImageIcon(FRAME_ICON).getImage());
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        isStandalone = true;
        soapUICore = core;
        SoapUI soapUI = new SoapUI();
        Workspace workspace = null;
        Options options = SoapUI.initSoapUIOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (!SoapUI.processCommandLineArgs(cmd, options)) {
            System.exit(1);
        }
        if (workspaceName != null) {
            workspace = WorkspaceFactory.getInstance().openWorkspace(workspaceName, projectOptions);
            soapUICore.getSettings().setString(CURRENT_SOAPUI_WORKSPACE, workspaceName);
        } else {
            String wsfile = soapUICore.getSettings().getString(CURRENT_SOAPUI_WORKSPACE, System.getProperty("user.home") + File.separatorChar + DEFAULT_WORKSPACE_FILE);
            try {
                workspace = WorkspaceFactory.getInstance().openWorkspace(wsfile, projectOptions);
            }
            catch (Exception e) {
                UISupport.setDialogs(new SwingDialogs(null));
                if (UISupport.confirm("Failed to open workspace: [" + e.toString() + "], create new one instead?", "Error")) {
                    new File(wsfile).renameTo(new File(wsfile + ".bak"));
                    workspace = WorkspaceFactory.getInstance().openWorkspace(wsfile, projectOptions);
                }
                System.exit(1);
            }
        }
        core.prepareUI();
        soapUI.show(workspace);
        core.afterStartup(workspace);
        Thread.sleep(500L);
        splash.setVisible(false);
        if (SoapUI.getSettings().getBoolean(UISettings.SHOW_STARTUP_PAGE) && !SoapUI.isJXBrowserDisabled(true)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SoapUI.showPushPage();
                }
            });
        }
        frame.setSize(1000, 750);
        String[] args2 = cmd.getArgs();
        if (args2 != null && args2.length > 0) {
            String arg = args2[0];
            if (arg.toUpperCase().endsWith(".WSDL") || arg.toUpperCase().endsWith(".WADL")) {
                SwingUtilities.invokeLater(new WsdlProjectCreator(arg));
            } else {
                try {
                    URL url = new URL(arg);
                    SwingUtilities.invokeLater(new RestProjectCreator(url));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return soapUI;
    }

    private static boolean processCommandLineArgs(CommandLine cmd, Options options) {
        if (cmd.hasOption('w')) {
            workspaceName = cmd.getOptionValue('w');
        }
        if (cmd.hasOption('p')) {
            for (String projectNamePassword : cmd.getOptionValues('p')) {
                String[] nameAndPassword = projectNamePassword.split(":");
                projectOptions.put(nameAndPassword[0], nameAndPassword[1]);
            }
        }
        return true;
    }

    private static Options initSoapUIOptions() {
        Options options = new Options();
        options.addOption("w", true, "Specified the name of the workspace xml file");
        options.addOption("p", true, "Sets project name and its password in format <project name>:<password>");
        return options;
    }

    public static SoapUICore getSoapUICore() {
        return soapUICore;
    }

    public static TestPropertyHolder getGlobalProperties() {
        return PropertyExpansionUtils.getGlobalProperties();
    }

    public static void setSoapUICore(SoapUICore soapUICore) {
        SoapUI.setSoapUICore(soapUICore, false);
    }

    public static void setSoapUICore(SoapUICore soapUICore, boolean isCommandLine) {
        SoapUI.soapUICore = soapUICore;
        SoapUI.isCommandLine = isCommandLine;
    }

    public static boolean isStandalone() {
        return isStandalone;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static JMenuBar getMenuBar() {
        return menuBar;
    }

    private void show(Workspace workspace) {
        SoapUI.workspace = workspace;
        String desktopType = soapUICore.getSettings().getString(UISettings.DESKTOP_TYPE, DEFAULT_DESKTOP);
        desktop = DesktopRegistry.getInstance().createDesktop(desktopType, workspace);
        if (desktop == null) {
            desktop = new StandaloneDesktop(workspace);
        }
        if (testMonitor == null) {
            testMonitor = new TestMonitor();
        }
        soapUICore.getSettings().addSettingsListener(new SettingsListener(){

            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(UISettings.DESKTOP_TYPE)) {
                    SoapUI.this.changeDesktop(DesktopRegistry.getInstance().createDesktop(newValue, workspace));
                }
            }

            public void settingsReloaded() {
            }
        });
        this.buildUI();
        testMonitor.addTestMonitorListener(new LogDisablingTestMonitorListener());
        testMonitor.init(workspace);
        frame.setVisible(true);
        SoapUI.initAutoSaveTimer();
        SoapUI.initGCTimer();
    }

    private void changeDesktop(SoapUIDesktop newDesktop) {
        this.desktopPanelsList.setDesktop(newDesktop);
        desktop.removeDesktopListener(this.internalDesktopListener);
        desktop.transferTo(newDesktop);
        desktop.release();
        desktop = newDesktop;
        if (logMonitor instanceof InspectorLog4JMonitor) {
            ((InspectorLog4JMonitor)logMonitor).setContentComponent(desktop.getDesktopComponent());
        }
        desktop.addDesktopListener(this.internalDesktopListener);
        while (this.desktopMenu.getItemCount() > 3) {
            this.desktopMenu.remove(3);
        }
        ActionSupport.addActions(desktop.getActions(), this.desktopMenu);
        desktop.init();
    }

    protected boolean onExit() {
        if (this.saveOnExit) {
            String question = "Exit SoapUI?";
            if (SoapUI.getTestMonitor().hasRunningTests()) {
                question = question + "\n(Projects with running tests will not be saved)";
            }
            if (!UISupport.confirm(question, "Question")) {
                return false;
            }
            try {
                soapUICore.saveSettings();
                workspace.onClose();
            }
            catch (Exception e1) {
                SoapUI.logError(e1);
            }
        } else if (!UISupport.confirm("Exit SoapUI without saving?", "Question")) {
            this.saveOnExit = true;
            return false;
        }
        SoapUI.shutdown();
        return true;
    }

    public static boolean isJXBrowserDisabled() {
        return SoapUI.isJXBrowserDisabled(false);
    }

    public static boolean isJXBrowserDisabled(boolean allowNative) {
        if (UISupport.isHeadless()) {
            return true;
        }
        if (SoapUI.isCommandLine()) {
            return true;
        }
        String disable = System.getProperty("soapui.jxbrowser.disable", "nope");
        if (disable.equals("true")) {
            return true;
        }
        if (SoapUI.getSoapUICore() != null && SoapUI.getSettings().getBoolean(UISettings.DISABLE_BROWSER)) {
            return true;
        }
        if (!disable.equals("false") && allowNative && (BrowserType.Mozilla.isSupported() || BrowserType.IE.isSupported() || BrowserType.Safari.isSupported())) {
            return false;
        }
        return !disable.equals("false") && !PlatformContext.isMacOS() && "64".equals(System.getProperty("sun.arch.data.model"));
    }

    public static boolean isJXBrowserPluginsDisabled() {
        return SoapUI.getSettings().getBoolean(UISettings.DISABLE_BROWSER_PLUGINS);
    }

    public static void shutdown() {
        soapUITimer.cancel();
    }

    public static void logError(Throwable e) {
        SoapUI.logError(e, null);
    }

    public static void logError(Throwable e, String message) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        log.error((Object)("An error occured [" + msg + "], see error log for details"));
        try {
            if (message != null) {
                errorLog.error((Object)message);
            }
            errorLog.error((Object)e.toString(), e);
        }
        catch (OutOfMemoryError e1) {
            e1.printStackTrace();
            System.gc();
        }
        if (!SoapUI.isStandalone() || "true".equals(System.getProperty("soapui.stacktrace"))) {
            e.printStackTrace();
        }
    }

    public static Logger getErrorLog() {
        return errorLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger ensureGroovyLog() {
        ThreadPoolExecutor threadPoolExecutor = threadPool;
        synchronized (threadPoolExecutor) {
            if (!checkedGroovyLogMonitor.booleanValue() || launchedTestRunner.booleanValue()) {
                groovyLogger = Logger.getLogger((String)"groovy.log");
                Log4JMonitor logMonitor = SoapUI.getLogMonitor();
                if (logMonitor != null && !logMonitor.hasLogArea("groovy.log")) {
                    logMonitor.addLogArea("script log", "groovy.log", false);
                    checkedGroovyLogMonitor = true;
                } else if (logMonitor == null && launchedTestRunner.booleanValue()) {
                    checkedGroovyLogMonitor = true;
                    launchedTestRunner = false;
                }
            }
        }
        return groovyLogger;
    }

    public static void showPushPage() {
        if (urlDesktopPanel == null || urlDesktopPanel.isClosed()) {
            try {
                urlDesktopPanel = new URLDesktopPanel("soapUI Starter Page", "Info on soapUI", null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
        DesktopPanel dp = UISupport.showDesktopPanel(urlDesktopPanel);
        desktop.maximize(dp);
        urlDesktopPanel.navigate(PUSH_PAGE_URL, PUSH_PAGE_ERROR_URL, true);
    }

    public static TestMonitor getTestMonitor() {
        if (testMonitor == null) {
            testMonitor = new TestMonitor();
        }
        return testMonitor;
    }

    public static void setTestMonitor(TestMonitor monitor) {
        testMonitor = monitor;
    }

    public static Log4JMonitor getLogMonitor() {
        return logMonitor;
    }

    public static void setLogMonitor(Log4JMonitor monitor) {
        logMonitor = monitor;
    }

    public static SoapUIDesktop getDesktop() {
        if (desktop == null) {
            desktop = new NullDesktop();
        }
        return desktop;
    }

    public static void setDesktop(SoapUIDesktop desktop) {
        SoapUI.desktop = desktop;
    }

    public static Navigator getNavigator() {
        return navigator;
    }

    public static SoapUIActionRegistry getActionRegistry() {
        if (soapUICore == null) {
            soapUICore = new DefaultSoapUICore();
        }
        return soapUICore.getActionRegistry();
    }

    public static void setNavigator(Navigator navigator) {
        SoapUI.navigator = navigator;
    }

    public static void setWorkspace(Workspace workspace) {
        SoapUI.workspace = workspace;
    }

    public static void setStandalone(boolean standalone) {
        isStandalone = standalone;
    }

    public static SoapUIListenerRegistry getListenerRegistry() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getListenerRegistry();
    }

    public static SoapUIFactoryRegistry getFactoryRegistry() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getFactoryRegistry();
    }

    public static Settings getSettings() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getSettings();
    }

    public static void importPreferences(File file) throws Exception {
        if (soapUICore != null) {
            soapUICore.importSettings(file);
        }
    }

    public static MockEngine getMockEngine() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getMockEngine();
    }

    public static String saveSettings() throws Exception {
        return soapUICore == null ? null : soapUICore.saveSettings();
    }

    public static void initDefaultCore() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
    }

    public static void initAutoSaveTimer() {
        Settings settings = SoapUI.getSettings();
        long interval = settings.getLong(UISettings.AUTO_SAVE_INTERVAL, 0L);
        if (autoSaveTimerTask != null) {
            if (interval == 0L) {
                SoapUI.log("Cancelling AutoSave Timer");
            }
            autoSaveTimerTask.cancel();
            autoSaveTimerTask = null;
        }
        if (interval > 0L) {
            autoSaveTimerTask = new AutoSaveTimerTask();
            SoapUI.log("Scheduling autosave every " + interval + " minutes");
            soapUITimer.schedule((TimerTask)autoSaveTimerTask, interval * 1000L * 60L, interval * 1000L * 60L);
        }
    }

    public static void initGCTimer() {
        Settings settings = SoapUI.getSettings();
        long interval = settings.getLong(UISettings.GC_INTERVAL, 60L);
        if (gcTimerTask != null) {
            if (interval == 0L) {
                SoapUI.log("Cancelling GC Timer");
            }
            gcTimerTask.cancel();
            gcTimerTask = null;
        }
        if (interval > 0L) {
            gcTimerTask = new GCTimerTask();
            SoapUI.log("Scheduling garbage collection every " + interval + " seconds");
            soapUITimer.schedule((TimerTask)gcTimerTask, interval * 1000L, interval * 1000L);
        }
    }

    public static JXToolBar getToolBar() {
        return mainToolbar;
    }

    public static void setLaunchedTestRunner(Boolean launchedTestRunner) {
        SoapUI.launchedTestRunner = launchedTestRunner;
    }

    public static void setProxyEnabled(boolean proxyEnabled) {
        if (applyProxyButton != null) {
            applyProxyButton.setSelected(proxyEnabled);
        }
        ProxyUtils.setProxyEnabled(proxyEnabled);
    }

    public static Timer getSoapUITimer() {
        return soapUITimer;
    }

    public static void setCmdLineRunner(CmdLineRunner abstractSoapUIRunner) {
        soapUIRunner = abstractSoapUIRunner;
    }

    public static CmdLineRunner getCmdLineRunner() {
        return soapUIRunner;
    }

    public static boolean isAutoUpdateVersion() {
        return SoapUI.getSettings().getBoolean(VersionUpdateSettings.AUTO_CHECK_VERSION_UPDATE);
    }

    static {
        soapUITimer = new Timer();
        errorLog = Logger.getLogger((String)"soapui.errorlog");
        checkedGroovyLogMonitor = false;
        launchedTestRunner = false;
        projectOptions = new StringToStringMap();
        threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(SoapUI.getSystemPropertyAsInt("soapui.threadpool.max", 200), new SoapUIThreadCreator());
    }

    private static class GCTimerTask
    extends TimerTask {
        private GCTimerTask() {
        }

        public void run() {
            System.gc();
        }
    }

    private static class AutoSaveTimerTask
    extends TimerTask {
        private AutoSaveTimerTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SoapUI.log("Autosaving Workspace");
                    WorkspaceImpl wrkspc = (WorkspaceImpl)SoapUI.getWorkspace();
                    if (wrkspc != null) {
                        wrkspc.save(false, true);
                    }
                }
            });
        }
    }

    public class MaximizeDesktopAction
    extends AbstractAction {
        private JLogList lastLog;
        private int lastMainDividerLocation;
        private final InspectorLog4JMonitor log4JMonitor;
        private int lastLogDividerLocation;

        public MaximizeDesktopAction(InspectorLog4JMonitor log4JMonitor) {
            super("Maximize Desktop");
            this.log4JMonitor = log4JMonitor;
            this.putValue("ShortDescription", "Hides/Shows the Navigator and Log tabs");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu M"));
        }

        public void actionPerformed(ActionEvent e) {
            if (SoapUI.this.mainInspector.getCurrentInspector() != null || logMonitor.getCurrentLog() != null) {
                this.lastMainDividerLocation = SoapUI.this.mainInspector.getDividerLocation();
                SoapUI.this.mainInspector.deactivate();
                this.lastLog = logMonitor.getCurrentLog();
                this.lastLogDividerLocation = this.log4JMonitor.getDividerLocation();
                this.log4JMonitor.deactivate();
            } else {
                SoapUI.this.mainInspector.setCurrentInspector("Navigator");
                SoapUI.this.mainInspector.setDividerLocation(this.lastMainDividerLocation == 0 ? 250 : this.lastMainDividerLocation);
                this.log4JMonitor.setCurrentLog(this.lastLog);
                this.log4JMonitor.setDividerLocation(this.lastLogDividerLocation == 0 ? 500 : this.lastLogDividerLocation);
            }
        }
    }

    public static class ImportPreferencesAction
    extends AbstractAction {
        public static final String IMPORT_PREFERENCES_ACTION_NAME = "Import Preferences";

        public ImportPreferencesAction() {
            super(IMPORT_PREFERENCES_ACTION_NAME);
            this.putValue("ShortDescription", "Imports soapUI Settings from another settings-file");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file = UISupport.getFileDialogs().open(null, IMPORT_PREFERENCES_ACTION_NAME, ".xml", "soapUI Settings XML (*.xml)", null);
                if (file != null) {
                    soapUICore.importSettings(file);
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private class PreferencesActionDelegate
    extends AbstractAction {
        public PreferencesActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.putValue("ShortDescription", "Sets Global soapUI Preferences");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUIPreferencesAction.getInstance().actionPerformed(null);
        }
    }

    private static class SaveAllActionDelegate
    extends AbstractAction {
        public SaveAllActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/disk_multiple.png"));
            this.putValue("ShortDescription", "Saves all projects in the current workspace");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getActionRegistry().getAction("SaveAllProjectsAction").perform(workspace, null);
        }
    }

    private static class ImportWsdlProjectActionDelegate
    extends AbstractAction {
        public ImportWsdlProjectActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/import_project.gif"));
            this.putValue("ShortDescription", "Imports an existing soapUI Project into the current workspace");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getActionRegistry().getAction("ImportWsdlProjectAction").perform(workspace, null);
        }
    }

    private static class NewWsdlProjectActionDelegate
    extends AbstractAction {
        public NewWsdlProjectActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/project.gif"));
            this.putValue("ShortDescription", "Creates a new soapUI Project");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getActionRegistry().getAction("NewWsdlProjectAction").perform(workspace, null);
        }
    }

    private class SavePreferencesAction
    extends AbstractAction {
        public SavePreferencesAction() {
            super("Save Preferences");
            this.putValue("ShortDescription", "Saves all global preferences");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                soapUICore.saveSettings();
            }
            catch (Exception e1) {
                SoapUI.logError(e1, "There was an error when attempting to save your preferences");
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private class ExitWithoutSavingAction
    extends AbstractAction {
        public ExitWithoutSavingAction() {
            super("Exit without saving");
            this.putValue("ShortDescription", "Exits SoapUI without saving");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl shift Q"));
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = false;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowEvent);
        }
    }

    private static class AboutAction
    extends AbstractAction {
        private static final String COPYRIGHT = "2004-2013 smartbear.com";
        private static final String SOAPUI_WEBSITE = "http://www.soapui.org";
        private static final String SMARTBEAR_WEBSITE = "http://www.smartbear.com";
        public static final String BUILDINFO_PROPERTIES = "/buildinfo.properties";

        public AboutAction() {
            super("About soapUI");
            this.putValue("ShortDescription", "Shows information on soapUI");
        }

        public void actionPerformed(ActionEvent e) {
            URI splashURI = null;
            try {
                splashURI = UISupport.findSplash(SoapUI.SOAPUI_SPLASH).toURI();
            }
            catch (URISyntaxException e1) {
                SoapUI.logError(e1);
            }
            Properties buildInfoProperties = new Properties();
            try {
                buildInfoProperties.load(SoapUI.class.getResourceAsStream(BUILDINFO_PROPERTIES));
            }
            catch (Exception exception) {
                SoapUI.logError(exception, "Could not read build info properties");
            }
            UISupport.showExtendedInfo("About soapUI", null, "<html><body><p align=center> <font face=\"Verdana,Arial,Helvetica\"><strong><img src=\"" + splashURI + "\"><br>soapUI " + SOAPUI_VERSION + "<br>" + "Copyright (C) " + COPYRIGHT + "<br>" + "<a href=\"" + SOAPUI_WEBSITE + "\">" + SOAPUI_WEBSITE + "</a> | " + "<a href=\"" + SMARTBEAR_WEBSITE + "\">" + SMARTBEAR_WEBSITE + "</a><br>" + "Build Date: " + (String)Objects.firstNonNull((Object)buildInfoProperties.getProperty("build.date"), (Object)"UNKNOWN BUILD DATE") + "</strong></font></p></body></html>", new Dimension(646, 480));
        }
    }

    private class SearchForumAction
    extends AbstractAction {
        public SearchForumAction() {
            super("Search Forum");
            this.putValue("ShortDescription", "Searches the soapUI Support Forum");
        }

        public void actionPerformed(ActionEvent e) {
            String text = UISupport.prompt("Search Forum", "Searches the online Forum, leave empty to open", "");
            if (text == null) {
                return;
            }
            SoapUI.this.doForumSearch(text);
        }
    }

    private class ToolbarForumSearchAction
    extends AbstractAction {
        public ToolbarForumSearchAction() {
            this.putValue("ShortDescription", "Searches the soapUI Support Forum");
            this.putValue("SmallIcon", UISupport.createImageIcon("/find.png"));
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.this.doForumSearch(SoapUI.this.searchField.getText());
        }
    }

    private class ShowPushPageAction
    extends AbstractAction {
        public ShowPushPageAction() {
            super("Starter Page");
            this.putValue("ShortDescription", "Shows the starter page");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.showPushPage();
        }
    }

    private class ExitButtonAction
    extends AbstractAction {
        public ExitButtonAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/system-log-out.png"));
            this.putValue("ShortDescription", "Saves all projects and exits SoapUI");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = true;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowEvent);
        }
    }

    private class LaunchLoadUIButtonAction
    extends AbstractAction {
        public LaunchLoadUIButtonAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/launchLoadUI.png"));
            this.putValue("ShortDescription", "Launch loadUI");
        }

        public void actionPerformed(ActionEvent e) {
            Thread launchLoadUI = new Thread(new LoadUIRunner());
            launchLoadUI.start();
        }

        private final class LoadUIRunner
        implements Runnable {
            private LoadUIRunner() {
            }

            public void run() {
                Process p = StartLoadUI.launchLoadUI();
                if (p != null) {
                    InputStream is = p.getInputStream();
                    loadUILogger = Logger.getLogger((String)"com.eviware.soapui");
                    try {
                        BufferedInputStream inputStream = new BufferedInputStream(is);
                        BufferedReader bris = new BufferedReader(new InputStreamReader(inputStream));
                        String line = null;
                        while ((line = bris.readLine()) != null) {
                            loadUILogger.info((Object)line);
                        }
                        inputStream.close();
                        bris.close();
                        is.close();
                    }
                    catch (IOException e1) {
                        SoapUI.logError(e1);
                    }
                }
            }
        }
    }

    private class ApplyProxyButtonAction
    extends AbstractAction {
        public ApplyProxyButtonAction() {
            this.putValue("ShortDescription", "Apply proxy defined in global preferences");
        }

        public void actionPerformed(ActionEvent e) {
            if (ProxyUtils.isProxyEnabled()) {
                ProxyUtils.setProxyEnabled(false);
                SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, false);
                applyProxyButton.setIcon(UISupport.createImageIcon(SoapUI.PROXY_DISABLED_ICON));
            } else if (StringUtils.isNullOrEmpty(SoapUI.getSettings().getString(ProxySettings.HOST, "")) || StringUtils.isNullOrEmpty(SoapUI.getSettings().getString(ProxySettings.PORT, ""))) {
                SoapUIPreferencesAction.getInstance().show("Proxy Settings");
                if (!StringUtils.isNullOrEmpty(SoapUI.getSettings().getString(ProxySettings.HOST, "")) && !StringUtils.isNullOrEmpty(SoapUI.getSettings().getString(ProxySettings.PORT, ""))) {
                    ProxyUtils.setProxyEnabled(true);
                    SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, true);
                    applyProxyButton.setIcon(UISupport.createImageIcon(SoapUI.PROXY_ENABLED_ICON));
                }
            } else {
                ProxyUtils.setProxyEnabled(true);
                SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, true);
                applyProxyButton.setIcon(UISupport.createImageIcon(SoapUI.PROXY_ENABLED_ICON));
            }
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
            this.putValue("ShortDescription", "Saves all projects and exits SoapUI");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Q"));
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = true;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowEvent);
        }
    }

    public class InternalNavigatorListener
    implements NavigatorListener {
        private PropertyHolderTable selectedPropertyHolderTable = null;

        public void nodeSelected(SoapUITreeNode treeNode) {
            if (treeNode == null) {
                SoapUI.this.setOverviewPanel(null);
            } else {
                PanelBuilder<ModelItem> panelBuilder;
                ModelItem modelItem = treeNode.getModelItem();
                if (this.selectedPropertyHolderTable != null) {
                    this.selectedPropertyHolderTable.release();
                    this.selectedPropertyHolderTable = null;
                }
                if (modelItem instanceof TestPropertyHolder && (!(modelItem instanceof WsdlProject) || ((WsdlProject)modelItem).isOpen())) {
                    this.selectedPropertyHolderTable = new PropertyHolderTable((TestPropertyHolder)((Object)modelItem));
                    if (modelItem instanceof WsdlProject) {
                        WsdlProject project = (WsdlProject)modelItem;
                        EnvironmentListener environmentListener = new EnvironmentListener(){

                            public void propertyValueChanged(Property property) {
                                InternalNavigatorListener.this.selectedPropertyHolderTable.getPropertiesModel().fireTableDataChanged();
                            }
                        };
                        project.addEnvironmentListener(environmentListener);
                        this.selectedPropertyHolderTable.setEnvironmentListener(environmentListener);
                        project.addProjectListener(this.selectedPropertyHolderTable.getProjectListener());
                    }
                }
                if ((panelBuilder = PanelBuilderRegistry.getPanelBuilder(modelItem)) != null && panelBuilder.hasOverviewPanel()) {
                    Component overviewPanel = panelBuilder.buildOverviewPanel(modelItem);
                    if (this.selectedPropertyHolderTable != null) {
                        JTabbedPane tabs = new JTabbedPane();
                        if (overviewPanel instanceof JPropertiesTable) {
                            JPropertiesTable t = (JPropertiesTable)overviewPanel;
                            tabs.addTab(t.getTitle(), overviewPanel);
                            t.setTitle(null);
                        } else {
                            tabs.addTab("Overview", overviewPanel);
                        }
                        tabs.addTab(((TestPropertyHolder)((Object)modelItem)).getPropertiesLabel(), this.selectedPropertyHolderTable);
                        overviewPanel = UISupport.createTabPanel(tabs, false);
                    }
                    SoapUI.this.setOverviewPanel(overviewPanel);
                } else {
                    SoapUI.this.setOverviewPanel(null);
                }
            }
        }
    }

    private final class MainFrameWindowListener
    extends WindowAdapter {
        private MainFrameWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (SoapUI.this.onExit()) {
                frame.dispose();
            }
        }

        public void windowClosed(WindowEvent e) {
            System.out.println("exiting..");
            System.exit(0);
        }
    }

    private final class InternalDesktopListener
    extends DesktopListenerAdapter {
        private InternalDesktopListener() {
        }

        public void desktopPanelSelected(DesktopPanel desktopPanel) {
            ModelItem modelItem = desktopPanel.getModelItem();
            if (modelItem != null) {
                navigator.selectModelItem(modelItem);
            }
        }
    }

    private static final class RestProjectCreator
    implements Runnable {
        private final URL arg;

        public RestProjectCreator(URL arg) {
            this.arg = arg;
        }

        public void run() {
            try {
                WsdlProject project = (WsdlProject)SoapUI.getWorkspace().createProject(this.arg.getHost(), null);
                SoapUIAction<WsdlProject> action = SoapUI.getActionRegistry().getAction("NewRestServiceAction");
                if (action != null) {
                    action.perform(project, this.arg);
                }
            }
            catch (SoapUIException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class WsdlProjectCreator
    implements Runnable {
        private final String arg;

        public WsdlProjectCreator(String arg) {
            this.arg = arg;
        }

        public void run() {
            SoapUIAction<Workspace> action = SoapUI.getActionRegistry().getAction("NewWsdlProjectAction");
            if (action != null) {
                action.perform(SoapUI.getWorkspace(), this.arg);
            }
        }
    }

    private static final class SoapUIRunner
    implements Runnable {
        private SoapUIRunner() {
        }

        public void run() {
            Properties props = new Properties();
            try {
                props.load(SoapUI.class.getResourceAsStream(SoapUI.SOAPUI_TITLE));
                String brandedTitleExt = props.getProperty("soapui.app.title");
                brandedTitleExt = !StringUtils.isNullOrEmpty(brandedTitleExt) ? " - " + brandedTitleExt : "";
                SoapUI.startSoapUI(mainArgs, "soapUI " + SOAPUI_VERSION + " " + brandedTitleExt, SoapUI.SOAPUI_SPLASH, new StandaloneSoapUICore(true));
                if (SoapUI.isAutoUpdateVersion()) {
                    new SoapUIVersionUpdate().checkForNewVersion(false);
                }
                CajoServer.getInstance().start();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

