/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SwingSoapUICore;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.ui.desktop.DesktopRegistry;
import com.eviware.soapui.ui.desktop.standalone.StandaloneDesktopFactory;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import com.jniwrapper.PlatformContext;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalTheme;

public class StandaloneSoapUICore
extends SwingSoapUICore {
    public StandaloneSoapUICore(boolean init) {
        if (init) {
            this.init("soapui-settings.xml");
        }
    }

    public StandaloneSoapUICore(String settingsFile) {
        super(null, settingsFile);
    }

    public StandaloneSoapUICore(boolean init, boolean settingPassword, String soapUISettingsPassword) {
        super(true, soapUISettingsPassword);
        if (init) {
            this.init("soapui-settings.xml");
        }
    }

    public void prepareUI() {
        super.prepareUI();
        this.initSoapUILookAndFeel();
        DesktopRegistry.getInstance().addDesktop("Default", new StandaloneDesktopFactory());
        ToolTipManager.sharedInstance().setEnabled(!this.getSettings().getBoolean(UISettings.DISABLE_TOOLTIPS));
    }

    public void initSoapUILookAndFeel() {
        try {
            if (Tools.isMac()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                this.getSettings().setBoolean(UISettings.NATIVE_LAF, true);
                log.info((Object)"Defaulting to native L&F for Mac OS X");
            } else if (!SoapUI.isJXBrowserDisabled(true) && PlatformContext.isMacOS()) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else if (this.getSettings().getBoolean(UISettings.NATIVE_LAF)) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                SoapUITheme theme = new SoapUITheme();
                PlasticXPLookAndFeel.setCurrentTheme((MetalTheme)((Object)theme));
                PlasticXPLookAndFeel.setTabStyle((String)"Metal");
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
                UIManager.put("TabbedPane.tabAreaInsets", new Insets(3, 2, 0, 0));
                UIManager.put("TabbedPane.unselectedBackground", new Color(220, 220, 220));
                UIManager.put("TabbedPane.selected", new Color(240, 240, 240));
                PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)theme);
            }
        }
        catch (Throwable e) {
            System.err.println("Error initializing PlasticXPLookAndFeel; " + e.getMessage());
        }
    }

    public static class SoapUITheme
    extends SkyBluer {
        public static final Color BACKGROUND_COLOR = new Color(240, 240, 240);

        public ColorUIResource getControl() {
            return new ColorUIResource(BACKGROUND_COLOR);
        }

        public ColorUIResource getMenuBackground() {
            return this.getControl();
        }

        public ColorUIResource getMenuItemBackground() {
            return new ColorUIResource(new Color(248, 248, 248));
        }
    }
}

