/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.integration.exporter.ProjectExporter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportProjectAction
extends AbstractSoapUIAction<WsdlProject> {
    public ExportProjectAction() {
        super("Export Project", "Export Project");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        ProjectExporter exporter = new ProjectExporter(project);
        try {
            String path = project.getPath();
            if (path == null) {
                project.save();
            } else {
                File file = UISupport.getFileDialogs().saveAs(this, "Select file to export project", "zip", "zip", new File(System.getProperty("user.home")));
                if (file == null) {
                    return;
                }
                String fileName = file.getAbsolutePath();
                if (fileName == null) {
                    return;
                }
                exporter.exportProject(fileName);
            }
        }
        catch (Exception e1) {
            UISupport.showErrorMessage("Failed to export project; " + e1);
        }
    }
}

