/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.InterfaceConfig;
import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.config.WsdlInterfaceConfig;
import com.eviware.soapui.impl.InterfaceFactory;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlImporter;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.SoapUIException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlInterfaceFactory
implements InterfaceFactory<WsdlInterface> {
    public static final String WSDL_TYPE = "wsdl";
    private static final Logger log = Logger.getLogger(WsdlInterfaceFactory.class);

    @Override
    public WsdlInterface build(WsdlProject project, InterfaceConfig config) {
        return new WsdlInterface(project, (WsdlInterfaceConfig)config.changeType(WsdlInterfaceConfig.type));
    }

    @Override
    public WsdlInterface createNew(WsdlProject project, String name) {
        WsdlInterface iface = new WsdlInterface(project, (WsdlInterfaceConfig)((ProjectConfig)project.getConfig()).addNewInterface().changeType(WsdlInterfaceConfig.type));
        iface.setName(name);
        return iface;
    }

    public static WsdlInterface[] importWsdl(WsdlProject project, String url, boolean createRequests) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(project, url, createRequests, null, null);
    }

    public static WsdlInterface[] importWsdl(WsdlProject project, String url, boolean createRequests, WsdlLoader wsdlLoader) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(project, url, createRequests, null, wsdlLoader);
    }

    public static WsdlInterface[] importWsdl(WsdlProject project, String url, boolean createRequests, QName bindingName, WsdlLoader wsdlLoader) throws SoapUIException {
        WsdlInterface[] result;
        DefaultPropertyExpansionContext context = new DefaultPropertyExpansionContext(project.getModelItem());
        url = PropertyExpander.expandProperties(context, url);
        try {
            result = WsdlImporter.importWsdl(project, url, bindingName, wsdlLoader);
        }
        catch (InvalidDefinitionException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Error importing wsdl: " + e));
            SoapUI.logError(e);
            throw new SoapUIException("Error importing wsdl", e);
        }
        try {
            if (createRequests && result != null) {
                for (WsdlInterface iface : result) {
                    for (int c = 0; c < iface.getOperationCount(); ++c) {
                        WsdlOperation operation = iface.getOperationAt(c);
                        WsdlRequest request = operation.addNewRequest("Request 1");
                        try {
                            String requestContent = operation.createRequest(project.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS));
                            request.setRequestContent(requestContent);
                            continue;
                        }
                        catch (Exception e) {
                            SoapUI.logError(e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error creating requests: " + e.getMessage()));
            throw new SoapUIException("Error creating requests", e);
        }
        return result;
    }
}

