/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.actions.service.GenerateRestTestSuiteAction;
import com.eviware.soapui.impl.rest.support.WadlImporter;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateWsdlTestSuiteAction;
import com.eviware.soapui.impl.wsdl.actions.project.CreateWebTestAction;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWsdlProjectAction
extends AbstractSoapUIAction<WorkspaceImpl> {
    public static final String SOAPUI_ACTION_ID = "NewWsdlProjectAction";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(NewWsdlProjectAction.class);

    public NewWsdlProjectAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WorkspaceImpl workspace, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setValue(Form.CREATEREQUEST, Boolean.toString(true));
            this.dialog.getFormField(Form.INITIALWSDL).addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    String value = newValue.toLowerCase().trim();
                    NewWsdlProjectAction.this.dialog.getFormField(Form.CREATEREQUEST).setEnabled(value.length() > 0 && !newValue.endsWith(".wadl"));
                    NewWsdlProjectAction.this.dialog.getFormField(Form.GENERATEMOCKSERVICE).setEnabled(newValue.trim().length() > 0 && !newValue.endsWith(".wadl"));
                    NewWsdlProjectAction.this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(newValue.trim().length() > 0);
                    NewWsdlProjectAction.this.dialog.getFormField(Form.ADDRESTSERVICE).setEnabled(newValue.trim().length() == 0);
                    NewWsdlProjectAction.this.initProjectName(newValue);
                }
            });
        } else {
            this.dialog.setValue(Form.INITIALWSDL, "");
            this.dialog.setValue(Form.PROJECTNAME, "");
            this.dialog.setBooleanValue(Form.ADDRESTSERVICE, false);
            this.dialog.getFormField(Form.CREATEREQUEST).setEnabled(false);
            this.dialog.getFormField(Form.GENERATEMOCKSERVICE).setEnabled(false);
            this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(false);
            this.dialog.getFormField(Form.ADDRESTSERVICE).setEnabled(true);
        }
        if (param instanceof String) {
            this.dialog.setValue(Form.INITIALWSDL, param.toString());
            this.initProjectName(param.toString());
        }
        while (this.dialog.show()) {
            WsdlProject project = null;
            try {
                String projectName = this.dialog.getValue(Form.PROJECTNAME).trim();
                if (projectName.length() == 0) {
                    UISupport.showErrorMessage(messages.get("MissingProjectNameError"));
                    continue;
                }
                project = workspace.createProject(projectName, null);
                if (project == null) continue;
                UISupport.select(project);
                String url = this.dialog.getValue(Form.INITIALWSDL).trim();
                if (this.dialog.getBooleanValue(Form.RELATIVEPATHS)) {
                    String folder = workspace.getProjectRoot();
                    if (PathUtils.isFilePath(url) && PathUtils.isAbsolutePath(url)) {
                        folder = new File(url).getParent().toString();
                    }
                    if (!project.save(folder)) {
                        UISupport.showErrorMessage("Project was not saved, paths will not be stored relatively until configured.");
                    } else {
                        project.setResourceRoot("${projectDir}");
                    }
                }
                if (url.length() > 0) {
                    if (new File(url).exists()) {
                        url = new File(url).toURI().toURL().toString();
                    }
                    if (url.toUpperCase().endsWith("WADL")) {
                        this.importWadl(project, url);
                    } else {
                        this.importWsdl(project, url);
                    }
                } else if (this.dialog.getBooleanValue(Form.ADDRESTSERVICE)) {
                    SoapUI.getActionRegistry().getAction("NewRestServiceAction").perform(project, project);
                }
                if (!this.dialog.getBooleanValue(Form.CREATEWEBTEST)) break;
                new CreateWebTestAction().perform(project, param);
                break;
            }
            catch (InvalidDefinitionException ex) {
                ex.show();
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
                if (project == null) continue;
                workspace.removeProject(project);
            }
        }
    }

    public void initProjectName(String newValue) {
        if (StringUtils.isNullOrEmpty(this.dialog.getValue(Form.PROJECTNAME)) && StringUtils.hasContent(newValue)) {
            int ix = newValue.lastIndexOf(46);
            if (ix > 0) {
                newValue = newValue.substring(0, ix);
            }
            if ((ix = newValue.lastIndexOf(47)) == -1) {
                ix = newValue.lastIndexOf(92);
            }
            if (ix != -1) {
                this.dialog.setValue(Form.PROJECTNAME, newValue.substring(ix + 1));
            }
        }
    }

    private void importWadl(WsdlProject project, String url) {
        RestService restService = (RestService)project.addNewInterface(project.getName(), "rest");
        UISupport.select(restService);
        try {
            new WadlImporter(restService).initFromWadl(url);
            if (this.dialog.getBooleanValue(Form.GENERATETESTSUITE)) {
                GenerateRestTestSuiteAction generateTestSuiteAction = new GenerateRestTestSuiteAction();
                generateTestSuiteAction.generateTestSuite(restService, true);
            }
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    private void importWsdl(WsdlProject project, String url) throws SoapUIException {
        WsdlInterface[] results;
        for (WsdlInterface iface : results = WsdlInterfaceFactory.importWsdl(project, url, this.dialog.getValue(Form.CREATEREQUEST).equals("true"))) {
            UISupport.select(iface);
            if (this.dialog.getBooleanValue(Form.GENERATETESTSUITE)) {
                GenerateWsdlTestSuiteAction generateTestSuiteAction = new GenerateWsdlTestSuiteAction();
                generateTestSuiteAction.generateTestSuite(iface, true);
            }
            if (!this.dialog.getBooleanValue(Form.GENERATEMOCKSERVICE)) continue;
            GenerateMockServiceAction generateMockAction = new GenerateMockServiceAction();
            generateMockAction.generateMockService(iface, false);
        }
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/userguide/projects/index.html#Creating_a_WSDL_Projects", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.ProjectName.Description", type=AField.AFieldType.STRING)
        public static final String PROJECTNAME = messages.get("Form.ProjectName.Label");
        @AField(description="Form.InitialWsdl.Description", type=AField.AFieldType.FILE)
        public static final String INITIALWSDL = messages.get("Form.InitialWsdl.Label");
        @AField(description="Form.CreateRequests.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String CREATEREQUEST = messages.get("Form.CreateRequests.Label");
        @AField(description="Form.GenerateTestSuite.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATETESTSUITE = messages.get("Form.GenerateTestSuite.Label");
        @AField(description="Form.GenerateMockService.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATEMOCKSERVICE = messages.get("Form.GenerateMockService.Label");
        @AField(description="Form.AddRestService.Description", type=AField.AFieldType.BOOLEAN, enabled=true)
        public static final String ADDRESTSERVICE = messages.get("Form.AddRestService.Label");
        @AField(description="Form.RelativePaths.Description", type=AField.AFieldType.BOOLEAN, enabled=true)
        public static final String RELATIVEPATHS = messages.get("Form.RelativePaths.Label");
        @AField(description="Form.CreateWebTest.Description", type=AField.AFieldType.BOOLEAN, enabled=true)
        public static final String CREATEWEBTEST = messages.get("Form.CreateWebTest.Label");
    }
}

