/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRestRequestDesktopPanel<T extends ModelItem, T2 extends RestRequestInterface>
extends AbstractHttpXmlRequestDesktopPanel<T, T2> {
    private boolean updatingRequest;
    private JUndoableTextField pathTextField;
    private JComboBox acceptCombo;
    private JLabel pathLabel;
    private boolean updating;
    private InternalTestPropertyListener testPropertyListener = new InternalTestPropertyListener();
    private RestParamPropertyChangeListener restParamPropertyChangeListener = new RestParamPropertyChangeListener();
    private JComboBox pathCombo;

    public AbstractRestRequestDesktopPanel(T modelItem, T2 requestItem) {
        super(modelItem, requestItem);
        if (requestItem.getResource() != null) {
            requestItem.getResource().addPropertyChangeListener(this);
        }
        requestItem.addTestPropertyListener(this.testPropertyListener);
        for (TestProperty param : requestItem.getParams().getProperties().values()) {
            ((RestParamProperty)param).addPropertyChangeListener(this.restParamPropertyChangeListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateFullPathLabel();
        if (evt.getPropertyName().equals("accept") && !this.updatingRequest) {
            this.acceptCombo.setSelectedItem(evt.getNewValue());
        } else if (evt.getPropertyName().equals("responseMediaTypes") && !this.updatingRequest) {
            Object item = this.acceptCombo.getSelectedItem();
            this.acceptCombo.setModel(new DefaultComboBoxModel<Object>((Object[])evt.getNewValue()));
            this.acceptCombo.setSelectedItem(item);
        } else if ((evt.getPropertyName().equals("path") || evt.getPropertyName().equals("restMethod")) && (((RestRequestInterface)this.getRequest()).getResource() == null || ((RestRequestInterface)this.getRequest()).getResource() == evt.getSource())) {
            if (this.pathLabel != null) {
                this.updateFullPathLabel();
            }
            if (!this.updating && this.pathTextField != null) {
                this.updating = true;
                this.pathTextField.setText((String)evt.getNewValue());
                this.pathTextField.setToolTipText(this.pathTextField.getText());
                this.updating = false;
            }
        }
        super.propertyChange(evt);
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        return ((RestRequestInterface)this.getRequest()).submit(new WsdlSubmitContext((ModelItem)this.getModelItem()), true);
    }

    @Override
    protected String getHelpUrl() {
        return null;
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        if (((RestRequestInterface)this.getRequest()).getResource() == null) {
            this.addToolbarComponents(toolbar);
        }
    }

    @Override
    protected JComponent buildToolbar() {
        if (((RestRequestInterface)this.getRequest()).getResource() != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)super.buildToolbar(), "North");
            JXToolBar toolbar = UISupport.createToolbar();
            this.addToolbarComponents(toolbar);
            panel.add((Component)toolbar, "South");
            return panel;
        }
        return super.buildToolbar();
    }

    protected void addToolbarComponents(JXToolBar toolbar) {
        toolbar.addSeparator();
        if (((RestRequestInterface)this.getRequest()).getResource() != null) {
            this.acceptCombo = new JComboBox<String>(((RestRequestInterface)this.getRequest()).getResponseMediaTypes());
            this.acceptCombo.setEditable(true);
            this.acceptCombo.setToolTipText("Sets accepted encoding(s) for response");
            this.acceptCombo.setSelectedItem(((RestRequestInterface)this.getRequest()).getAccept());
            this.acceptCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    AbstractRestRequestDesktopPanel.this.updatingRequest = true;
                    ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).setAccept(String.valueOf(AbstractRestRequestDesktopPanel.this.acceptCombo.getSelectedItem()));
                    AbstractRestRequestDesktopPanel.this.updatingRequest = false;
                }
            });
            toolbar.addLabeledFixed("Accept", this.acceptCombo);
            toolbar.addSeparator();
            if (this.getRequest() instanceof RestTestRequestInterface) {
                this.pathCombo = new JComboBox(new PathComboBoxModel());
                this.pathCombo.setRenderer(new RestMethodListCellRenderer());
                this.pathCombo.setPreferredSize(new Dimension(200, 20));
                this.pathCombo.setSelectedItem(((RestRequestInterface)this.getRequest()).getRestMethod());
                toolbar.addLabeledFixed("Resource/Method:", this.pathCombo);
                toolbar.addSeparator();
            } else {
                toolbar.add(new JLabel("Full Path: "));
            }
            this.pathLabel = new JLabel();
            this.updateFullPathLabel();
            toolbar.add(this.pathLabel);
        } else {
            this.pathTextField = new JUndoableTextField();
            this.pathTextField.setPreferredSize(new Dimension(300, 20));
            this.pathTextField.setText(((RestRequestInterface)this.getRequest()).getPath());
            this.pathTextField.setToolTipText(this.pathTextField.getText());
            this.pathTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

                public void update(Document document) {
                    if (AbstractRestRequestDesktopPanel.this.updating) {
                        return;
                    }
                    AbstractRestRequestDesktopPanel.this.updating = true;
                    ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).setPath(AbstractRestRequestDesktopPanel.this.pathTextField.getText());
                    AbstractRestRequestDesktopPanel.this.updating = false;
                }
            });
            PropertyExpansionPopupListener.enable(this.pathTextField, this.getModelItem());
            toolbar.addLabeledFixed("Request URL:", this.pathTextField);
        }
        toolbar.addSeparator();
    }

    @Override
    protected boolean release() {
        if (((RestRequestInterface)this.getRequest()).getResource() != null) {
            ((RestRequestInterface)this.getRequest()).getResource().removePropertyChangeListener(this);
        }
        ((RestRequestInterface)this.getRequest()).removeTestPropertyListener(this.testPropertyListener);
        for (TestProperty param : ((RestRequestInterface)this.getRequest()).getParams().getProperties().values()) {
            ((RestParamProperty)param).removePropertyChangeListener(this.restParamPropertyChangeListener);
        }
        return super.release();
    }

    private void updateFullPathLabel() {
        if (this.pathLabel != null && ((RestRequestInterface)this.getRequest()).getResource() != null) {
            String text = RestUtils.expandPath(((RestRequestInterface)this.getRequest()).getResource().getFullPath(), ((RestRequestInterface)this.getRequest()).getParams(), (RestRequestInterface)this.getRequest());
            this.pathLabel.setText("[" + text + "]");
            this.pathLabel.setToolTipText(text);
        }
    }

    private class RestMethodListCellRenderer
    extends DefaultListCellRenderer {
        private RestMethodListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof RestMethod) {
                RestMethod item = (RestMethod)value;
                this.setIcon(item.getIcon());
                this.setText(item.getResource().getName() + " -> " + item.getName());
            }
            return result;
        }
    }

    private class PathComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private PathComboBoxModel() {
        }

        public int getSize() {
            int sz = 0;
            for (RestResource resource : ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).getResource().getService().getAllResources()) {
                sz += resource.getRestMethodCount();
            }
            return sz;
        }

        public Object getElementAt(int index) {
            int sz = 0;
            for (RestResource resource : ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).getResource().getService().getAllResources()) {
                if (index < sz + resource.getRestMethodCount()) {
                    return resource.getRestMethodAt(index - sz);
                }
                sz += resource.getRestMethodCount();
            }
            return null;
        }

        public void setSelectedItem(Object anItem) {
            ((RestTestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).getTestStep().setRestMethod((RestMethod)anItem);
        }

        public Object getSelectedItem() {
            return ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).getRestMethod();
        }
    }

    private class RestParamPropertyChangeListener
    implements PropertyChangeListener {
        private RestParamPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractRestRequestDesktopPanel.this.updateFullPathLabel();
        }
    }

    private class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
            AbstractRestRequestDesktopPanel.this.updateFullPathLabel();
        }

        public void propertyAdded(String name) {
            AbstractRestRequestDesktopPanel.this.updateFullPathLabel();
            ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).getParams().getProperty(name).addPropertyChangeListener(AbstractRestRequestDesktopPanel.this.restParamPropertyChangeListener);
        }

        public void propertyRemoved(String name) {
            AbstractRestRequestDesktopPanel.this.updateFullPathLabel();
        }

        public void propertyRenamed(String oldName, String newName) {
            AbstractRestRequestDesktopPanel.this.updateFullPathLabel();
        }
    }
}

