/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.html;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.BrowserComponent;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHtmlResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private HttpRequestInterface<?> httpRequest;
    private JPanel panel;
    private BrowserComponent browser;
    private JToggleButton recordButton;
    private boolean recordHttpTrafic;
    private MessageExchangeModelItem messageExchangeModelItem;
    private boolean hasResponseForRecording;

    public boolean isRecordHttpTrafic() {
        return this.recordHttpTrafic;
    }

    public void setRecordHttpTrafic(boolean recordHttpTrafic) {
        if (SoapUI.isJXBrowserDisabled() || recordHttpTrafic == this.recordHttpTrafic) {
            return;
        }
        if (recordHttpTrafic) {
            this.recordButton.setIcon(UISupport.createImageIcon("/record_http_true.gif"));
            this.recordButton.setToolTipText("Stop recording");
            this.recordButton.setSelected(true);
            this.browser.setRecordingHttpHtmlResponseView(this);
        } else {
            this.browser.setRecordingHttpHtmlResponseView(null);
            this.recordButton.setIcon(UISupport.createImageIcon("/record_http_false.gif"));
            this.recordButton.setToolTipText("Start recording");
            this.recordButton.setSelected(false);
        }
        this.recordHttpTrafic = recordHttpTrafic;
    }

    public HttpHtmlResponseView(AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("HTML", httpRequestMessageEditor, "HTML Response");
        this.httpRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    public HttpHtmlResponseView(XmlEditor xmlEditor, MessageExchangeModelItem messageExchangeModelItem) {
        super("HTML", xmlEditor, "HTML Response");
        this.messageExchangeModelItem = messageExchangeModelItem;
        this.httpRequest = (HttpRequestInterface)((Object)messageExchangeModelItem);
        messageExchangeModelItem.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            if (SoapUI.isJXBrowserDisabled()) {
                this.panel.add(new JLabel("Browser Component is disabled"));
            } else {
                this.browser = new BrowserComponent(false, true);
                Component component = this.browser.getComponent();
                component.setMinimumSize(new Dimension(100, 100));
                this.panel.add(this.buildToolbar(), "North");
                this.panel.add(component, "Center");
                HttpResponse response = this.httpRequest.getResponse();
                if (response != null) {
                    this.setEditorContent(response);
                }
            }
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        if (this.browser != null) {
            this.browser.release();
        }
        if (this.messageExchangeModelItem != null) {
            this.messageExchangeModelItem.removePropertyChangeListener(this);
        } else {
            this.httpRequest.removePropertyChangeListener(this);
        }
        this.httpRequest = null;
        this.messageExchangeModelItem = null;
    }

    protected void setEditorContent(HttpResponse httpResponse) {
        if (httpResponse != null && httpResponse.getContentAsString() != null) {
            String contentType = httpResponse.getContentType();
            if (contentType != null) {
                if (this.isSupportedContentType(contentType)) {
                    try {
                        String ext = ContentTypeHandler.getExtensionForContentType(contentType);
                        File temp = File.createTempFile("response", "." + ext);
                        FileOutputStream fileOutputStream = new FileOutputStream(temp);
                        this.writeHttpBody(httpResponse.getRawResponseData(), fileOutputStream);
                        fileOutputStream.close();
                        this.browser.navigate(temp.toURI().toURL().toString(), null);
                        temp.deleteOnExit();
                        this.hasResponseForRecording = true;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.browser.setContent(new String(httpResponse.getContentAsString().getBytes("utf-8")), httpResponse.getURL().toURI().toString());
                        this.hasResponseForRecording = true;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.browser.setContent("unsupported content-type [" + contentType + "]");
                this.hasResponseForRecording = false;
            }
        } else {
            this.browser.setContent("<missing content>");
            this.hasResponseForRecording = false;
        }
    }

    private boolean isSupportedContentType(String contentType) {
        return contentType != null && contentType.trim().toLowerCase().startsWith("image");
    }

    private void writeHttpBody(byte[] rawResponse, FileOutputStream out) throws IOException {
        byte[] divider = "\r\n\r\n".getBytes();
        for (int index = 0; index < rawResponse.length - divider.length; ++index) {
            int i;
            for (i = 0; i < divider.length && rawResponse[index + i] == divider[i]; ++i) {
            }
            if (i != divider.length) continue;
            out.write(rawResponse, index + divider.length, rawResponse.length - (index + divider.length));
            return;
        }
        out.write(rawResponse);
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.recordButton = new JToggleButton(new RecordHttpTraficAction());
        toolbar.addLabeledFixed("Record HTTP trafic", this.recordButton);
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractHttpRequestInterface.RESPONSE_PROPERTY) && this.browser != null) {
            this.setEditorContent((HttpResponse)evt.getNewValue());
        }
    }

    @Override
    public void setXml(String xml) {
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }

    public HttpRequestInterface<?> getHttpRequest() {
        return this.httpRequest;
    }

    private class RecordHttpTraficAction
    extends AbstractAction {
        public RecordHttpTraficAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/record_http_false.gif"));
            this.putValue("ShortDescription", "Start recording");
        }

        public void actionPerformed(ActionEvent arg0) {
            if (HttpHtmlResponseView.this.browser == null) {
                return;
            }
            if (HttpHtmlResponseView.this.isRecordHttpTrafic()) {
                HttpHtmlResponseView.this.setRecordHttpTrafic(false);
            } else {
                if (!HttpHtmlResponseView.this.hasResponseForRecording) {
                    try {
                        HttpHtmlResponseView.this.getHttpRequest().submit(new WsdlSubmitContext(HttpHtmlResponseView.this.getHttpRequest()), false).waitUntilFinished();
                    }
                    catch (Request.SubmitException e) {
                        SoapUI.logError(e);
                    }
                }
                HttpHtmlResponseView.this.setRecordHttpTrafic(true);
            }
        }
    }
}

