/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.SchemaSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;

public class Context {
    private ConflictHandler handler;
    private XmlCursor cursor;
    private SchemaSystem system;
    private List<String> path;
    private List<List<String>> stack;
    private Map<String, String> attributes;

    public Context(SchemaSystem system, ConflictHandler handler, XmlCursor cursor) {
        this.system = system;
        this.handler = handler;
        this.cursor = cursor;
        this.path = new ArrayList<String>();
        this.stack = new ArrayList<List<String>>();
        this.attributes = new HashMap<String, String>();
    }

    public ConflictHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        String path = this.getPath().replace("/", "_");
        int parts = 2;
        int i = path.length();
        while (parts > 0 && i > 0) {
            if (path.charAt(--i) != '_') continue;
            --parts;
        }
        if (parts > 0) {
            return path;
        }
        return path.substring(i + 1);
    }

    public String getAttribute(String key) {
        if (this.attributes.containsKey(key)) {
            return this.attributes.get(key);
        }
        return "";
    }

    public void putAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void clearAttribute(String key) {
        this.attributes.remove(key);
    }

    public String getPath() {
        StringBuilder s = new StringBuilder();
        for (String item : this.path) {
            s.append("/" + item);
        }
        return s.toString();
    }

    public void pushPath() {
        this.stack.add(this.path);
        this.path = new ArrayList<String>();
    }

    public void popPath() {
        int last = this.stack.size() - 1;
        if (last >= 0) {
            this.path = this.stack.get(last);
            this.stack.remove(last);
        }
    }

    public void cd(String item) {
        this.path.add(item);
    }

    public void up() {
        if (this.path.size() > 0) {
            this.path.remove(this.path.size() - 1);
        }
    }

    public XmlCursor getCursor() {
        return this.cursor;
    }

    public SchemaSystem getSchemaSystem() {
        return this.system;
    }
}

