/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.support;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.InferredSchema;
import com.eviware.soapui.impl.wadl.inference.schema.SchemaSystem;
import com.eviware.soapui.impl.wadl.inference.support.AllowAll;
import com.eviware.soapui.impl.wadl.inference.support.DenyAll;
import com.eviware.soapui.inferredSchema.SchemaSetConfig;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class InferredSchemaImpl
implements InferredSchema {
    private SchemaSystem ss;

    public InferredSchemaImpl() {
        this.ss = new SchemaSystem();
    }

    public InferredSchemaImpl(InputStream is) throws XmlException, IOException {
        this.ss = new SchemaSystem(SchemaSetConfig.Factory.parse(is));
    }

    public String[] getNamespaces() {
        return this.ss.getNamespaces().toArray(new String[0]);
    }

    public SchemaTypeSystem getSchemaTypeSystem() {
        return this.getSchemaTypeSystem(XmlBeans.getBuiltinTypeSystem());
    }

    public SchemaTypeSystem getSchemaTypeSystem(SchemaTypeSystem sts) {
        ArrayList<XmlObject> schemas = new ArrayList<XmlObject>();
        try {
            for (String namespace : this.getNamespaces()) {
                schemas.add(XmlUtils.createXmlObject(this.getXsdForNamespace(namespace).toString()));
            }
            return XmlBeans.compileXsd((SchemaTypeSystem)sts, (XmlObject[])schemas.toArray(new XmlObject[0]), (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
        }
        catch (XmlException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getXsdForNamespace(String namespace) {
        return this.ss.getSchemaForNamespace(namespace).toString();
    }

    public void learningValidate(XmlObject xml, ConflictHandler handler) throws XmlException {
        this.ss.validate(xml, handler);
    }

    public void processValidXml(XmlObject xml) throws XmlException {
        this.ss.validate(xml, new AllowAll());
    }

    public void save(OutputStream os) throws IOException {
        SchemaSetConfig xml = SchemaSetConfig.Factory.newInstance();
        this.ss.save(xml);
        xml.save(os);
    }

    public boolean validate(XmlObject xml) {
        try {
            this.ss.validate(xml, new DenyAll());
            return true;
        }
        catch (XmlException e) {
            return false;
        }
    }

    public void deleteNamespace(String ns) {
        this.ss.deleteNamespace(ns);
    }
}

